/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import jeffdallama.features.item.ModItems;
import jeffdallama.features.util.AdvancedItemUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class ModBucketRenderer
extends BlockEntityWithoutLevelRenderer {
    public ModBucketRenderer() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }

    public void m_108829_(@NotNull ItemStack pStack, @NotNull ItemDisplayContext context, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int light, int overlay) {
        boolean gui;
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        Fluid fluid = AdvancedItemUtil.getSpecsFluidStack(pStack).getFluid();
        ItemStack base = new ItemStack((ItemLike)fluid.m_6859_());
        ItemStack temp = new ItemStack((ItemLike)ModItems.ELYTRA_MODULE.get());
        if (!AdvancedItemUtil.getSpecsDrink(pStack).equals("Empty")) {
            base = new ItemStack((ItemLike)Items.f_42455_);
        }
        if (AdvancedItemUtil.getSpecsBlock(pStack) != Blocks.f_50016_) {
            base = new ItemStack((ItemLike)Items.f_151055_);
        }
        ResourceLocation toploc = ResourceLocation.fromNamespaceAndPath((String)"functionalfeatures", (String)"item/advanced_bucket");
        TextureAtlasSprite topsprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(toploc);
        TextureAtlasSprite basesprite = itemRenderer.m_174264_(base, null, null, 0).getParticleIcon(ModelData.EMPTY);
        switch (context) {
            case GUI: 
            case GROUND: 
            case FIXED: {
                boolean bl = true;
                break;
            }
            default: {
                boolean bl = gui = false;
            }
        }
        if (gui) {
            ModBucketRenderer.renderSpriteAsQuad(poseStack, buffer, basesprite, light, overlay);
            ModBucketRenderer.renderSpriteAsQuad(poseStack, buffer, topsprite, light, overlay);
        } else {
            this.addModel(this.getModel(base), base, poseStack, context, buffer, light, overlay);
            this.addModel(this.getModel(temp), temp, poseStack, context, buffer, light, overlay);
        }
    }

    public BakedModel getModel(ItemStack stack) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        return itemRenderer.m_174264_(stack, null, null, 0);
    }

    public void addModel(BakedModel model, ItemStack stack, PoseStack poseStack, ItemDisplayContext context, MultiBufferSource buffer, int light, int num) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        itemRenderer.m_115143_(stack, context, false, poseStack, buffer, light, num, model);
        poseStack.m_85849_();
    }

    public static void renderSpriteAsQuad(PoseStack poseStack, MultiBufferSource buffer, TextureAtlasSprite sprite, int light, int overlay) {
        poseStack.m_85836_();
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110497_((ResourceLocation)TextureAtlas.f_118259_));
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float minU = sprite.m_118409_();
        float maxU = sprite.m_118410_();
        float minV = sprite.m_118411_();
        float maxV = sprite.m_118412_();
        consumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_86008_(overlay).m_85969_(light).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_86008_(overlay).m_85969_(light).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(maxU, minV).m_86008_(overlay).m_85969_(light).m_5752_();
        consumer.m_252986_(matrix, 0.0f, 1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(minU, minV).m_86008_(overlay).m_85969_(light).m_5752_();
        poseStack.m_85849_();
    }
}

