/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedElytraLayer<T extends LivingEntity, M extends EntityModel<T>>
extends ElytraLayer<T, M> {
    private final ElytraModel<T> elytraModel;

    public AdvancedElytraLayer(RenderLayerParent pRenderer, EntityModelSet pModelSet) {
        super(pRenderer, pModelSet);
        this.elytraModel = new ElytraModel(pModelSet.m_171103_(ModelLayers.f_171141_));
    }

    public void m_6494_(@NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        ItemStack itemstack = pLivingEntity.m_6844_(EquipmentSlot.CHEST);
        if (this.shouldRender(itemstack, (LivingEntity)pLivingEntity)) {
            AbstractClientPlayer abstractclientplayer;
            ResourceLocation resourcelocation = pLivingEntity instanceof AbstractClientPlayer ? ((abstractclientplayer = (AbstractClientPlayer)pLivingEntity).m_108562_() && abstractclientplayer.m_108563_() != null ? abstractclientplayer.m_108563_() : (abstractclientplayer.m_108555_() && abstractclientplayer.m_108561_() != null && abstractclientplayer.m_36170_(PlayerModelPart.CAPE) ? abstractclientplayer.m_108561_() : this.getElytraTexture(itemstack, pLivingEntity))) : this.getElytraTexture(itemstack, pLivingEntity);
            pPoseStack.m_85836_();
            pPoseStack.m_252880_(0.0f, -0.05f, 0.13f);
            this.m_117386_().m_102624_(this.elytraModel);
            this.elytraModel.m_6973_(pLivingEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
            VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)pBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)resourcelocation), (boolean)false, (boolean)itemstack.m_41790_());
            this.elytraModel.m_7695_(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            pPoseStack.m_85849_();
        }
    }

    @NotNull
    public ResourceLocation getElytraTexture(ItemStack stack, @NotNull T entity) {
        String filename = "elytra_iron.png";
        CompoundTag tags = stack.m_41784_();
        if (!tags.m_128441_("Armor")) {
            return ResourceLocation.fromNamespaceAndPath((String)"functionalfeatures", (String)"textures/entity/elytra_empty.png");
        }
        ItemStack armor = ItemStack.m_41712_((CompoundTag)tags.m_128469_("Armor"));
        Item item = armor.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            ArmorMaterial material = armorItem.m_40401_();
            if (material == ArmorMaterials.NETHERITE) {
                filename = "elytra_netherite.png";
            }
            if (material == ArmorMaterials.DIAMOND) {
                filename = "elytra_diamond.png";
            }
        }
        return ResourceLocation.fromNamespaceAndPath((String)"functionalfeatures", (String)("textures/entity/" + filename));
    }
}

