/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.event;

import java.util.List;
import jeffdallama.features.block.entity.ModBlockEntities;
import jeffdallama.features.client.renderer.blockentity.TinkerStationBlockRenderer;
import jeffdallama.features.client.renderer.entity.layers.AdvancedElytraLayer;
import jeffdallama.features.item.ModItems;
import jeffdallama.features.item.custom.AdvancedBucketItem;
import jeffdallama.features.item.custom.AdvancedBundleItem;
import jeffdallama.features.util.AdvancedItemUtil;
import jeffdallama.features.util.KeyBindings;
import jeffdallama.features.util.ModuleUtil;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientRegistrationEvents {
    @SubscribeEvent
    public static void onKeyRegister(RegisterKeyMappingsEvent event) {
        event.register(KeyBindings.ACTIVATE_KEY);
        event.register(KeyBindings.ELYTRA_BOOST_KEY);
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, layer) -> {
            Potion potion = PotionUtils.m_43579_((ItemStack)stack);
            if (layer == 0 && potion != Potions.f_43598_) {
                return PotionUtils.m_43575_((ItemStack)stack);
            }
            return 0xFFFFFF;
        }, new ItemLike[]{(ItemLike)ModItems.ADVANCED_POTION.get(), (ItemLike)ModItems.SPLASH_AMMO.get(), (ItemLike)ModItems.LINGER_AMMO.get()});
        event.register((stack, layer) -> {
            Item patt2572$temp = stack.m_41720_();
            if (patt2572$temp instanceof AdvancedBucketItem) {
                AdvancedBucketItem bucket = (AdvancedBucketItem)patt2572$temp;
                if (layer == 1) {
                    return bucket.m_142159_(stack);
                }
            }
            return 0xFFFFFF;
        }, new ItemLike[]{(ItemLike)ModItems.ADVANCED_BUCKET.get()});
    }

    @SubscribeEvent
    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        for (String skintype : List.of("default", "slim")) {
            PlayerRenderer renderer = (PlayerRenderer)event.getSkin(skintype);
            if (renderer == null) continue;
            renderer.m_115326_(new AdvancedElytraLayer((RenderLayerParent)renderer, event.getEntityModels()));
        }
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.TINKER_STATION_ENTITY.get(), TinkerStationBlockRenderer::new);
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        ItemProperties.register((Item)((Item)ModItems.ADVANCED_POTION.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"functionalfeatures", (String)"flask"), (stack, level, entity, seed) -> {
            Potion potion = PotionUtils.m_43579_((ItemStack)stack);
            Item contents = AdvancedItemUtil.getSpecsContents(stack).m_41720_();
            if (potion == Potions.f_43598_ && contents == Items.f_41852_) {
                return 1.0f;
            }
            if (contents == Items.f_42787_) {
                return 2.0f;
            }
            if (contents == Items.f_42735_) {
                return 3.0f;
            }
            return 0.0f;
        });
        ItemProperties.register((Item)((Item)ModItems.LINGER_AMMO.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"functionalfeatures", (String)"linger_ammo"), (stack, level, entity, seed) -> {
            Potion potion = PotionUtils.m_43579_((ItemStack)stack);
            if (potion == Potions.f_43598_) {
                return 1.0f;
            }
            return 0.0f;
        });
        ItemProperties.register((Item)((Item)ModItems.SPLASH_AMMO.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"functionalfeatures", (String)"splash_ammo"), (stack, level, entity, seed) -> {
            Potion potion = PotionUtils.m_43579_((ItemStack)stack);
            if (potion == Potions.f_43598_) {
                return 1.0f;
            }
            return 0.0f;
        });
        ItemProperties.register((Item)Items.f_42739_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"functionalfeatures", (String)"linger"), (stack, level, entity, seed) -> {
            CompoundTag tag = stack.m_41784_();
            boolean flask = false;
            if (tag.m_128441_("flask")) {
                flask = tag.m_128471_("flask");
            }
            if (flask) {
                return 1.0f;
            }
            return 0.0f;
        });
        ItemProperties.register((Item)((Item)ModItems.ADVANCED_BUCKET.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"functionalfeatures", (String)"bucket"), (stack, level, entity, seed) -> {
            Item patt5840$temp = stack.m_41720_();
            if (patt5840$temp instanceof AdvancedBucketItem) {
                AdvancedBucketItem bucket = (AdvancedBucketItem)patt5840$temp;
                if (bucket.getEmpty(stack)) {
                    return 1.0f;
                }
                if (AdvancedItemUtil.getSpecsBlock(stack) == Blocks.f_152499_) {
                    return 2.0f;
                }
            }
            return 0.0f;
        });
        ItemProperties.register((Item)((Item)ModItems.ADVANCED_BUCKET_EMPTY.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"functionalfeatures", (String)"bucket"), (stack, level, entity, seed) -> {
            Item patt6404$temp = stack.m_41720_();
            if (patt6404$temp instanceof AdvancedBucketItem) {
                AdvancedBucketItem bucket = (AdvancedBucketItem)patt6404$temp;
                if (bucket.getEmpty(stack)) {
                    return 1.0f;
                }
                if (AdvancedItemUtil.getSpecsBlock(stack) == Blocks.f_152499_) {
                    return 2.0f;
                }
            }
            return 0.0f;
        });
        ItemProperties.register((Item)((Item)ModItems.ADVANCED_BUNDLE.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"functionalfeatures", (String)"bundle"), (stack, level, entity, seed) -> {
            float temp = 0.0f;
            if (stack.m_41720_() instanceof AdvancedBundleItem && ModuleUtil.hasModule(stack, (Item)ModItems.QUIVER_MODULE.get())) {
                temp = 2.0f;
            }
            if (stack.m_41720_() instanceof AdvancedBundleItem && !AdvancedBundleItem.getContentList(stack).isEmpty()) {
                temp += 1.0f;
            }
            return temp;
        });
        ItemProperties.register((Item)Items.f_42741_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"functionalfeatures", (String)"elytra"), (stack, level, entity, seed) -> {
            CompoundTag tags = stack.m_41784_();
            if (!tags.m_128441_("Armor")) {
                return 0.0f;
            }
            ItemStack armor = ItemStack.m_41712_((CompoundTag)tags.m_128469_("Armor"));
            Item patt7872$temp = armor.m_41720_();
            if (patt7872$temp instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)patt7872$temp;
                ArmorMaterial material = armorItem.m_40401_();
                if (material == ArmorMaterials.NETHERITE) {
                    return 3.0f;
                }
                if (material == ArmorMaterials.DIAMOND) {
                    return 2.0f;
                }
                return 1.0f;
            }
            return 0.0f;
        });
    }
}

