/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.event;

import com.mojang.blaze3d.platform.InputConstants;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jeffdallama.features.item.ModItems;
import jeffdallama.features.item.custom.AdvancedBucketItem;
import jeffdallama.features.item.custom.AdvancedBundleItem;
import jeffdallama.features.item.custom.AdvancedPotionItem;
import jeffdallama.features.item.custom.HorseshoeItem;
import jeffdallama.features.item.custom.arrows.AdvancedArrowItem;
import jeffdallama.features.item.custom.modules.QuiverModuleItem;
import jeffdallama.features.item.enchantments.ModEnchantments;
import jeffdallama.features.mixin.HorseAccessorMixin;
import jeffdallama.features.networking.ModMessages;
import jeffdallama.features.util.AdvancedItemUtil;
import jeffdallama.features.util.ModTags;
import jeffdallama.features.util.ModuleUtil;
import jeffdallama.features.util.Tweaks;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.brewing.PotionBrewEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingGetProjectileEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="functionalfeatures", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MainEvents {
    private static int tick = 0;

    @SubscribeEvent
    public static void onItemPickup(PlayerEvent.ItemPickupEvent event) {
        Player player = event.getEntity();
        Inventory inventory = player.m_150109_();
        ItemStack picked = event.getStack();
        ItemStack copy = picked.m_41777_();
        ArrayList<ItemStack> bundles = new ArrayList<ItemStack>();
        ItemStack quiver = null;
        int counter = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack2 = inventory.m_8020_(i);
            if (stack2.m_41720_() instanceof AdvancedBundleItem && ModuleUtil.hasModule(stack2, (Item)ModItems.PICKUP_MODULE.get())) {
                if (ModuleUtil.hasModule(stack2, (Item)ModItems.QUIVER_MODULE.get())) {
                    if (quiver == null) {
                        quiver = stack2;
                    }
                } else {
                    bundles.add(stack2);
                }
            }
            if (ItemStack.m_150942_((ItemStack)stack2, (ItemStack)picked)) {
                ++counter;
            }
            if (counter != 2) continue;
            return;
        }
        if (picked.m_41720_() instanceof ArrowItem || picked.m_204117_(ModTags.Items.ALL_AMMMOS)) {
            if (quiver == null) {
                return;
            }
            boolean repeat = true;
            while (repeat) {
                repeat = AdvancedBundleItem.tryAdd(quiver, picked);
            }
        } else {
            block2: for (ItemStack bundle : bundles) {
                List<ItemStack> contents = AdvancedBundleItem.getContentList(bundle);
                for (ItemStack content : contents) {
                    if (!ItemStack.m_150942_((ItemStack)picked, (ItemStack)content)) continue;
                    boolean repeat = true;
                    while (repeat) {
                        repeat = AdvancedBundleItem.tryAdd(bundle, picked);
                    }
                    continue block2;
                }
            }
            if (!picked.m_41619_()) {
                for (ItemStack bundle : bundles) {
                    boolean repeat = true;
                    while (repeat) {
                        repeat = AdvancedBundleItem.tryAdd(bundle, picked);
                    }
                    if (!picked.m_41619_()) continue;
                    break;
                }
            }
        }
        int toRemove = copy.m_41613_() - picked.m_41613_();
        inventory.m_36022_(stack -> ItemStack.m_150942_((ItemStack)stack, (ItemStack)copy), toRemove, (Container)inventory);
        player.f_36095_.m_38946_();
    }

    @SubscribeEvent
    public static void onVillager(VillagerTradesEvent event) {
        VillagerProfession profession = event.getType();
        Int2ObjectMap trades = event.getTrades();
        if (profession == VillagerProfession.f_35586_) {
            Tweaks.addTrade(new ItemStack((ItemLike)Items.f_42616_, 12), new ItemStack((ItemLike)ModItems.SPUR_MODULE.get()), 8, 1, 0.05f, (List)trades.get(1));
            Tweaks.addTrade(new ItemStack((ItemLike)Items.f_42416_, 4), new ItemStack((ItemLike)Items.f_42616_, 24), new ItemStack((ItemLike)ModItems.HORSESHOE_IRON.get()), 8, 2, 0.05f, (List)trades.get(3));
            Tweaks.addTrade(new ItemStack((ItemLike)Items.f_42417_, 4), new ItemStack((ItemLike)Items.f_42616_, 32), new ItemStack((ItemLike)ModItems.HORSESHOE_GOLD.get()), 8, 2, 0.05f, (List)trades.get(3));
            Tweaks.addTrade(new ItemStack((ItemLike)Items.f_42415_, 4), new ItemStack((ItemLike)Items.f_42616_, 44), new ItemStack((ItemLike)ModItems.HORSESHOE_DIAMOND.get()), 8, 2, 0.05f, (List)trades.get(3));
        }
    }

    @SubscribeEvent
    public static void onPotionBrew(PotionBrewEvent.Pre event) {
        int i;
        boolean bulkFlag = false;
        int stones = 0;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (i = 0; i < 3; ++i) {
            list.add(event.getItem(i));
        }
        for (i = 0; i < 3; ++i) {
            if (((ItemStack)list.get(i)).m_41720_() instanceof AdvancedPotionItem) {
                bulkFlag = true;
            }
            if (!((ItemStack)list.get(i)).m_150930_((Item)ModItems.ALCHEMY_STONE.get())) continue;
            ++stones;
        }
        if (bulkFlag) {
            if (stones < 2) {
                event.setCanceled(true);
            } else {
                for (i = 0; i < 3; ++i) {
                    if (!((ItemStack)list.get(i)).m_150930_((Item)ModItems.ALCHEMY_STONE.get())) continue;
                    event.setItem(i, ItemStack.f_41583_);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPotionBrew(PotionBrewEvent.Post event) {
        for (int i = 0; i < 3; ++i) {
            if (!event.getItem(i).m_150930_((Item)ModItems.ALCHEMY_STONE.get())) continue;
            ItemStack stone = event.getItem(i);
            if (stone.m_220157_(1, RandomSource.m_216327_(), null)) {
                stone = ItemStack.f_41583_;
            }
            event.setItem(i, stone);
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractHorse) {
            SimpleContainer inventory;
            ItemStack stack;
            AbstractHorse horse = (AbstractHorse)livingEntity;
            if (event.getSource().m_276093_(DamageTypes.f_268671_) && (stack = (inventory = ((HorseAccessorMixin)horse).getInventory()).m_8020_(2)).m_41720_() instanceof HorseshoeItem) {
                int lvl = 0;
                if (stack.getAllEnchantments().containsKey(Enchantments.f_44967_)) {
                    lvl += ((Integer)stack.getAllEnchantments().get(Enchantments.f_44967_)).intValue();
                }
                if (stack.getAllEnchantments().containsKey(ModEnchantments.PRANCE.get())) {
                    lvl += ((Integer)stack.getAllEnchantments().get(ModEnchantments.PRANCE.get())).intValue();
                }
                float modifier = 1.0f - Math.min(0.9f, (float)lvl * 0.2f);
                float damage = event.getAmount();
                if (modifier != 1.0f) {
                    if ((damage *= modifier) < 2.0f) {
                        damage = 0.0f;
                    }
                    event.setAmount(damage);
                }
                stack.m_220157_(2, RandomSource.m_216327_(), null);
                inventory.m_6836_(2, stack);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingEntityTick(LivingEvent.LivingTickEvent event) {
        AbstractHorse horse;
        ItemStack stack;
        Item item;
        LivingEntity livingentity = event.getEntity();
        Level level = livingentity.m_9236_();
        BlockPos pos = livingentity.m_20183_();
        if (tick % 2 == 1) {
            return;
        }
        if (livingentity instanceof AbstractHorse && (item = (stack = ((HorseAccessorMixin)(horse = (AbstractHorse)livingentity)).getInventory().m_8020_(2)).m_41720_()) instanceof HorseshoeItem) {
            HorseshoeItem shoe = (HorseshoeItem)item;
            if (horse.m_20160_()) {
                int levelSpeed = shoe.getLevelSpeed();
                int levelJump = shoe.getLevelJump();
                if (stack.getAllEnchantments().containsKey(ModEnchantments.PRANCE.get())) {
                    levelJump += ((Integer)stack.getAllEnchantments().get(ModEnchantments.PRANCE.get())).intValue();
                }
                if (levelSpeed != -1) {
                    horse.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 3, levelSpeed, false, false));
                }
                if (levelJump != -1) {
                    horse.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 3, levelJump, false, false));
                }
            }
            if (stack.getAllEnchantments().containsKey(Enchantments.f_44974_)) {
                FrostWalkerEnchantment.m_45018_((LivingEntity)livingentity, (Level)level, (BlockPos)pos, (int)((Integer)stack.getAllEnchantments().get(Enchantments.f_44974_) + 1));
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++tick;
        }
    }

    @SubscribeEvent
    public static void onArrowHit(ProjectileImpactEvent event) {
        Projectile entity = event.getProjectile();
        if (entity instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)entity;
            System.out.println();
            ItemStack arrowStack = AdvancedItemUtil.getArrowItem(arrow);
            Item item = arrowStack.m_41720_();
            if (item instanceof AdvancedArrowItem) {
                AdvancedArrowItem advanced = (AdvancedArrowItem)item;
                HitResult hit = event.getRayTraceResult();
                switch (hit.m_6662_()) {
                    case BLOCK: {
                        advanced.impactBlock(arrow);
                        break;
                    }
                    case ENTITY: {
                        advanced.impactEntity(arrow, ((EntityHitResult)hit).m_82443_());
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onCraftEvent(PlayerEvent.ItemCraftedEvent event) {
        Container matrix = event.getInventory();
        for (int i = 0; i < matrix.m_6643_(); ++i) {
            ItemStack ingridient = matrix.m_8020_(i);
            System.out.println(ingridient);
            if (ingridient.m_150930_((Item)ModItems.ADVANCED_BUCKET.get())) {
                ingridient = ((AdvancedBucketItem)ingridient.m_41720_()).getConsume(ingridient, event.getEntity());
                ingridient.m_41769_(1);
            }
            if (!ingridient.m_150930_((Item)ModItems.ADVANCED_POTION.get())) continue;
            ingridient = ((AdvancedPotionItem)ingridient.m_41720_()).getConsume(ingridient, event.getEntity());
            ingridient.m_41769_(1);
        }
    }

    @SubscribeEvent
    public static void onArrowLoose(ArrowLooseEvent event) {
        Player entity = event.getEntity();
        ItemStack weapon = event.getBow();
        if (weapon.m_41720_() instanceof CrossbowItem) {
            CompoundTag tags = weapon.m_41784_();
            tags.m_128405_("LoadState", 0);
            return;
        }
        if (entity instanceof Player) {
            Player player = entity;
            ItemStack bundleQuiver = ModuleUtil.getItemStackHasModule(player, (Item)ModItems.QUIVER_MODULE.get());
            if (bundleQuiver.m_41619_() || !(bundleQuiver.m_41720_() instanceof AdvancedBundleItem)) {
                return;
            }
            List<ItemStack> contents = AdvancedBundleItem.getContentList(bundleQuiver);
            if (contents.isEmpty()) {
                return;
            }
            ItemStack ammoNew = QuiverModuleItem.checkAmmo(weapon, contents);
            contents.remove(ammoNew);
            if (ammoNew == null || ammoNew.m_41619_()) {
                return;
            }
            ammoNew.m_41774_(1);
            if (!ammoNew.m_41619_()) {
                contents.add(0, ammoNew);
            }
            bundleQuiver.m_41784_().m_128365_("Items", (Tag)AdvancedItemUtil.getItemListTag(contents));
        }
        System.out.println("LOOSE: " + event.getEntity());
    }

    @SubscribeEvent
    public static void onGettingProjectile(LivingGetProjectileEvent event) {
        ItemStack weapon = event.getProjectileWeaponItemStack();
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack bundleQuiver = ModuleUtil.getItemStackHasModule(player, (Item)ModItems.QUIVER_MODULE.get());
            if (bundleQuiver.m_41619_() || !(bundleQuiver.m_41720_() instanceof AdvancedBundleItem)) {
                return;
            }
            List<ItemStack> contents = AdvancedBundleItem.getContentList(bundleQuiver);
            if (contents.isEmpty()) {
                return;
            }
            ItemStack ammoNew = QuiverModuleItem.checkAmmo(weapon, contents);
            if (ammoNew.m_41619_()) {
                return;
            }
            event.setProjectileItemStack(ammoNew.m_41777_());
            if (weapon.m_41720_() instanceof CrossbowItem) {
                CompoundTag tags = weapon.m_41784_();
                int loadState = 0;
                if (tags.m_128441_("LoadState")) {
                    loadState = tags.m_128451_("LoadState");
                }
                if (loadState == 1) {
                    ammoNew.m_41774_(1);
                    loadState = 2;
                } else if (loadState == 0) {
                    loadState = 1;
                }
                tags.m_128405_("LoadState", loadState);
            }
            if (!ammoNew.m_41619_()) {
                contents.add(0, ammoNew);
            }
            bundleQuiver.m_41784_().m_128365_("Items", (Tag)AdvancedItemUtil.getItemListTag(contents));
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        ItemEntity itemEntity;
        ItemStack itemstack;
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity && ModuleUtil.hasModule(itemstack = (itemEntity = (ItemEntity)entity).m_32055_(), (Item)ModItems.NETHERITE_MODULE.get())) {
            itemEntity.m_20331_(true);
            itemEntity.m_20254_(0);
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        boolean keepinventory = level.m_46469_().m_46207_(GameRules.f_46133_);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!keepinventory) {
                CompoundTag CompoundTag2;
                NonNullList inventory = player.m_150109_().f_35974_;
                NonNullList armor = player.m_150109_().f_35975_;
                NonNullList offhand = player.m_150109_().f_35976_;
                ListTag newInventory = new ListTag();
                for (ItemStack extrastack : armor) {
                    if (extrastack.m_41720_() == Items.f_41852_ || !ModuleUtil.hasModule(extrastack, (Item)ModItems.RECOVERY_MODULE.get())) continue;
                    CompoundTag2 = extrastack.m_41739_(new CompoundTag());
                    newInventory.add((Object)CompoundTag2);
                    player.m_150109_().m_36057_(extrastack);
                }
                for (ItemStack extrastack : offhand) {
                    if (extrastack.m_41720_() == Items.f_41852_ || !ModuleUtil.hasModule(extrastack, (Item)ModItems.RECOVERY_MODULE.get())) continue;
                    CompoundTag2 = extrastack.m_41739_(new CompoundTag());
                    newInventory.add((Object)CompoundTag2);
                    player.m_150109_().m_36057_(extrastack);
                }
                if (player.getPersistentData().m_128441_("upgrade_keep")) {
                    System.out.println(player.getPersistentData().m_128423_("upgrade_keep"));
                }
                for (ItemStack itemstack : inventory) {
                    if (!ModuleUtil.hasModule(itemstack, (Item)ModItems.RECOVERY_MODULE.get())) continue;
                    CompoundTag2 = itemstack.m_41739_(new CompoundTag());
                    newInventory.add((Object)CompoundTag2);
                    player.m_150109_().m_36057_(itemstack);
                }
                if (!newInventory.isEmpty()) {
                    player.getPersistentData().m_128365_("upgrade_keep", (Tag)newInventory);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onDrops(LivingDropsEvent event) {
        Player player;
        ItemStack weapon;
        Entity entity;
        DamageSource source = event.getSource();
        if (source.m_276093_(DamageTypes.f_268464_) && (entity = source.m_7639_()) instanceof Player && (weapon = (player = (Player)entity).m_21120_(InteractionHand.MAIN_HAND)).m_204117_(ModTags.Items.WEAPONS) && ModuleUtil.getSpecsActive(weapon) && ModuleUtil.hasModule(weapon, (Item)ModItems.XP_MODULE.get())) {
            LivingEntity target = event.getEntity();
            int basexp = target.m_213860_();
            int looting = event.getLootingLevel();
            double bonusxp = (4.5 + (double)looting) * (double)basexp;
            int finalxp = (int)Math.ceil(bonusxp / 9.0);
            if (bonusxp != 0.0) {
                ExperienceOrb orb = new ExperienceOrb(target.m_9236_(), target.m_20185_(), target.m_20186_(), target.m_20189_(), finalxp);
                target.m_9236_().m_7967_((Entity)orb);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        Llama llama;
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        Entity entity = event.getTarget();
        if (entity instanceof Llama && (llama = (Llama)entity).m_30614_() && event.getEntity().m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            Entity passenger = null;
            if (llama.m_20160_()) {
                passenger = llama.m_146895_();
                if (passenger instanceof Mob) {
                    passenger.m_8127_();
                    llama.m_9236_().m_247517_(null, llama.m_20183_(), SoundEvents.f_12093_, SoundSource.NEUTRAL);
                    event.setCanceled(true);
                }
            } else if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
                BlockPos pos = llama.m_20183_();
                AABB aabb = new AABB(pos).m_82400_(1.5);
                List list = llama.m_9236_().m_45976_(Mob.class, aabb);
                float llamawidth = llama.m_20205_() + 0.25f;
                for (Mob mob : list) {
                    if (mob instanceof Llama || !(llamawidth > mob.m_20205_())) continue;
                    passenger = mob;
                    break;
                }
                if (passenger != null) {
                    passenger.m_7998_((Entity)llama, true);
                    llama.m_9236_().m_247517_(null, llama.m_20183_(), SoundEvents.f_12093_, SoundSource.NEUTRAL);
                    event.setCanceled(true);
                }
            }
        } else {
            Mob mob;
            entity = event.getTarget();
            if (entity instanceof Mob && (mob = (Mob)entity).m_20202_() instanceof Llama) {
                mob.m_8127_();
                mob.m_9236_().m_247517_(null, mob.m_20183_(), SoundEvents.f_12093_, SoundSource.NEUTRAL);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        BlockPos pos = event.getPos();
        BlockHitResult hit = new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Objects.requireNonNull(event.getFace()), pos, false);
        BlockState state = event.getLevel().m_8055_(pos);
        if (state.m_60734_() == Blocks.f_50622_) {
            player2.m_5893_(Tweaks.getFletchingMenuProvider(state, event.getLevel(), pos));
            return;
        }
        ItemStack itemstack = event.getItemStack();
        if (itemstack.m_41720_() == Items.f_41852_) {
            return;
        }
        Map enchantMap = itemstack.getAllEnchantments();
        ArrayList<Enchantment> enchantList = new ArrayList<Enchantment>();
        for (Map.Entry entry : enchantMap.entrySet()) {
            enchantList.add((Enchantment)entry.getKey());
        }
        if (!enchantList.contains(Enchantments.f_44981_)) {
            return;
        }
        UseOnContext context = new UseOnContext(event.getEntity(), event.getHand(), hit);
        if (Tweaks.useOn(context) != InteractionResult.FAIL) {
            itemstack.m_220157_(1, RandomSource.m_216327_(), player2);
            ModMessages.sendSoundPacket(SoundEvents.f_11874_, player2, pos);
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        HitResult hit = player.m_19907_(5.0, 0.0f, false);
        ItemStack stack = event.getItemStack();
        if (stack.m_150930_(Items.f_42613_) && hit.m_6662_() == HitResult.Type.MISS && event.getLevel().m_6425_(player.m_20183_()).m_192917_(Fluids.f_76191_)) {
            SmallFireball ball = new SmallFireball(EntityType.f_20527_, event.getLevel());
            ball.m_6034_(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
            ball.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 0.5f);
            event.getLevel().m_7967_((Entity)ball);
            stack.m_41774_(1);
            player.m_21008_(event.getHand(), ItemStack.f_41583_);
            player.m_21008_(event.getHand(), stack);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        CompoundTag originalData = event.getOriginal().getPersistentData();
        CompoundTag newData = event.getEntity().getPersistentData();
        Player player = event.getEntity();
        if (originalData.m_128441_("upgrade_keep")) {
            ListTag old = originalData.m_128437_("upgrade_keep", 10);
            for (Tag oldTag : old) {
                CompoundTag compoundTag = (CompoundTag)oldTag;
                ItemStack itemStack = ItemStack.m_41712_((CompoundTag)compoundTag);
                player.m_150109_().m_36054_(itemStack);
            }
            CompoundTag empty = new CompoundTag();
            newData.m_128365_("upgrade_keep", (Tag)empty);
        }
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack itemstack = event.getItemStack();
        boolean addCustomFromTags = false;
        if (itemstack.m_41782_()) {
            CompoundTag tags = itemstack.m_41784_();
            boolean upgrades = itemstack.m_204117_(ModTags.Items.TIERED_UPGRADABLE);
            boolean modules = tags.m_128441_("modules") && !ModuleUtil.getSpecsModules(itemstack).isEmpty();
            boolean bl = addCustomFromTags = itemstack.m_204117_(ModTags.Items.ALL_UPGRADABLE) && (upgrades || modules);
        }
        if (addCustomFromTags || itemstack.m_204117_(ModTags.Items.TIERED_UPGRADABLE)) {
            AdvancedItemUtil.putTooltip(itemstack, event.getToolTip());
        }
    }
}

