/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.item.custom;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import jeffdallama.features.item.ModItems;
import jeffdallama.features.item.custom.TieredVolumeItem;
import jeffdallama.features.util.AdvancedItemUtil;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AdvancedBowlItem
extends Item
implements TieredVolumeItem {
    public AdvancedBowlItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public ItemStack getFinalBowl(ItemStack bowl, ItemStack contents, Player player, boolean pickup, boolean success) {
        ItemStack output;
        if (!success) {
            return bowl;
        }
        ItemStack backup = bowl.m_41777_();
        if (!player.m_150110_().f_35937_) {
            backup.m_41774_(1);
        }
        int volume = AdvancedItemUtil.getSpecsVolume(bowl)[0];
        volume = pickup ? ++volume : --volume;
        if (volume < 1) {
            contents = new ItemStack((ItemLike)Items.f_41852_);
            volume = 0;
        }
        CompoundTag tags = bowl.m_41784_();
        tags.m_128365_("Contents", (Tag)contents.m_41739_(new CompoundTag()));
        tags.m_128405_("volume", volume);
        if (volume == 0) {
            output = new ItemStack((ItemLike)ModItems.ADVANCED_BUCKET_EMPTY.get());
            tags.m_128473_("Contents");
        } else {
            output = new ItemStack((ItemLike)ModItems.ADVANCED_BUCKET.get());
        }
        output.m_41751_(tags);
        if (!this.getEmpty(output) && bowl.m_41613_() != 1 || player.m_150110_().f_35937_) {
            player.m_150109_().m_36054_(output);
            return backup;
        }
        return output;
    }

    @Override
    public ItemStack getConsume(ItemStack bottle, Player player) {
        Item item = bottle.m_41720_();
        if (item instanceof AdvancedBowlItem) {
            AdvancedBowlItem bowlItem = (AdvancedBowlItem)item;
            return bowlItem.getFinalBowl(bottle, AdvancedItemUtil.getSpecsContents(bottle), player, false, true);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public ItemStack getFill(ItemStack bottle, Player player) {
        Item item = bottle.m_41720_();
        if (item instanceof AdvancedBowlItem) {
            AdvancedBowlItem bowlItem = (AdvancedBowlItem)item;
            return bowlItem.getFinalBowl(bottle, AdvancedItemUtil.getSpecsContents(bottle), player, true, true);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean getEmpty(ItemStack bowl) {
        Item contents = AdvancedItemUtil.getSpecsContents(bowl).m_41720_();
        return contents == Items.f_41852_;
    }

    @Override
    public Map<String, Item> getTierMap() {
        HashMap<String, Item> map = new HashMap<String, Item>();
        map.put("max", (Item)ModItems.IRON_ALLOY.get());
        return map;
    }

    @Override
    public Map<String, Integer> getMaxTierMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("max", 2);
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean transfer(boolean OnOther, ItemStack advanced, ItemStack other, Slot slot, Player player, @Nullable SlotAccess access) {
        boolean empty = this.getEmpty(advanced);
        boolean full = this.getFull(advanced);
        ItemStack contents = AdvancedItemUtil.getSpecsContents(advanced);
        if (other.m_41720_() instanceof AdvancedBowlItem) {
            boolean same;
            if (!OnOther) {
                return false;
            }
            ItemStack contentsOther = AdvancedItemUtil.getSpecsContents(other);
            boolean bl = same = contents == contentsOther && !empty;
            if (this.getEmpty(other) && !empty) {
                advanced = this.getConsume(advanced, player);
                slot.m_5852_(this.getFinalBowl(other, contents, player, true, true));
            } else {
                if ((this.getEmpty(other) || !empty) && (!same || full)) return false;
                if (full) {
                    return false;
                }
                advanced = this.getFinalBowl(advanced, contentsOther, player, true, true);
                slot.m_5852_(this.getConsume(other, player));
            }
        } else if (other.m_41720_() == Items.f_42399_) {
            if (empty) {
                return false;
            }
            if (other.m_41613_() == 1) {
                AdvancedItemUtil.returnOther(OnOther, contents, slot, access);
            } else {
                other.m_41774_(1);
                player.m_150109_().m_36054_(contents);
            }
            advanced = this.getConsume(advanced, player);
        } else {
            Item item = other.m_41720_();
            if (!(item instanceof BowlFoodItem)) return false;
            BowlFoodItem foodItem = (BowlFoodItem)item;
            if (!empty && (foodItem != contents.m_41720_() || full)) return false;
            advanced = this.getFinalBowl(advanced, contents, player, true, true);
            AdvancedItemUtil.returnOther(OnOther, new ItemStack((ItemLike)Items.f_42590_), slot, access);
        }
        AdvancedItemUtil.returnDefault(OnOther, advanced, slot, player);
        return true;
    }

    @Override
    public void transferSound(Player player) {
        this.transferSound(player, SoundEvents.f_12073_);
    }

    public boolean m_142207_(@NotNull ItemStack advanced, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        ItemStack other = slot.m_7993_();
        return this.transfer(true, advanced, other, slot, player, null);
    }

    public boolean m_142305_(@NotNull ItemStack advanced, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        return this.transfer(true, advanced, other, slot, player, access);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack bowl = player.m_21120_(hand);
        boolean empty = this.getEmpty(bowl);
        System.out.println(empty);
        System.out.println(bowl);
        if (!empty) {
            return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
        }
        return InteractionResultHolder.m_19100_((Object)bowl);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack bowl, @NotNull Level level, @NotNull LivingEntity entity) {
        Item item;
        System.out.println("FINISH");
        Player player = entity instanceof Player ? (Player)entity : null;
        ItemStack contents = AdvancedItemUtil.getSpecsContents(bowl);
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, bowl);
        }
        if (!level.f_46443_ && player != null && (item = contents.m_41720_()) instanceof BowlFoodItem) {
            BowlFoodItem foodItem = (BowlFoodItem)item;
            player.m_5584_(level, new ItemStack((ItemLike)foodItem));
            System.out.println("EAT");
        }
        if (player != null) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        return this.getConsume(bowl, player);
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return 32;
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack itemstack, @NotNull Player player, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        if (AdvancedItemUtil.getSpecsVolume(itemstack)[0] >= AdvancedItemUtil.getSpecsVolume(itemstack)[1]) {
            return InteractionResult.PASS;
        }
        Level level = player.m_9236_();
        boolean flag = false;
        if (target instanceof MushroomCow) {
            boolean bl = flag = target.m_6084_() && !target.m_6162_();
        }
        if (!flag) {
            return InteractionResult.PASS;
        }
        if (this.getEmpty(itemstack) || AdvancedItemUtil.getSpecsContents(itemstack).m_150930_(Items.f_42400_)) {
            ItemStack output = this.getFinalBowl(itemstack, new ItemStack((ItemLike)Items.f_42400_), player, true, true);
            player.m_21008_(hand, output);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.ADVANCED_BUCKET.get());
        ItemStack contents = new ItemStack((ItemLike)Items.f_41852_);
        CompoundTag tags = stack.m_41784_();
        tags.m_128365_("Contents", (Tag)contents.m_41739_(new CompoundTag()));
        stack.m_41751_(tags);
        return stack;
    }

    @NotNull
    public String m_5671_(@NotNull ItemStack bowl) {
        Item contents = AdvancedItemUtil.getSpecsContents(bowl).m_41720_();
        if (contents instanceof BowlFoodItem) {
            BowlFoodItem foodItem = (BowlFoodItem)contents;
            MutableComponent translated = Component.m_237115_((String)foodItem.m_5524_());
            return "Pot of" + translated.getString();
        }
        if (contents != Items.f_41852_) {
            return "Pot";
        }
        return "Empty Pot";
    }

    public boolean m_142522_(@NotNull ItemStack bowl) {
        return !this.getEmpty(bowl);
    }

    public int m_142158_(@NotNull ItemStack itemstack) {
        return this.getBarVolume(itemstack);
    }

    public int m_142159_(@NotNull ItemStack itemstack) {
        return DEFAULT_BAR_COLOR;
    }
}

