/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.item.custom;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import jeffdallama.features.client.renderer.ModBucketRenderer;
import jeffdallama.features.item.ModItems;
import jeffdallama.features.item.custom.TieredVolumeItem;
import jeffdallama.features.util.AdvancedItemUtil;
import jeffdallama.features.util.ModTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AdvancedBucketItem
extends BucketItem
implements TieredVolumeItem {
    public AdvancedBucketItem(Item.Properties pProperties) {
        super(() -> Fluids.f_76191_, pProperties);
    }

    public ItemStack getFinalBucket(ItemStack itemstack, Fluid fluid, Block block, String drink, Player player, boolean pickup, boolean success) {
        ItemStack output;
        if (!success) {
            return itemstack;
        }
        ItemStack backup = itemstack.m_41777_();
        backup.m_41774_(1);
        int volume = AdvancedItemUtil.getSpecsVolume(itemstack)[0];
        volume = pickup ? ++volume : --volume;
        if (volume == 0) {
            fluid = Fluids.f_76191_;
            block = Blocks.f_50016_;
            drink = "Empty";
        }
        FluidStack stack = new FluidStack(fluid, 1000);
        CompoundTag fluidTag = stack.writeToNBT(new CompoundTag());
        String blockTag = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).toString();
        CompoundTag tags = itemstack.m_41784_().m_6426_();
        tags.m_128365_("Fluid", (Tag)fluidTag);
        tags.m_128359_("Block", blockTag);
        tags.m_128359_("Drink", drink);
        tags.m_128405_("volume", volume);
        if (volume == 0) {
            output = new ItemStack((ItemLike)ModItems.ADVANCED_BUCKET_EMPTY.get());
            tags.m_128473_("Fluid");
            tags.m_128473_("Block");
            tags.m_128473_("Drink");
        } else {
            output = new ItemStack((ItemLike)ModItems.ADVANCED_BUCKET.get());
        }
        output.m_41751_(tags);
        if (!this.getEmpty(output) && itemstack.m_41613_() != 1) {
            player.m_150109_().m_36054_(output);
            return backup;
        }
        return output;
    }

    protected void playEmptySound(@Nullable Player pPlayer, LevelAccessor pLevel, BlockPos pPos, Fluid fluid) {
        pLevel.m_5594_(pPlayer, pPos, AdvancedItemUtil.getFluidSound(fluid, pLevel, pPos), SoundSource.BLOCKS, 1.0f, 1.0f);
        pLevel.m_142346_((Entity)pPlayer, GameEvent.f_157769_, pPos);
    }

    public boolean placeBucket(Player player, Level level, BlockPos blockpos, Block blockBucket, Fluid fluid, boolean empty) {
        boolean flag1;
        BlockState blockstate = level.m_8055_(blockpos);
        Block block = blockstate.m_60734_();
        boolean flag = blockstate.m_60722_(fluid);
        if (blockBucket.equals(Blocks.f_152499_)) {
            flag = blockstate.m_204336_(BlockTags.f_278394_);
        }
        boolean bl = flag1 = blockstate.m_60795_() || flag || blockstate.m_204336_(BlockTags.f_144269_) || block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).m_6044_((BlockGetter)level, blockpos, blockstate, fluid);
        if (!flag1) {
            return false;
        }
        if (level.m_6042_().f_63857_() && fluid == Fluids.f_76193_) {
            int i = blockpos.m_123341_();
            int j = blockpos.m_123342_();
            int k = blockpos.m_123343_();
            level.m_5594_(player, blockpos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (!blockBucket.equals(Blocks.f_50016_) && (flag || blockstate.m_60795_())) {
            level.m_46961_(blockpos, true);
            level.m_7731_(blockpos, blockBucket.m_49966_(), 3);
            return true;
        }
        if (blockstate.m_204336_(BlockTags.f_144269_)) {
            if (fluid == Fluids.f_76193_) {
                blockstate = (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3));
            } else if (fluid == Fluids.f_76195_) {
                blockstate = Blocks.f_152477_.m_49966_();
            } else if (blockBucket.equals(Blocks.f_152499_)) {
                blockstate = (BlockState)Blocks.f_152478_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3));
            } else {
                return false;
            }
            level.m_7731_(blockpos, blockstate, 3);
            return true;
        }
        if (block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).m_6044_((BlockGetter)level, blockpos, blockstate, fluid)) {
            ((LiquidBlockContainer)block).m_7361_((LevelAccessor)level, blockpos, blockstate, ((FlowingFluid)fluid).m_76068_(false));
            return true;
        }
        if ((blockstate.m_60795_() || flag) && !empty) {
            level.m_46961_(blockpos, true);
            level.m_7731_(blockpos, fluid.m_76145_().m_76188_(), 3);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getConsume(ItemStack bucket, Player player) {
        Item item = bucket.m_41720_();
        if (item instanceof AdvancedBucketItem) {
            AdvancedBucketItem bucketItem = (AdvancedBucketItem)item;
            return bucketItem.getFinalBucket(bucket, AdvancedItemUtil.getSpecsFluidStack(bucket).getFluid(), AdvancedItemUtil.getSpecsBlock(bucket), AdvancedItemUtil.getSpecsDrink(bucket), player, false, true);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public ItemStack getFill(ItemStack bucket, Player player) {
        Item item = bucket.m_41720_();
        if (item instanceof AdvancedBucketItem) {
            AdvancedBucketItem bucketItem = (AdvancedBucketItem)item;
            return bucketItem.getFinalBucket(bucket, AdvancedItemUtil.getSpecsFluidStack(bucket).getFluid(), AdvancedItemUtil.getSpecsBlock(bucket), AdvancedItemUtil.getSpecsDrink(bucket), player, true, true);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean getEmpty(ItemStack itemstack) {
        Fluid fluidBucket = AdvancedItemUtil.getSpecsFluidStack(itemstack).getFluid();
        Block blockBucket = AdvancedItemUtil.getSpecsBlock(itemstack);
        String drink = AdvancedItemUtil.getSpecsDrink(itemstack);
        return fluidBucket == Fluids.f_76191_ && blockBucket.equals(Blocks.f_50016_) && drink.equals("Empty");
    }

    @Override
    public Map<String, Item> getTierMap() {
        HashMap<String, Item> map = new HashMap<String, Item>();
        map.put("max", (Item)ModItems.IRON_ALLOY.get());
        return map;
    }

    @Override
    public Map<String, Integer> getMaxTierMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("max", 2);
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean transfer(boolean OnOther, ItemStack advanced, ItemStack other, Slot slot, Player player, @Nullable SlotAccess access) {
        boolean empty = this.getEmpty(advanced);
        boolean full = this.getFull(advanced);
        Fluid fluid = AdvancedItemUtil.getSpecsFluidStack(advanced).getFluid();
        Block block = AdvancedItemUtil.getSpecsBlock(advanced);
        String drink = AdvancedItemUtil.getSpecsDrink(advanced);
        if (other.m_41720_() instanceof AdvancedBucketItem) {
            boolean same;
            if (!OnOther) {
                return false;
            }
            Fluid otherfluid = AdvancedItemUtil.getSpecsFluidStack(other).getFluid();
            Block otherblock = AdvancedItemUtil.getSpecsBlock(other);
            String otherdrink = AdvancedItemUtil.getSpecsDrink(other);
            boolean bl = same = fluid == otherfluid && block == otherblock && drink.equals(otherdrink) && !empty;
            if (this.getEmpty(other) && !empty) {
                slot.m_5852_(this.getFinalBucket(other, fluid, block, drink, player, true, true));
                advanced = this.getConsume(advanced, player);
            } else {
                if ((this.getEmpty(other) || !empty) && !same) return false;
                if (full) {
                    return false;
                }
                slot.m_5852_(this.getConsume(other, player));
                advanced = this.getFinalBucket(advanced, otherfluid, otherblock, otherdrink, player, true, true);
            }
        } else {
            Item otherfluid = other.m_41720_();
            if (otherfluid instanceof BucketItem) {
                BucketItem bucket = (BucketItem)otherfluid;
                if (!empty) {
                    if (bucket.getFluid() == Fluids.f_76191_) {
                        if (drink.equals("Milk")) {
                            output = new ItemStack((ItemLike)Items.f_42455_);
                        } else if (block == Blocks.f_152499_) {
                            output = new ItemStack((ItemLike)Items.f_151055_);
                        } else {
                            if (fluid == Fluids.f_76191_) return false;
                            output = new ItemStack((ItemLike)fluid.m_6859_());
                        }
                        advanced = this.getConsume(advanced, player);
                    } else {
                        if (bucket.getFluid() != AdvancedItemUtil.getSpecsFluidStack(advanced).getFluid() || full) return false;
                        output = new ItemStack((ItemLike)Items.f_42446_);
                        advanced = this.getFinalBucket(advanced, fluid, Blocks.f_50016_, "Empty", player, true, true);
                    }
                    if (other.m_41613_() == 1) {
                        AdvancedItemUtil.returnOther(OnOther, (ItemStack)output, slot, access);
                    } else {
                        player.m_150109_().m_36054_((ItemStack)output);
                        other.m_41774_(1);
                    }
                } else {
                    if (bucket.getFluid() == Fluids.f_76191_) {
                        return false;
                    }
                    AdvancedItemUtil.returnOther(OnOther, new ItemStack((ItemLike)Items.f_42446_), slot, access);
                    advanced = this.getFinalBucket(advanced, bucket.getFluid(), Blocks.f_50016_, "Empty", player, true, true);
                }
            } else {
                output = other.m_41720_();
                if (output instanceof SolidBucketItem) {
                    SolidBucketItem solidbucket = (SolidBucketItem)output;
                    Block otherblock = solidbucket.m_40614_();
                    if (block != otherblock && !empty || full) {
                        return false;
                    }
                    AdvancedItemUtil.returnOther(OnOther, new ItemStack((ItemLike)Items.f_42446_), slot, access);
                    advanced = this.getFinalBucket(advanced, Fluids.f_76191_, solidbucket.m_40614_(), "Empty", player, true, true);
                } else {
                    if (other.m_41720_() != Items.f_42455_) return false;
                    if (!drink.equals("Milk") && !empty || full) {
                        return false;
                    }
                    AdvancedItemUtil.returnOther(OnOther, new ItemStack((ItemLike)Items.f_42446_), slot, access);
                    advanced = this.getFinalBucket(advanced, Fluids.f_76191_, Blocks.f_50016_, "Milk", player, true, true);
                }
            }
        }
        AdvancedItemUtil.returnDefault(OnOther, advanced, slot, player);
        Level level = player.m_9236_();
        if (!level.f_46443_) return true;
        if (fluid == Fluids.f_76191_) {
            level.m_5594_(player, player.m_20183_(), SoundEvents.f_144203_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        } else {
            this.playEmptySound(player, (LevelAccessor)level, player.m_20183_(), fluid);
        }
        return true;
    }

    @Override
    public void transferSound(Player player) {
        this.transferSound(player, SoundEvents.f_11781_);
    }

    public boolean m_142207_(@NotNull ItemStack advanced, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        ItemStack other = slot.m_7993_();
        return this.transfer(true, advanced, other, slot, player, null);
    }

    public boolean m_142305_(@NotNull ItemStack advanced, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (other.m_41720_() instanceof AdvancedBucketItem) {
            return false;
        }
        return this.transfer(false, advanced, other, slot, player, access);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        BlockPos blockpos;
        ItemStack itemstack = player.m_21120_(hand);
        Fluid fluidBucket = AdvancedItemUtil.getSpecsFluidStack(itemstack).getFluid();
        Block blockBucket = AdvancedItemUtil.getSpecsBlock(itemstack);
        String drink = AdvancedItemUtil.getSpecsDrink(itemstack);
        int volume = AdvancedItemUtil.getSpecsVolume(itemstack)[0];
        int max = AdvancedItemUtil.getSpecsVolume(itemstack)[1];
        if (drink.equals("Milk")) {
            return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
        }
        boolean pickup = false;
        boolean cauldronTarget = false;
        boolean solidTarget = false;
        boolean full = false;
        boolean empty = this.getEmpty(itemstack);
        if (volume >= max) {
            full = true;
        }
        Fluid targetFluid = Fluids.f_76191_;
        Block targetBlock = Blocks.f_50016_;
        BlockHitResult blockhitresult0 = AdvancedBucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        BlockHitResult blockhitresult = AdvancedBucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (blockhitresult0.m_6662_() == HitResult.Type.BLOCK) {
            blockpos = blockhitresult0.m_82425_();
            BlockState teststate = level.m_8055_(blockpos);
            Block testblock = teststate.m_60734_();
            int cauldronLevel = 0;
            if (teststate.m_60713_(Blocks.f_152476_) || teststate.m_60713_(Blocks.f_152478_)) {
                cauldronLevel = (Integer)level.m_8055_(blockpos).m_61143_((Property)LayeredCauldronBlock.f_153514_);
            }
            solidTarget = teststate.m_204336_(ModTags.Blocks.CAN_SOLID_BUCKET) && (blockBucket.equals(testblock) || empty);
            switch (teststate.m_60734_().toString()) {
                case "Block{minecraft:water_cauldron}": {
                    cauldronTarget = (empty || fluidBucket == Fluids.f_76193_) && cauldronLevel == 3;
                    targetFluid = Fluids.f_76193_;
                    break;
                }
                case "Block{minecraft:powder_snow_cauldron}": {
                    cauldronTarget = (empty || blockBucket.equals(Blocks.f_152499_)) && cauldronLevel == 3;
                    targetBlock = Blocks.f_152499_;
                    break;
                }
                case "Block{minecraft:lava_cauldron}": {
                    cauldronTarget = empty || fluidBucket == Fluids.f_76195_;
                    targetFluid = Fluids.f_76195_;
                }
            }
            boolean bl = pickup = teststate.m_60819_().m_76152_() == fluidBucket && blockBucket.equals(Blocks.f_50016_) || solidTarget || cauldronTarget || empty;
            if (full || player.m_6047_()) {
                pickup = false;
            }
            if (pickup) {
                blockhitresult = blockhitresult0;
            }
        }
        if (blockhitresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        blockpos = blockhitresult.m_82425_();
        Direction direction = blockhitresult.m_82434_();
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        if (level.m_7966_(player, blockpos) && player.m_36204_(blockpos1, direction, itemstack)) {
            BlockPos blockpos2;
            if (pickup) {
                BlockState blockstate1 = level.m_8055_(blockpos);
                Block $$10 = blockstate1.m_60734_();
                if ($$10 instanceof BucketPickup || cauldronTarget || solidTarget) {
                    BlockState blockState;
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    ItemStack itemstack2 = ((Item)ModItems.ADVANCED_BUCKET.get()).m_7968_();
                    if (targetFluid.equals(Fluids.f_76191_)) {
                        targetFluid = blockstate1.m_60819_().m_76152_();
                    }
                    ItemStack output = solidTarget ? this.getFinalBucket(itemstack, Fluids.f_76191_, blockstate1.m_60734_(), "Empty", player, true, true) : this.getFinalBucket(itemstack, targetFluid, targetBlock, "Empty", player, true, true);
                    Optional fluidsound = targetFluid.m_142520_();
                    if (cauldronTarget) {
                        if (fluidsound.isPresent()) {
                            level.m_247517_(player, blockpos, (SoundEvent)fluidsound.get(), SoundSource.BLOCKS);
                        } else {
                            level.m_247517_(player, blockpos, SoundEvents.f_144200_, SoundSource.BLOCKS);
                        }
                        level.m_7731_(blockpos, Blocks.f_50256_.m_49966_(), 3);
                        return InteractionResultHolder.m_19092_((Object)output, (boolean)level.m_5776_());
                    }
                    if (solidTarget) {
                        level.m_247517_(player, blockpos, SoundEvents.f_144200_, SoundSource.BLOCKS);
                        level.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 3);
                        return InteractionResultHolder.m_19092_((Object)output, (boolean)level.m_5776_());
                    }
                    if (fluidsound.isPresent()) {
                        level.m_247517_(player, blockpos, (SoundEvent)fluidsound.get(), SoundSource.BLOCKS);
                    }
                    level.m_142346_((Entity)player, GameEvent.f_157816_, blockpos);
                    if (!level.f_46443_) {
                        CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, itemstack2);
                    }
                    if ((blockState = level.m_8055_(blockpos)).m_61138_((Property)BlockStateProperties.f_61362_)) {
                        level.m_7731_(blockpos, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 3);
                    } else {
                        level.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 3);
                    }
                    return InteractionResultHolder.m_19092_((Object)output, (boolean)level.f_46443_);
                }
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            if (empty || !drink.equals("Empty")) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            BlockState blockstate = level.m_8055_(blockpos);
            BlockPos blockPos = blockpos2 = blockstate.m_60734_() instanceof LiquidBlockContainer && fluidBucket == Fluids.f_76193_ || blockstate.m_204336_(BlockTags.f_144269_) ? blockpos : blockpos1;
            if (this.placeBucket(player, level, blockpos2, blockBucket, fluidBucket, false)) {
                if (fluidBucket == Fluids.f_76191_) {
                    level.m_5594_(player, blockpos2, SoundEvents.f_144203_, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    this.playEmptySound(player, (LevelAccessor)level, blockpos2, fluidBucket);
                }
                this.m_142131_(player, level, itemstack, blockpos2);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, blockpos2, itemstack);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                BlockState tempState = level.m_8055_(blockpos);
                if (!tempState.m_204336_(ModTags.Blocks.CAN_SOLID_BUCKET)) {
                    tempState = Blocks.f_50016_.m_49966_();
                }
                return InteractionResultHolder.m_19092_((Object)this.getFinalBucket(itemstack, fluidBucket, tempState.m_60734_(), drink, player, false, true), (boolean)level.f_46443_);
            }
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack itemstack, @NotNull Level level, @NotNull LivingEntity entity) {
        String drinkString = AdvancedItemUtil.getSpecsDrink(itemstack);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            CriteriaTriggers.f_10592_.m_23682_(serverplayer, itemstack);
            serverplayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        if (!level.f_46443_ && drinkString.equals("Milk")) {
            entity.m_21219_();
        }
        Player player = (Player)entity;
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        ItemStack output = this.getFinalBucket(itemstack, Fluids.f_76191_, Blocks.f_50016_, drinkString, player, false, true);
        itemstack.m_41774_(1);
        return output;
    }

    public int m_8105_(@NotNull ItemStack p_42933_) {
        return 32;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack p_42931_) {
        return UseAnim.DRINK;
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack itemstack, @NotNull Player player, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        if (AdvancedItemUtil.getSpecsVolume(itemstack)[0] >= AdvancedItemUtil.getSpecsVolume(itemstack)[1]) {
            return InteractionResult.PASS;
        }
        Level level = player.m_9236_();
        String drink = AdvancedItemUtil.getSpecsDrink(itemstack);
        String drinkTarget = null;
        if ((target instanceof Cow || target instanceof Goat || target instanceof MushroomCow) && target.m_6084_() && !target.m_6162_()) {
            drinkTarget = "Milk";
        }
        if (drinkTarget == null) {
            return InteractionResult.PASS;
        }
        if (this.getEmpty(itemstack) || drinkTarget.equals(drink)) {
            ItemStack output = this.getFinalBucket(itemstack, Fluids.f_76191_, Blocks.f_50016_, drinkTarget, player, true, true);
            player.m_21008_(hand, output);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            level.m_247517_(null, target.m_20183_(), SoundEvents.f_11833_, SoundSource.NEUTRAL);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private BlockEntityWithoutLevelRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new ModBucketRenderer();
                }
                return this.renderer;
            }
        });
    }

    public boolean m_142522_(@NotNull ItemStack itemstack) {
        return !this.getEmpty(itemstack);
    }

    public int m_142158_(@NotNull ItemStack itemstack) {
        return this.getBarVolume(itemstack);
    }

    public int m_142159_(@NotNull ItemStack itemstack) {
        Fluid fluidBucket = AdvancedItemUtil.getSpecsFluidStack(itemstack).getFluid();
        if (fluidBucket == Fluids.f_76193_) {
            return Mth.m_14159_((float)0.2f, (float)0.38f, (float)0.84f);
        }
        if (fluidBucket == Fluids.f_76195_) {
            return Mth.m_14159_((float)0.98f, (float)0.51f, (float)0.16f);
        }
        Block blockBucket = AdvancedItemUtil.getSpecsBlock(itemstack);
        if (blockBucket.equals(Blocks.f_152499_)) {
            return Mth.m_14159_((float)0.95f, (float)0.95f, (float)0.95f);
        }
        String drink = AdvancedItemUtil.getSpecsDrink(itemstack);
        if (drink.equals("Milk")) {
            return Mth.m_14159_((float)0.95f, (float)0.95f, (float)0.95f);
        }
        return DEFAULT_BAR_COLOR;
    }
}

