/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.item.custom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import jeffdallama.features.item.ModItems;
import jeffdallama.features.item.custom.TieredUpgradableItem;
import jeffdallama.features.util.AdvancedItemUtil;
import jeffdallama.features.util.ModTags;
import jeffdallama.features.util.ModuleUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AdvancedBundleItem
extends BundleItem
implements TieredUpgradableItem {
    public AdvancedBundleItem(Item.Properties pProperties) {
        super(pProperties);
    }

    private static boolean m_150729_(ItemStack bundle, Player player) {
        CompoundTag compoundtag = bundle.m_41784_();
        if (!compoundtag.m_128441_("Items")) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ListTag listtag = compoundtag.m_128437_("Items", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag1 = listtag.m_128728_(i);
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
                player.m_36176_(itemstack, true);
            }
        }
        bundle.m_41749_("Items");
        return true;
    }

    private static int m_150763_(ItemStack bundle, ItemStack addstack) {
        int max = AdvancedItemUtil.getSpecsVolume(bundle)[1];
        if (!addstack.m_41619_() && addstack.m_41720_().m_142095_()) {
            if (ModuleUtil.hasModule(bundle, (Item)ModItems.QUIVER_MODULE.get()) && !(addstack.m_41720_() instanceof ArrowItem) && !addstack.m_204117_(ModTags.Items.ALL_AMMMOS)) {
                return 0;
            }
            CompoundTag compoundtag = bundle.m_41784_();
            if (!compoundtag.m_128441_("Items")) {
                compoundtag.m_128365_("Items", (Tag)new ListTag());
            }
            int weightBundle = AdvancedBundleItem.m_150778_(bundle);
            int weightAdd = AdvancedBundleItem.m_150776_(addstack);
            int addcount = Math.min(addstack.m_41613_(), (max - weightBundle) / weightAdd);
            int optionalcount = 0;
            if (addcount == 0) {
                return 0;
            }
            ListTag listtag = compoundtag.m_128437_("Items", 10);
            Optional<CompoundTag> optional = AdvancedBundleItem.m_150756_(addstack, listtag);
            boolean flag = optional.isPresent();
            if (flag) {
                CompoundTag compoundtag1 = optional.get();
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
                int space = itemstack.m_41720_().getMaxStackSize(itemstack) - itemstack.m_41613_();
                flag = addcount <= space;
                optionalcount = Math.min(addcount, space);
                if (space != 0) {
                    addcount -= optionalcount;
                    itemstack.m_41769_(optionalcount);
                    itemstack.m_41739_(compoundtag1);
                    listtag.remove((Object)compoundtag1);
                    listtag.add(0, (Tag)compoundtag1);
                }
            }
            if (!flag) {
                ItemStack itemstack1 = addstack.m_255036_(addcount);
                CompoundTag compoundtag2 = new CompoundTag();
                itemstack1.m_41739_(compoundtag2);
                listtag.add(0, (Tag)compoundtag2);
            }
            return addcount + optionalcount;
        }
        return 0;
    }

    public static boolean tryAdd(ItemStack bundle, ItemStack addstack) {
        int change = AdvancedBundleItem.m_150763_(bundle, addstack);
        addstack.m_41774_(change);
        return change != 0;
    }

    private static Optional<ItemStack> m_150780_(ItemStack bundle) {
        CompoundTag compoundtag = bundle.m_41784_();
        if (!compoundtag.m_128441_("Items")) {
            return Optional.empty();
        }
        ListTag listtag = compoundtag.m_128437_("Items", 10);
        if (listtag.isEmpty()) {
            return Optional.empty();
        }
        CompoundTag compoundtag1 = listtag.m_128728_(0);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
        listtag.remove(0);
        if (listtag.isEmpty()) {
            bundle.m_41749_("Items");
        }
        return Optional.of(itemstack);
    }

    public static int getVolume(ItemStack itemstack) {
        return AdvancedBundleItem.m_150782_(itemstack).mapToInt(p_186356_ -> AdvancedBundleItem.m_150776_(p_186356_) * p_186356_.m_41613_()).sum();
    }

    private static int m_150776_(ItemStack itemstack) {
        CompoundTag compoundtag;
        if (itemstack.m_150930_(Items.f_151058_)) {
            return 4 + AdvancedBundleItem.m_150778_(itemstack);
        }
        if ((itemstack.m_150930_(Items.f_42786_) || itemstack.m_150930_(Items.f_42785_)) && itemstack.m_41782_() && (compoundtag = BlockItem.m_186336_((ItemStack)itemstack)) != null && !compoundtag.m_128437_("Bees", 10).isEmpty()) {
            return 64;
        }
        return 1;
    }

    private static Stream<ItemStack> m_150782_(ItemStack bundle) {
        CompoundTag compoundtag = bundle.m_41783_();
        if (compoundtag == null) {
            return Stream.empty();
        }
        ListTag listtag = compoundtag.m_128437_("Items", 10);
        return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    public static List<ItemStack> getContentList(ItemStack bundle) {
        CompoundTag compoundtag = bundle.m_41784_();
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        if (compoundtag.m_128441_("Items")) {
            for (Tag tag : compoundtag.m_128437_("Items", 10)) {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)((CompoundTag)tag));
                output.add(stack);
            }
        }
        return output;
    }

    private static int m_150778_(ItemStack itemstack) {
        return AdvancedBundleItem.getVolume(itemstack);
    }

    private static Optional<CompoundTag> m_150756_(ItemStack itemstack, ListTag list) {
        return itemstack.m_150930_(Items.f_151058_) ? Optional.empty() : list.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).filter(p_186350_ -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)p_186350_), (ItemStack)itemstack)).findFirst();
    }

    private void m_186342_(Entity p_186343_) {
        p_186343_.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + p_186343_.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void m_186351_(Entity p_186352_) {
        p_186352_.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + p_186352_.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void m_186353_(Entity p_186354_) {
        p_186354_.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + p_186354_.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    @Override
    public Map<String, Item> getTierMap() {
        HashMap<String, Item> map = new HashMap<String, Item>();
        map.put("max", (Item)ModItems.TOUGH_FABRIC.get());
        return map;
    }

    @Override
    public Map<String, Integer> getMaxTierMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("max", 2);
        return map;
    }

    public boolean m_142207_(@NotNull ItemStack bundle, @NotNull Slot slot, @NotNull ClickAction click, @NotNull Player player) {
        if (click != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack itemstack = slot.m_7993_();
        if (itemstack.m_41619_()) {
            this.m_186342_((Entity)player);
            AdvancedBundleItem.m_150780_(bundle).ifPresent(p_150740_ -> AdvancedBundleItem.m_150763_(bundle, slot.m_150659_(p_150740_)));
        } else if (itemstack.m_41720_().m_142095_()) {
            if (ModuleUtil.hasModule(bundle, (Item)ModItems.QUIVER_MODULE.get()) && !(itemstack.m_41720_() instanceof ArrowItem) && !itemstack.m_204117_(ModTags.Items.ALL_AMMMOS)) {
                return false;
            }
            int max = AdvancedItemUtil.getSpecsVolume(bundle)[1];
            int space = (max - AdvancedBundleItem.m_150778_(bundle)) / AdvancedBundleItem.m_150776_(itemstack);
            if (AdvancedBundleItem.m_150763_(bundle, slot.m_150647_(itemstack.m_41613_(), space, player)) > 0) {
                this.m_186351_((Entity)player);
            }
        }
        return true;
    }

    public boolean m_142305_(@NotNull ItemStack bundle, @NotNull ItemStack itemstack, @NotNull Slot slot, @NotNull ClickAction clickaction, @NotNull Player player, @NotNull SlotAccess access) {
        if (clickaction == ClickAction.SECONDARY && slot.m_150651_(player)) {
            if (itemstack.m_41619_()) {
                AdvancedBundleItem.m_150780_(bundle).ifPresent(p_186347_ -> {
                    this.m_186342_((Entity)player);
                    access.m_142104_(p_186347_);
                });
            } else {
                int i = AdvancedBundleItem.m_150763_(bundle, itemstack);
                if (i > 0) {
                    this.m_186351_((Entity)player);
                    itemstack.m_41774_(i);
                }
            }
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (AdvancedBundleItem.m_150729_(itemstack, player)) {
            this.m_186353_((Entity)player);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        if (ModuleUtil.hasModule(stack, (Item)ModItems.QUIVER_MODULE.get())) {
            return Component.m_237115_((String)"item.functionalfeatures.advanced_bundle.quiver");
        }
        return super.m_7626_(stack);
    }

    public boolean m_142522_(@NotNull ItemStack p_150769_) {
        return AdvancedBundleItem.m_150778_(p_150769_) > 0;
    }

    public int m_142158_(@NotNull ItemStack itemstack) {
        return Math.min(1 + 12 * AdvancedBundleItem.m_150778_(itemstack) / AdvancedItemUtil.getSpecsVolume(itemstack)[1], 13);
    }

    public void m_7373_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
    }
}

