/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.item.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import jeffdallama.features.item.ModItems;
import jeffdallama.features.item.custom.AdvancedBundleItem;
import jeffdallama.features.item.custom.SplashAmmoItem;
import jeffdallama.features.item.custom.TieredVolumeItem;
import jeffdallama.features.item.custom.modules.QuiverModuleItem;
import jeffdallama.features.util.AdvancedItemUtil;
import jeffdallama.features.util.ModTags;
import jeffdallama.features.util.ModuleUtil;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AdvancedPotionItem
extends PotionItem
implements TieredVolumeItem {
    public AdvancedPotionItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> Throw(Level level, Player player, ItemStack bottle, InteractionHand hand) {
        List<ItemStack> contents;
        ItemStack stack = ItemStack.f_41583_;
        ItemStack bundleQuiver = ModuleUtil.getItemStackHasModule(player, (Item)ModItems.QUIVER_MODULE.get());
        if (!bundleQuiver.m_41619_() && bundleQuiver.m_41720_() instanceof AdvancedBundleItem && !(contents = AdvancedBundleItem.getContentList(bundleQuiver)).isEmpty()) {
            ItemStack ammoNew = QuiverModuleItem.checkAmmo(bottle, contents);
            stack = ammoNew.m_41777_();
            ammoNew.m_41774_(1);
            if (!ammoNew.m_41619_()) {
                contents.add(0, ammoNew);
            }
            bundleQuiver.m_41784_().m_128365_("Items", (Tag)AdvancedItemUtil.getItemListTag(contents));
        }
        boolean bundleflag = false;
        if (stack.m_41619_()) {
            stack = this.getAmmo(player);
        } else {
            bundleflag = true;
        }
        Potion potion = PotionUtils.m_43579_((ItemStack)bottle);
        boolean Linger = false;
        if (stack.m_41619_()) {
            return InteractionResultHolder.m_19098_((Object)bottle);
        }
        Item item = stack.m_41720_();
        if (item instanceof SplashAmmoItem) {
            SplashAmmoItem ammo = (SplashAmmoItem)item;
            Linger = ammo.isLinger();
        }
        if (!level.f_46443_) {
            ItemStack throwstack = Linger ? new ItemStack((ItemLike)Items.f_42739_) : new ItemStack((ItemLike)ModItems.SPLASH_AMMO.get());
            CompoundTag tags = throwstack.m_41784_();
            tags.m_128379_("flask", true);
            ThrownPotion thrownpotion = new ThrownPotion(level, (LivingEntity)player);
            thrownpotion.m_37446_(PotionUtils.m_43549_((ItemStack)throwstack, (Potion)potion));
            thrownpotion.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), -20.0f, 0.5f, 1.0f);
            level.m_7967_((Entity)thrownpotion);
            if (!bundleflag) {
                stack.m_41774_(1);
            }
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12437_, SoundSource.PLAYERS, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
        player.m_21008_(hand, this.getFinalBottle(bottle, potion, new ItemStack((ItemLike)Items.f_41852_), player, false, true));
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19098_((Object)bottle);
    }

    public ItemStack getAmmo(Player player) {
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!(stack.m_41720_() instanceof SplashAmmoItem)) continue;
            return stack;
        }
        return player.m_150110_().f_35937_ ? new ItemStack((ItemLike)ModItems.SPLASH_AMMO.get()) : ItemStack.f_41583_;
    }

    public ItemStack getFinalBottle(ItemStack bottle, Potion potion, ItemStack contents, @Nullable Player player, boolean pickup, boolean success) {
        ItemStack output;
        if (!success) {
            return bottle;
        }
        ItemStack backup = bottle.m_41777_();
        backup.m_41774_(1);
        int volume = AdvancedItemUtil.getSpecsVolume(bottle)[0];
        volume = pickup ? ++volume : --volume;
        if (volume < 1) {
            potion = Potions.f_43598_;
            contents = new ItemStack((ItemLike)Items.f_41852_);
            volume = 0;
        }
        ResourceLocation resourcelocation = ForgeRegistries.POTIONS.getKey((Object)potion);
        CompoundTag tags = bottle.m_41784_();
        assert (resourcelocation != null);
        tags.m_128359_("Potion", resourcelocation.toString());
        tags.m_128365_("Contents", (Tag)contents.m_41739_(new CompoundTag()));
        tags.m_128405_("volume", volume);
        if (volume == 0) {
            output = new ItemStack((ItemLike)ModItems.ADVANCED_POTION_EMPTY.get());
            tags.m_128473_("Potion");
            tags.m_128473_("Contents");
        } else {
            output = new ItemStack((ItemLike)ModItems.ADVANCED_POTION.get());
        }
        output.m_41751_(tags);
        if (!this.getEmpty(output) && bottle.m_41613_() != 1 && player != null) {
            player.m_150109_().m_36054_(output);
            return backup;
        }
        return output;
    }

    @Override
    public ItemStack getConsume(ItemStack bottle, @Nullable Player player) {
        Item item = bottle.m_41720_();
        if (item instanceof AdvancedPotionItem) {
            AdvancedPotionItem potionItem = (AdvancedPotionItem)item;
            return potionItem.getFinalBottle(bottle, PotionUtils.m_43579_((ItemStack)bottle), AdvancedItemUtil.getSpecsContents(bottle), player, false, true);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public ItemStack getFill(ItemStack stack, @Nullable Player player) {
        Item item = stack.m_41720_();
        if (item instanceof AdvancedPotionItem) {
            AdvancedPotionItem potionItem = (AdvancedPotionItem)item;
            return potionItem.getFinalBottle(stack, PotionUtils.m_43579_((ItemStack)stack), AdvancedItemUtil.getSpecsContents(stack), player, true, true);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean getEmpty(ItemStack bottle) {
        Potion potion = PotionUtils.m_43579_((ItemStack)bottle);
        Item contents = AdvancedItemUtil.getSpecsContents(bottle).m_41720_();
        return potion == Potions.f_43598_ && contents == Items.f_41852_;
    }

    @Override
    public Map<String, Item> getTierMap() {
        HashMap<String, Item> map = new HashMap<String, Item>();
        map.put("max", (Item)ModItems.IRON_ALLOY.get());
        return map;
    }

    @Override
    public Map<String, Integer> getMaxTierMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("max", 2);
        return map;
    }

    @Override
    public boolean transfer(boolean OnOther, ItemStack advanced, ItemStack other, Slot slot, Player player, @Nullable SlotAccess access) {
        boolean empty = this.getEmpty(advanced);
        boolean full = this.getFull(advanced);
        Potion potion = PotionUtils.m_43579_((ItemStack)advanced);
        ItemStack contents = AdvancedItemUtil.getSpecsContents(advanced);
        if (other.m_41720_() instanceof AdvancedPotionItem) {
            boolean same;
            if (!OnOther) {
                return false;
            }
            Potion otherpotion = PotionUtils.m_43579_((ItemStack)other);
            ItemStack othercontents = AdvancedItemUtil.getSpecsContents(other);
            boolean bl = same = potion == otherpotion && contents == othercontents && !empty;
            if (this.getEmpty(other) && !empty) {
                this.getConsume(advanced, player);
                slot.m_5852_(this.getFinalBottle(other, potion, contents, player, true, true));
            } else if (!this.getEmpty(other) && empty || same && !full) {
                this.getFinalBottle(advanced, otherpotion, othercontents, player, true, true);
                slot.m_5852_(this.getConsume(other, player));
            } else {
                return false;
            }
            this.transferSound(player);
            return true;
        }
        if (other.m_41720_() instanceof BottleItem) {
            if (empty) {
                return false;
            }
            ItemStack output = !contents.m_150930_(Items.f_41852_) ? contents : PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion);
            if (other.m_41613_() == 1) {
                AdvancedItemUtil.returnOther(OnOther, output, slot, access);
            } else {
                other.m_41774_(1);
                player.m_150109_().m_36054_(output);
            }
            this.getConsume(advanced, player);
            this.transferSound(player);
            return true;
        }
        if (other.m_41720_() instanceof PotionItem) {
            Potion otherpotion = PotionUtils.m_43579_((ItemStack)other);
            if (empty || otherpotion == potion && !full) {
                this.getFinalBottle(advanced, otherpotion, contents, player, true, true);
                AdvancedItemUtil.returnOther(OnOther, new ItemStack((ItemLike)Items.f_42590_), slot, access);
                this.transferSound(player);
                return true;
            }
            return false;
        }
        if (other.m_204117_(ModTags.Items.NON_POTION_BOTTLES)) {
            if (empty || contents.m_41720_() == other.m_41720_() && !full) {
                ItemStack output = new ItemStack((ItemLike)Items.f_42590_);
                if (other.m_41613_() == 1) {
                    AdvancedItemUtil.returnOther(OnOther, output, slot, access);
                } else {
                    other.m_41774_(1);
                    player.m_150109_().m_36054_(output);
                }
                this.getFinalBottle(advanced, potion, new ItemStack((ItemLike)other.m_41720_()), player, true, true);
                if (other.m_150930_(Items.f_42735_)) {
                    this.transferSound(player, SoundEvents.f_11771_);
                } else {
                    this.transferSound(player);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void transferSound(Player player) {
        this.transferSound(player, SoundEvents.f_11770_);
    }

    public boolean m_142207_(@NotNull ItemStack advanced, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        ItemStack other = slot.m_7993_();
        return this.transfer(true, advanced, other, slot, player, null);
    }

    public boolean m_142305_(@NotNull ItemStack advanced, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (other.m_41720_() instanceof AdvancedPotionItem) {
            return false;
        }
        return this.transfer(true, advanced, other, slot, player, access);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack bottle = player.m_21120_(hand);
        Potion potion = PotionUtils.m_43579_((ItemStack)bottle);
        Item contents = AdvancedItemUtil.getSpecsContents(bottle).m_41720_();
        int volume = AdvancedItemUtil.getSpecsVolume(bottle)[0];
        int max = AdvancedItemUtil.getSpecsVolume(bottle)[1];
        boolean empty = this.getEmpty(bottle);
        if (volume < max && !player.m_6047_()) {
            BlockPos blockpos;
            BlockHitResult blockhitresult = AdvancedPotionItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            List list = level.m_6443_(AreaEffectCloud.class, player.m_20191_().m_82400_(2.0), cloud -> cloud != null && cloud.m_6084_() && cloud.m_19749_() instanceof EnderDragon);
            if (!list.isEmpty() && (empty || contents == Items.f_42735_)) {
                AreaEffectCloud areaeffectcloud = (AreaEffectCloud)list.get(0);
                areaeffectcloud.m_19712_(areaeffectcloud.m_19743_() - 0.5f);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11771_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                level.m_220400_((Entity)player, GameEvent.f_157816_, player.m_20182_());
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10565_.m_61494_(serverplayer, bottle, (Entity)areaeffectcloud);
                }
                player.m_21008_(hand, this.getFinalBottle(bottle, Potions.f_43598_, new ItemStack((ItemLike)Items.f_42735_), player, true, true));
                return InteractionResultHolder.m_19090_((Object)bottle);
            }
            if (blockhitresult.m_6662_() == HitResult.Type.BLOCK && player.m_142265_(level, blockpos = blockhitresult.m_82425_()) && level.m_8055_(blockpos).m_60713_(Blocks.f_49990_)) {
                level.m_5594_(null, blockpos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.m_21008_(hand, this.getFinalBottle(bottle, Potions.f_43599_, new ItemStack((ItemLike)contents), player, true, true));
                return InteractionResultHolder.m_19090_((Object)bottle);
            }
        }
        if (potion != Potions.f_43598_ || contents == Items.f_42787_) {
            if (!ModuleUtil.getSpecsActive(bottle) || contents == Items.f_42787_) {
                return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
            }
            return this.Throw(level, player, bottle, hand);
        }
        return InteractionResultHolder.m_19098_((Object)bottle);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack bottle, @NotNull Level level, @NotNull LivingEntity entity) {
        Player player = entity instanceof Player ? (Player)entity : null;
        ItemStack contents = AdvancedItemUtil.getSpecsContents(bottle);
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, bottle);
        }
        if (!level.f_46443_) {
            if (contents.m_150930_(Items.f_42787_)) {
                entity.m_21195_(MobEffects.f_19614_);
                entity.m_5584_(level, contents);
            } else {
                for (MobEffectInstance mobeffectinstance : PotionUtils.m_43547_((ItemStack)bottle)) {
                    if (mobeffectinstance.m_19544_().m_8093_()) {
                        mobeffectinstance.m_19544_().m_19461_((Entity)player, (Entity)player, entity, mobeffectinstance.m_19564_(), 1.0);
                        continue;
                    }
                    entity.m_7292_(new MobEffectInstance(mobeffectinstance));
                }
            }
        }
        if (player != null) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        if (!contents.m_150930_(Items.f_42787_)) {
            entity.m_146850_(GameEvent.f_223704_);
        }
        return this.getFinalBottle(bottle, PotionUtils.m_43579_((ItemStack)bottle), contents, player, false, true);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack bottle = context.m_43722_();
        Potion potion = PotionUtils.m_43579_((ItemStack)bottle);
        Item contents = AdvancedItemUtil.getSpecsContents(bottle).m_41720_();
        ItemStack stack = new ItemStack((ItemLike)Items.f_41852_);
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = level.m_8055_(blockpos);
        FluidState fluidstate = level.m_6425_(blockpos);
        int volume = AdvancedItemUtil.getSpecsVolume(bottle)[0];
        int max = AdvancedItemUtil.getSpecsVolume(bottle)[1];
        int cauldronLevel = 0;
        int honeyLevel = 0;
        boolean pickup = volume < max && !player.m_6047_();
        boolean empty = this.getEmpty(bottle);
        if (blockstate.m_60713_(Blocks.f_152476_)) {
            cauldronLevel = (Integer)level.m_8055_(blockpos).m_61143_((Property)LayeredCauldronBlock.f_153514_);
        }
        if (blockstate.m_204336_(BlockTags.f_13072_)) {
            honeyLevel = (Integer)level.m_8055_(blockpos).m_61143_((Property)BeehiveBlock.f_49564_);
        }
        if (pickup) {
            if (honeyLevel == 5 && (empty || contents == Items.f_42787_)) {
                level.m_5594_(null, blockpos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_46597_(blockpos, (BlockState)blockstate.m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(0)));
                player.m_21008_(context.m_43724_(), this.getFinalBottle(bottle, Potions.f_43598_, new ItemStack((ItemLike)Items.f_42787_), player, true, true));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (empty || potion == Potions.f_43599_) {
                if (cauldronLevel != 0) {
                    level.m_5594_(null, blockpos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (--cauldronLevel == 0) {
                        level.m_46597_(blockpos, Blocks.f_50256_.m_49966_());
                    } else {
                        level.m_46597_(blockpos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(cauldronLevel)));
                    }
                    player.m_21008_(context.m_43724_(), this.getFinalBottle(bottle, Potions.f_43599_, stack, player, true, true));
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                if (fluidstate.m_205070_(FluidTags.f_13131_)) {
                    level.m_5594_(null, blockpos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_21008_(context.m_43724_(), this.getFinalBottle(bottle, Potions.f_43599_, stack, player, true, true));
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            }
        }
        if (PotionUtils.m_43579_((ItemStack)bottle) != Potions.f_43599_) {
            return InteractionResult.PASS;
        }
        if (context.m_43719_() != Direction.DOWN && blockstate.m_204336_(BlockTags.f_215828_)) {
            level.m_5594_(null, blockpos, SoundEvents.f_11917_, SoundSource.BLOCKS, 1.0f, 1.0f);
            player.m_21008_(context.m_43724_(), this.getFinalBottle(bottle, Potions.f_43599_, stack, player, false, true));
            player.m_36246_(Stats.f_12982_.m_12902_((Object)bottle.m_41720_()));
            if (!level.f_46443_) {
                ServerLevel serverlevel = (ServerLevel)level;
                for (int i = 0; i < 5; ++i) {
                    serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, (double)blockpos.m_123341_() + level.f_46441_.m_188500_(), (double)(blockpos.m_123342_() + 1), (double)blockpos.m_123343_() + level.f_46441_.m_188500_(), 1, 0.0, 0.0, 0.0, 1.0);
                }
            }
            level.m_5594_(null, blockpos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157769_, blockpos);
            level.m_46597_(blockpos, Blocks.f_220864_.m_49966_());
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (blockstate.m_60713_(Blocks.f_50256_) || blockstate.m_60713_(Blocks.f_152476_) && cauldronLevel != 3) {
            level.m_5594_(null, blockpos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_46597_(blockpos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(cauldronLevel + 1)));
            player.m_21008_(context.m_43724_(), this.getFinalBottle(bottle, Potions.f_43599_, stack, player, false, true));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.ADVANCED_POTION.get());
        ItemStack contents = new ItemStack((ItemLike)Items.f_41852_);
        CompoundTag tags = stack.m_41784_();
        tags.m_128365_("Contents", (Tag)contents.m_41739_(new CompoundTag()));
        stack.m_41751_(tags);
        return PotionUtils.m_43549_((ItemStack)stack, (Potion)Potions.f_43599_);
    }

    @NotNull
    public String m_5671_(@NotNull ItemStack bottle) {
        Item contents = AdvancedItemUtil.getSpecsContents(bottle).m_41720_();
        if (contents == Items.f_42787_) {
            return "Flask of Honey";
        }
        if (contents == Items.f_42735_) {
            return "Flask of Dragon's Breath";
        }
        if (contents == Items.f_41852_ && PotionUtils.m_43579_((ItemStack)bottle) == Potions.f_43598_) {
            return "Empty Flask";
        }
        if (PotionUtils.m_43579_((ItemStack)bottle) == Potions.f_43599_) {
            return "Water Flask";
        }
        return PotionUtils.m_43579_((ItemStack)bottle).m_43492_(Items.f_42589_.m_5524_() + ".effect.");
    }

    public boolean m_142522_(@NotNull ItemStack bottle) {
        return !this.getEmpty(bottle);
    }

    public int m_142158_(@NotNull ItemStack itemstack) {
        return this.getBarVolume(itemstack);
    }

    public int m_142159_(@NotNull ItemStack itemstack) {
        if (PotionUtils.m_43579_((ItemStack)itemstack) == Potions.f_43598_) {
            return DEFAULT_BAR_COLOR;
        }
        return PotionUtils.m_43575_((ItemStack)itemstack);
    }
}

