/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.item.custom;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import jeffdallama.features.util.ModTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class AdzeItem
extends DiggerItem {
    public static final TagKey<Block> MINEABLE = ModTags.Blocks.MINEABLE_WITH_ADZE;
    protected static final Map<Block, Pair<Predicate<UseOnContext>, Consumer<UseOnContext>>> TILLABLES = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.f_50440_, (Object)Pair.of(HoeItem::m_150856_, (Object)HoeItem.m_150858_((BlockState)Blocks.f_50093_.m_49966_())), (Object)Blocks.f_152481_, (Object)Pair.of(HoeItem::m_150856_, (Object)HoeItem.m_150858_((BlockState)Blocks.f_50093_.m_49966_())), (Object)Blocks.f_50493_, (Object)Pair.of(HoeItem::m_150856_, (Object)HoeItem.m_150858_((BlockState)Blocks.f_50093_.m_49966_())), (Object)Blocks.f_50546_, (Object)Pair.of(HoeItem::m_150856_, (Object)HoeItem.m_150858_((BlockState)Blocks.f_50493_.m_49966_())), (Object)Blocks.f_152549_, (Object)Pair.of(p_238242_ -> true, (Object)HoeItem.m_150849_((BlockState)Blocks.f_50493_.m_49966_(), (ItemLike)Items.f_151017_))));
    protected static final Map<Block, Block> STRIPPABLES = new ImmutableMap.Builder().put((Object)Blocks.f_50011_, (Object)Blocks.f_50044_).put((Object)Blocks.f_49999_, (Object)Blocks.f_50010_).put((Object)Blocks.f_50043_, (Object)Blocks.f_50049_).put((Object)Blocks.f_50004_, (Object)Blocks.f_50009_).put((Object)Blocks.f_50015_, (Object)Blocks.f_50048_).put((Object)Blocks.f_50003_, (Object)Blocks.f_50008_).put((Object)Blocks.f_271348_, (Object)Blocks.f_271145_).put((Object)Blocks.f_271170_, (Object)Blocks.f_271326_).put((Object)Blocks.f_50013_, (Object)Blocks.f_50046_).put((Object)Blocks.f_50001_, (Object)Blocks.f_50006_).put((Object)Blocks.f_50014_, (Object)Blocks.f_50047_).put((Object)Blocks.f_50002_, (Object)Blocks.f_50007_).put((Object)Blocks.f_50012_, (Object)Blocks.f_50045_).put((Object)Blocks.f_50000_, (Object)Blocks.f_50005_).put((Object)Blocks.f_50686_, (Object)Blocks.f_50687_).put((Object)Blocks.f_50688_, (Object)Blocks.f_50689_).put((Object)Blocks.f_50695_, (Object)Blocks.f_50696_).put((Object)Blocks.f_50697_, (Object)Blocks.f_50698_).put((Object)Blocks.f_220836_, (Object)Blocks.f_220837_).put((Object)Blocks.f_220832_, (Object)Blocks.f_220835_).put((Object)Blocks.f_256831_, (Object)Blocks.f_256740_).build();

    public AdzeItem(float pAttackDamageModifier, float pAttackSpeedModifier, Tier pTier, Item.Properties pProperties) {
        super(pAttackDamageModifier, pAttackSpeedModifier, pTier, MINEABLE, pProperties);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState blockstate = level.m_8055_(blockpos);
        Optional<BlockState> optional = this.getStripped(blockstate);
        Optional optional1 = WeatheringCopper.m_154899_((BlockState)blockstate);
        Optional<BlockState> optional2 = Optional.ofNullable((Block)((BiMap)HoneycombItem.f_150864_.get()).get((Object)blockstate.m_60734_())).map(p_150694_ -> p_150694_.m_152465_(blockstate));
        ItemStack itemstack = context.m_43722_();
        Optional<Object> optional3 = Optional.empty();
        if (optional.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            optional3 = optional;
        } else if (optional1.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3005, blockpos, 0);
            optional3 = optional1;
        } else if (optional2.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3004, blockpos, 0);
            optional3 = optional2;
        }
        if (optional3.isPresent()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockpos, itemstack);
            }
            level.m_7731_(blockpos, (BlockState)optional3.get(), 11);
            level.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)((BlockState)optional3.get())));
            if (player != null) {
                itemstack.m_41622_(1, (LivingEntity)player, p_150686_ -> p_150686_.m_21190_(context.m_43724_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        Pair<Predicate<UseOnContext>, Consumer<UseOnContext>> pair = TILLABLES.get(level.m_8055_(blockpos).m_60734_());
        if (pair == null) {
            return InteractionResult.PASS;
        }
        Predicate predicate = (Predicate)pair.getFirst();
        Consumer consumer = (Consumer)pair.getSecond();
        if (predicate.test(context)) {
            level.m_5594_(player, blockpos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.f_46443_) {
                consumer.accept(context);
                if (player != null) {
                    context.m_43722_().m_41622_(1, (LivingEntity)player, p_150845_ -> p_150845_.m_21190_(context.m_43724_()));
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private Optional<BlockState> getStripped(BlockState p_150691_) {
        return Optional.ofNullable(STRIPPABLES.get(p_150691_.m_60734_())).map(p_150689_ -> (BlockState)p_150689_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)p_150691_.m_61143_((Property)RotatedPillarBlock.f_55923_))));
    }
}

