/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.item.custom.arrows;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import jeffdallama.features.mixin.AbstractArrowAcccessorMixin;
import jeffdallama.features.util.ItemAccessor;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AdvancedArrowItem
extends ArrowItem {
    private final SimpleParticleType trail;
    private final ResourceLocation location;
    private final int probability;

    public AdvancedArrowItem(SimpleParticleType trail, ResourceLocation location, int probability, Item.Properties pProperties) {
        super(pProperties);
        this.trail = trail;
        this.location = location;
        this.probability = probability;
    }

    public ResourceLocation getTextureLocation(AbstractArrow arrow) {
        return this.location;
    }

    public void impactBlock(AbstractArrow arrow) {
    }

    public void impactEntity(AbstractArrow arrow, Entity target) {
    }

    public DamageSource getDamageSource(AbstractArrow pArrow, @Nullable Entity shooter) {
        Arrow tempArrow;
        if (shooter instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)shooter;
            tempArrow = new Arrow(pArrow.m_9236_(), livingEntity);
        } else {
            tempArrow = new Arrow(pArrow.m_9236_(), pArrow.m_20185_(), pArrow.m_20186_(), pArrow.m_20189_());
        }
        return pArrow.m_269291_().m_269418_((AbstractArrow)tempArrow, shooter);
    }

    public void trail(AbstractArrow arrow) {
        if (arrow.m_9236_() instanceof ServerLevel && !((AbstractArrowAcccessorMixin)arrow).inGround() && RandomSource.m_216327_().m_188503_(this.probability) == 0) {
            this.arrowParticle((Entity)arrow, (ParticleOptions)this.trail, 0.25, 0.05f, 1);
        }
    }

    public void arrowParticle(Entity entity, ParticleOptions particle, double p, float dist, int count) {
        Vec3 vec3 = entity.m_20184_();
        if (entity.m_9236_().m_7654_() == null) {
            return;
        }
        List serverplayers = Objects.requireNonNull(entity.m_9236_().m_7654_()).m_6846_().m_11314_();
        for (ServerPlayer player : serverplayers) {
            for (int i = 0; i < 4; ++i) {
                double d5 = vec3.f_82479_ * (double)i * p;
                double d6 = vec3.f_82480_ * (double)i * p;
                double d1 = vec3.f_82481_ * (double)i * p;
                player.f_8906_.m_9829_((Packet)new ClientboundLevelParticlesPacket(particle, true, entity.m_20185_() + d5, entity.m_20186_() + d6, entity.m_20189_() + d1, dist, dist, dist, 0.1f, count));
            }
        }
    }

    @NotNull
    public AbstractArrow m_6394_(@NotNull Level pLevel, @NotNull ItemStack pStack, @NotNull LivingEntity pShooter) {
        Arrow arrow = new Arrow(pLevel, pShooter);
        arrow.m_36878_(pStack);
        if (arrow instanceof ItemAccessor) {
            ItemAccessor accessor = (ItemAccessor)arrow;
            accessor.setCustomValue(pStack.m_255036_(1));
        }
        return arrow;
    }
}

