/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.item.custom.arrows;

import javax.annotation.Nullable;
import jeffdallama.features.item.custom.arrows.AdvancedArrowItem;
import jeffdallama.features.util.ModDamageSources;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class EchoArrowItem
extends AdvancedArrowItem {
    private static final ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"functionalfeatures", (String)"textures/entity/projectiles/echo_arrow.png");

    public EchoArrowItem(Item.Properties pProperties) {
        super(ParticleTypes.f_235900_, location, 5, pProperties);
    }

    @Override
    public void impactEntity(AbstractArrow arrow, Entity target) {
        super.impactEntity(arrow, target);
        Level level = arrow.m_9236_();
        BlockPos pos = arrow.m_20183_();
        AABB area = new AABB(pos);
        for (Entity entity : level.m_45933_((Entity)arrow, area.m_82400_(3.5))) {
            entity.m_6469_(this.getDamageSource(arrow, arrow.m_19749_()), 10.0f);
        }
        level.m_247517_(null, pos, SoundEvents.f_215771_, SoundSource.NEUTRAL);
        this.arrowParticle(target, (ParticleOptions)ParticleTypes.f_235902_, 0.25, 0.0f, 1);
    }

    @Override
    public DamageSource getDamageSource(AbstractArrow pArrow, @Nullable Entity shooter) {
        return ModDamageSources.arrowEcho(pArrow.m_9236_().m_9598_(), pArrow, shooter);
    }
}

