/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.item.custom.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import jeffdallama.features.item.ModItems;
import jeffdallama.features.item.custom.modules.ModuleItem;
import jeffdallama.features.util.AdvancedItemUtil;
import jeffdallama.features.util.ModuleUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class EnchantMedallionItem
extends ModuleItem {
    private final Enchantment defaultEnchant;
    private final Enchantment defaultSwapEnchant;
    private final TagKey<Item> tag;

    public EnchantMedallionItem(Enchantment defaultEnchant, Enchantment defaultSwapEnchant, TagKey<Item> tag, Item.Properties properties) {
        super("Enchantment Medallion", true, true, false, 0, 1, properties);
        this.defaultEnchant = defaultEnchant;
        this.defaultSwapEnchant = defaultSwapEnchant;
        this.tag = tag;
    }

    public Enchantment getEnchants(boolean swap) {
        if (!swap) {
            return this.defaultEnchant;
        }
        return this.defaultSwapEnchant;
    }

    @Override
    public SoundEvent getActivateSound(ItemStack stack) {
        return SoundEvents.f_11897_;
    }

    @Override
    public Component getActivateText(ItemStack itemstack) {
        int level;
        MutableComponent enchantComponent;
        MutableComponent numeralComponent = Component.m_237119_();
        System.out.println(itemstack);
        Map enchantMap = itemstack.getAllEnchantments();
        ArrayList<Enchantment> enchantList = new ArrayList<Enchantment>();
        for (Map.Entry entry : enchantMap.entrySet()) {
            enchantList.add((Enchantment)entry.getKey());
            System.out.println(((Enchantment)entry.getKey()).m_44704_());
        }
        if (enchantList.contains(this.defaultSwapEnchant)) {
            enchantComponent = Component.m_237115_((String)this.defaultEnchant.m_44704_()).m_130940_(ChatFormatting.LIGHT_PURPLE);
            level = this.defaultEnchant.m_6586_();
        } else {
            enchantComponent = Component.m_237115_((String)this.defaultSwapEnchant.m_44704_()).m_130940_(ChatFormatting.LIGHT_PURPLE);
            level = this.defaultSwapEnchant.m_6586_();
        }
        if (level > 1) {
            numeralComponent = Component.m_237113_((String)(" " + AdvancedItemUtil.getNumerals(level))).m_130940_(ChatFormatting.LIGHT_PURPLE);
        }
        return Component.m_237113_((String)"Activated: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)enchantComponent).m_7220_((Component)numeralComponent);
    }

    @Override
    public boolean Activate(Player player, ItemStack originalStack, Integer slot, Container inventory) {
        List<ItemStack> mods = ModuleUtil.getSpecsModules(originalStack);
        ItemStack module = new ItemStack((ItemLike)ModItems.DIG_ENCHANT_MEDALLION.get());
        for (ItemStack stack : mods) {
            if (!(stack.m_41720_() instanceof EnchantMedallionItem)) continue;
            module = stack;
        }
        if (mods.isEmpty()) {
            mods.add(module);
        }
        Enchantment defaultEnchant = null;
        Enchantment defaultSwapEnchant = null;
        Item item = module.m_41720_();
        if (item instanceof EnchantMedallionItem) {
            EnchantMedallionItem medallion = (EnchantMedallionItem)item;
            defaultEnchant = medallion.getEnchants(false);
            defaultSwapEnchant = medallion.getEnchants(true);
        }
        if (defaultEnchant == null || defaultSwapEnchant == null) {
            return false;
        }
        Map enchantMap = originalStack.getAllEnchantments();
        ArrayList<Enchantment> enchantList = new ArrayList<Enchantment>();
        for (Map.Entry entry : enchantMap.entrySet()) {
            enchantList.add((Enchantment)entry.getKey());
        }
        Enchantment newEnchant = !enchantList.contains(defaultEnchant) && !enchantList.contains(defaultSwapEnchant) ? defaultEnchant : (enchantList.contains(defaultEnchant) ? defaultSwapEnchant : defaultEnchant);
        ItemStack output = new ItemStack((ItemLike)originalStack.m_41720_());
        CompoundTag originalTags = originalStack.m_41784_();
        originalTags.m_128365_("modules", (Tag)ModuleUtil.getModulesCompound(mods));
        output.m_41751_(originalTags);
        output.m_41749_("Enchantments");
        output.m_41749_("StoredEnchantments");
        for (Map.Entry entry : enchantMap.entrySet()) {
            boolean flag;
            boolean bl = flag = entry.getKey() != defaultEnchant && entry.getKey() != defaultSwapEnchant;
            if (defaultSwapEnchant == Enchantments.f_44958_ && entry.getKey() == Enchantments.f_44955_) {
                flag = false;
            }
            if (!flag) continue;
            output.m_41663_((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue());
        }
        output.m_41663_(newEnchant, newEnchant.m_6586_());
        if (newEnchant == Enchantments.f_44958_) {
            output.m_41663_(Enchantments.f_44955_, Enchantments.f_44955_.m_6586_());
        }
        originalStack.m_41774_(1);
        inventory.m_6836_(slot.intValue(), output);
        return true;
    }

    @Override
    public boolean CanApply(ItemStack itemstack, ItemStack modstack) {
        Map map = itemstack.getAllEnchantments();
        boolean hasenchant = map.containsKey(this.defaultEnchant) || map.containsKey(this.defaultSwapEnchant);
        return itemstack.m_204117_(this.tag) && hasenchant;
    }

    @Override
    public String CannotApplyText(ItemStack itemstack, ItemStack modstack) {
        boolean hasenchant;
        Map map = itemstack.getAllEnchantments();
        boolean bl = hasenchant = map.containsKey(this.defaultEnchant) || map.containsKey(this.defaultSwapEnchant);
        if (itemstack.m_204117_(this.tag) && !hasenchant) {
            return "First Apply Either Enchantment to Item!";
        }
        return super.CannotApplyText(itemstack, modstack);
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return true;
    }

    @Override
    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        ArrayList<Component> list = new ArrayList<Component>();
        String temp = this.Active || this.inventoryActive ? "Active Module" : "Passive Module";
        list.add((Component)Component.m_237113_((String)temp).m_130940_(ChatFormatting.DARK_GRAY));
        list.add((Component)Component.m_237113_((String)"Applies To:").m_130940_(ChatFormatting.GRAY));
        list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)(this.m_5524_() + ".applyto")).m_130940_(ChatFormatting.BLUE)));
        list.add((Component)Component.m_237113_((String)"Enchants:").m_130940_(ChatFormatting.GRAY));
        list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)this.defaultEnchant.m_44704_()).m_130940_(ChatFormatting.BLUE)));
        list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)this.defaultSwapEnchant.m_44704_()).m_130940_(ChatFormatting.BLUE)));
        AdvancedItemUtil.makeHideableTooltip(pTooltipComponents, list);
    }
}

