/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.item.custom.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jeffdallama.features.util.AdvancedItemUtil;
import jeffdallama.features.util.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleItem
extends Item {
    private final String displayname;
    protected final boolean Active;
    protected final boolean inventoryActive;
    private final boolean inventoryResults;
    private final int cooldown;
    private final int tier;

    public ModuleItem(String displayname, boolean Active, boolean inventoryActive, boolean inventoryResults, int cooldown, int tier, Item.Properties properties) {
        super(properties);
        this.displayname = displayname;
        this.Active = Active;
        this.inventoryActive = inventoryActive;
        this.inventoryResults = inventoryResults;
        this.cooldown = cooldown;
        this.tier = tier;
    }

    public boolean getApplications(ItemStack stack, ItemStack module) {
        return stack.m_204117_(ModTags.Items.TIERED_UPGRADABLE);
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public Component getHoverText(ItemStack itemStack) {
        return null;
    }

    public boolean getActive() {
        return this.Active;
    }

    public boolean getInventoryActive() {
        return this.inventoryActive;
    }

    public boolean getinventoryResults() {
        return this.inventoryResults;
    }

    public SoundEvent getActivateSound(ItemStack itemstack) {
        return SoundEvents.f_271165_;
    }

    public Component getActivateText(ItemStack itemstack) {
        return Component.m_237119_();
    }

    public SoundEvent getFailSound(ItemStack itemstack) {
        return SoundEvents.f_271165_;
    }

    public Component getFailText(ItemStack itemstack) {
        return Component.m_237119_();
    }

    public boolean Activate(Player player, ItemStack itemstack, Integer slot, Container inventory) {
        return false;
    }

    public boolean Passive(Player player, ItemStack itemstack, Integer slot, Container inventory) {
        return false;
    }

    public boolean CanRemove(ItemStack itemstack, ItemStack modstack) {
        return true;
    }

    public boolean CanApply(ItemStack itemstack, ItemStack modstack) {
        return itemstack.m_204117_(ModTags.Items.ALL_UPGRADABLE);
    }

    public String CannotApplyText(ItemStack itemStack, ItemStack modstack) {
        return "Module Incompatible With Item!";
    }

    public void ModuleResults(ItemStack itemstack, boolean fail) {
        Component component = !fail ? this.getActivateText(itemstack) : this.getFailText(itemstack);
        if (!Objects.equals(component, Component.m_237119_())) {
            Minecraft.m_91087_().f_91065_.m_93063_(component, true);
        }
    }

    public int getCooldown(Player player, ItemStack stack) {
        return this.cooldown;
    }

    public int getTier() {
        return this.tier;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        ArrayList<Component> list = new ArrayList<Component>();
        String temp = this.Active || this.inventoryActive ? "Active Module" : "Passive Module";
        list.add((Component)Component.m_237113_((String)temp).m_130940_(ChatFormatting.DARK_GRAY));
        list.add((Component)Component.m_237113_((String)"Applies To:").m_130940_(ChatFormatting.GRAY));
        list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)(this.m_5524_() + ".applyto")).m_130940_(ChatFormatting.BLUE)));
        AdvancedItemUtil.makeHideableTooltip(pTooltipComponents, list);
    }
}

