/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.item.custom.modules;

import jeffdallama.features.item.custom.HorseshoeItem;
import jeffdallama.features.item.custom.modules.ModuleItem;
import jeffdallama.features.item.enchantments.ModEnchantments;
import jeffdallama.features.mixin.HorseAccessorMixin;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public class SpurModuleItem
extends ModuleItem {
    private final int duration;
    private final int amplifier;

    public SpurModuleItem(int duration, int amplifier, int cooldown, Item.Properties properties) {
        super("Spurs", true, false, false, cooldown, 1, properties);
        this.duration = duration;
        this.amplifier = amplifier;
    }

    @Override
    public boolean Activate(Player player, ItemStack itemstack, Integer slot, Container inventory) {
        LivingEntity livingEntity;
        Entity entity = player.m_20202_();
        if (entity != null && (livingEntity = (LivingEntity)entity) instanceof AbstractHorse) {
            Item item;
            AbstractHorse horse = (AbstractHorse)livingEntity;
            int duration = this.duration;
            int amplifier = this.amplifier;
            SimpleContainer horseinventory = ((HorseAccessorMixin)horse).getInventory();
            ItemStack horsestack = horseinventory.m_8020_(2);
            if (horsestack.getAllEnchantments().containsKey(ModEnchantments.GALLOP.get())) {
                duration += (Integer)horsestack.getAllEnchantments().get(ModEnchantments.GALLOP.get()) * 50;
            }
            if ((item = horsestack.m_41720_()) instanceof HorseshoeItem) {
                HorseshoeItem shoe = (HorseshoeItem)item;
                amplifier += shoe.getLevelSpeed() + 1;
                horsestack.m_220157_(1, RandomSource.m_216327_(), null);
                horseinventory.m_6836_(2, horsestack);
            }
            horse.m_7292_(new MobEffectInstance(MobEffects.f_19596_, duration, amplifier, false, false));
            Vec3 v = horse.m_20184_();
            v.m_82541_();
            v.m_82490_(3.0 + (double)amplifier / 2.0);
            return true;
        }
        return false;
    }

    @Override
    public int getCooldown(Player player, ItemStack stack) {
        if (player.m_20202_() == null) {
            return 0;
        }
        return super.getCooldown(player, stack);
    }

    @Override
    public SoundEvent getActivateSound(ItemStack itemstack) {
        return SoundEvents.f_11972_;
    }

    @Override
    public SoundEvent getFailSound(ItemStack itemstack) {
        return SoundEvents.f_11978_;
    }

    @Override
    public boolean CanApply(ItemStack itemstack, ItemStack modstack) {
        return itemstack.m_204117_(Tags.Items.ARMORS_BOOTS);
    }
}

