/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AddItemModifier
extends LootModifier {
    public static final Supplier<Codec<AddItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AddItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(AddItemModifier::getItem)).and((App)Codec.FLOAT.optionalFieldOf("chance").forGetter(m -> Optional.of(Float.valueOf(m.odds)))).apply((Applicative)inst, (conditions, item, oddsOpt) -> new AddItemModifier((LootItemCondition[])conditions, (Item)item, oddsOpt.orElse(Float.valueOf(1.0f)).floatValue()))));
    private final Item item;
    private final float odds;

    public AddItemModifier(LootItemCondition[] conditionsIn, Item item, float odds) {
        super(conditionsIn);
        this.item = item;
        this.odds = odds;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        RandomSource random = context.m_230907_();
        if (random.m_188501_() < this.odds) {
            generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    public float getOdds() {
        return this.odds;
    }

    public Item getItem() {
        return this.item;
    }
}

