/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.mixin;

import jeffdallama.features.item.ModItems;
import jeffdallama.features.util.AdvancedItemUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractMinecart.class})
public abstract class MinecartMixin
extends Entity {
    public MinecartMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"destroy"}, at={@At(value="HEAD")}, cancellable=true)
    private void destroy(DamageSource pDamageSource, CallbackInfo ci) {
        if (this.m_6095_() != EntityType.f_20469_) {
            return;
        }
        ci.cancel();
        this.m_6074_();
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            ItemStack itemstack = new ItemStack((ItemLike)Items.f_42449_);
            CompoundTag data = this.getPersistentData();
            if (data.m_128441_("CartItem")) {
                itemstack = ItemStack.m_41712_((CompoundTag)data.m_128469_("CartItem"));
            }
            if (this.m_8077_()) {
                itemstack.m_41714_(this.m_7770_());
            }
            this.m_19983_(itemstack);
        }
    }

    @Inject(method={"getMaxSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    protected void getMaxSpeed(CallbackInfoReturnable<Double> cir) {
        if (this.m_6095_() != EntityType.f_20469_) {
            return;
        }
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42449_);
        CompoundTag data = this.getPersistentData();
        if (data.m_128441_("CartItem")) {
            itemstack = ItemStack.m_41712_((CompoundTag)data.m_128469_("CartItem"));
        }
        int tier = AdvancedItemUtil.getSpecsUpgradeTier(itemstack, "speed");
        double speed = (Double)cir.getReturnValue();
        cir.setReturnValue((Object)(speed * (1.0 + 0.5 * (double)tier)));
    }

    @Inject(method={"getMaxSpeedWithRail"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    protected void getMaxSpeedWithRail(CallbackInfoReturnable<Double> cir) {
        CompoundTag data;
        RailBlock railBlock;
        RailShape shape;
        Block block;
        double absolutemax = 0.8;
        Vec3 vec3 = this.m_20184_();
        if (this.m_6095_() != EntityType.f_20469_) {
            return;
        }
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42449_);
        int x = Mth.m_14107_((double)this.m_20185_());
        int y = Mth.m_14107_((double)this.m_20186_());
        int z = Mth.m_14107_((double)this.m_20189_());
        BlockPos pos = new BlockPos(x, y, z);
        if (this.m_9236_().m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13034_)) {
            pos = pos.m_7495_();
        }
        BlockPos nextpos = Math.abs(vec3.f_82479_) > Math.abs(vec3.f_82480_) ? (vec3.f_82479_ > 0.0 ? pos.m_122029_() : pos.m_122024_()) : (vec3.f_82480_ > 0.0 ? pos.m_122019_() : pos.m_122012_());
        BlockState state = this.m_9236_().m_8055_(pos);
        BlockState nextstate = this.m_9236_().m_8055_(nextpos);
        System.out.println(state + " " + nextstate);
        if (AdvancedItemUtil.RailShapeCheck(state) || AdvancedItemUtil.RailShapeCheck(nextstate)) {
            absolutemax = 0.5;
        }
        if ((block = state.m_60734_()) instanceof RailBlock && (shape = (RailShape)state.m_61143_((railBlock = (RailBlock)block).m_7978_())) != RailShape.EAST_WEST && shape != RailShape.NORTH_SOUTH) {
            absolutemax = 0.5;
        }
        if ((data = this.getPersistentData()).m_128441_("CartItem")) {
            itemstack = ItemStack.m_41712_((CompoundTag)data.m_128469_("CartItem"));
        }
        int tier = AdvancedItemUtil.getSpecsUpgradeTier(itemstack, "speed");
        if (itemstack.m_150930_((Item)ModItems.ADVANCED_MINECART.get())) {
            ++tier;
        }
        double speed = (Double)cir.getReturnValue();
        double output = speed * (1.0 + 0.33333 * (double)tier);
        cir.setReturnValue((Object)Math.min(output, absolutemax));
    }
}

