/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.mixin;

import java.util.ArrayList;
import java.util.Map;
import jeffdallama.features.item.ModItems;
import jeffdallama.features.item.custom.TieredUpgradableItem;
import jeffdallama.features.util.AdvancedItemUtil;
import jeffdallama.features.util.ModuleUtil;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net.minecraft.world.item.crafting.SmithingTransformRecipe"})
public class SmithingMixin {
    @Shadow
    @Final
    Ingredient f_265949_;
    @Shadow
    @Final
    Ingredient f_265888_;
    @Shadow
    @Final
    Ingredient f_265907_;

    @Inject(method={"assemble"}, at={@At(value="TAIL")}, cancellable=true)
    private void assemble(Container pContainer, RegistryAccess pRegistryAccess, CallbackInfoReturnable<ItemStack> cir) {
        Item item;
        ItemStack templatestack = pContainer.m_8020_(0).m_41777_();
        ItemStack basestack = pContainer.m_8020_(1).m_41777_();
        ItemStack addstack = pContainer.m_8020_(2).m_41777_();
        ItemStack result = ((ItemStack)cir.getReturnValue()).m_41777_();
        if (result == ItemStack.f_41583_) {
            return;
        }
        if (templatestack.m_150930_((Item)ModItems.TIER_SMITHING_TEMPLATE.get()) && (item = basestack.m_41720_()) instanceof TieredUpgradableItem) {
            TieredUpgradableItem tiered = (TieredUpgradableItem)item;
            if (basestack.m_41720_() == result.m_41720_()) {
                ArrayList<String> keys = new ArrayList<String>(tiered.getTierMap().keySet());
                Map<String, Item> map = tiered.getTierMap();
                String key = null;
                if (keys.isEmpty() || map.isEmpty()) {
                    cir.setReturnValue((Object)ItemStack.f_41583_);
                    return;
                }
                for (String string : keys) {
                    if (map.get(string) != addstack.m_41720_()) continue;
                    key = string;
                    break;
                }
                if (key == null) {
                    cir.setReturnValue((Object)ItemStack.f_41583_);
                    return;
                }
                Map<String, Integer> maxmap = tiered.getMaxTierMap();
                int tier = AdvancedItemUtil.getSpecsUpgradeTier(basestack, key);
                int maxtier = 2;
                if (maxmap.containsKey(key) && maxmap.get(key) != null) {
                    maxtier = maxmap.get(key);
                }
                if (tier == maxtier) {
                    cir.setReturnValue((Object)ItemStack.f_41583_);
                    return;
                }
                ItemStack output = basestack.m_41777_();
                CompoundTag upgrades = AdvancedItemUtil.getSpecsUpgrades(basestack);
                upgrades.m_128405_(key, tier + 1);
                output.m_41784_().m_128365_("upgrades", (Tag)upgrades);
                cir.setReturnValue((Object)output);
                return;
            }
        }
        if (templatestack.m_150930_((Item)ModItems.MERGE_SMITHING_TEMPLATE.get()) && result.m_41720_() instanceof ElytraItem) {
            if (ModuleUtil.hasModule(basestack, (Item)ModItems.ELYTRA_MODULE.get()) || ModuleUtil.hasModule(addstack, (Item)ModItems.ELYTRA_MODULE.get())) {
                cir.setReturnValue((Object)ItemStack.f_41583_);
                return;
            }
            CompoundTag armortag = addstack.m_41739_(new CompoundTag());
            result.m_41784_().m_128365_("Armor", (Tag)armortag);
            ModuleUtil.giveModule(result, (Item)ModItems.ELYTRA_MODULE.get());
            cir.setReturnValue((Object)result);
        }
    }
}

