/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.networking.packet;

import java.util.function.Supplier;
import jeffdallama.features.util.ModuleUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ModuleC2SPacket {
    private final boolean forceSlot;
    private final int Slot;

    public ModuleC2SPacket(boolean forceSlot, int Slot2) {
        this.forceSlot = forceSlot;
        this.Slot = Slot2;
    }

    public ModuleC2SPacket(FriendlyByteBuf buf) {
        this.forceSlot = buf.readBoolean();
        this.Slot = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.forceSlot);
        buf.writeInt(this.Slot);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            assert (player != null);
            if (this.forceSlot) {
                ModuleUtil.activateInventory((Player)player, (Container)player.m_150109_(), this.Slot);
            } else {
                ModuleUtil.activateInstance((Player)player);
            }
        });
        return true;
    }
}

