/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.util;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import jeffdallama.features.item.ModItems;
import jeffdallama.features.item.custom.AdvancedBundleItem;
import jeffdallama.features.item.custom.AdvancedPotionItem;
import jeffdallama.features.item.custom.TieredUpgradableItem;
import jeffdallama.features.item.custom.arrows.PrismarineArrowItem;
import jeffdallama.features.item.custom.modules.ModuleItem;
import jeffdallama.features.util.ItemAccessor;
import jeffdallama.features.util.ModTags;
import jeffdallama.features.util.ModuleUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class AdvancedItemUtil {
    public static float getArrowInertia(AbstractArrow arrow) {
        if (AdvancedItemUtil.getArrowItem(arrow).m_41720_() instanceof PrismarineArrowItem) {
            return 0.99f;
        }
        return 0.6f;
    }

    public static ItemStack getArrowItem(AbstractArrow arrow) {
        if (arrow instanceof ItemAccessor) {
            ItemAccessor accessor = (ItemAccessor)arrow;
            return accessor.getCustomValue();
        }
        return new ItemStack((ItemLike)Items.f_42412_);
    }

    public static CompoundTag getSpecsUpgrades(ItemStack itemstack) {
        CompoundTag tags = itemstack.m_41784_();
        if (tags.m_128441_("upgrades")) {
            return tags.m_128469_("upgrades");
        }
        return new CompoundTag();
    }

    public static int getSpecsUpgradeTier(ItemStack itemstack, String pKey) {
        CompoundTag upgrades = AdvancedItemUtil.getSpecsUpgrades(itemstack);
        int tier = 0;
        if (upgrades.m_128441_(pKey)) {
            tier += upgrades.m_128451_(pKey);
        }
        return tier;
    }

    public static int[] getSpecsVolume(ItemStack itemstack) {
        CompoundTag tags = itemstack.m_41784_();
        int tier = AdvancedItemUtil.getSpecsUpgradeTier(itemstack, "max");
        int[] specs = new int[2];
        int volume = 0;
        int max = (int)Math.pow(2.0, 2 + tier);
        if (itemstack.m_150930_((Item)ModItems.ADVANCED_BUNDLE.get())) {
            max = 64 * (2 + tier);
            if (ModuleUtil.hasModule(itemstack, (Item)ModItems.QUIVER_MODULE.get())) {
                max = 128 * (1 + tier);
            }
            volume = AdvancedBundleItem.getVolume(itemstack);
        } else {
            AdvancedPotionItem potion;
            Item item;
            if (tags.m_128441_("volume")) {
                volume = tags.m_128451_("volume");
            }
            if ((item = itemstack.m_41720_()) instanceof AdvancedPotionItem && !(potion = (AdvancedPotionItem)item).getEmpty(itemstack) && volume == 0) {
                volume = 1;
            }
            tags.m_128405_("volume", volume);
        }
        if (max == 0) {
            ++max;
        }
        tags.m_128405_("max", max);
        specs[0] = volume;
        specs[1] = max;
        return specs;
    }

    public static ItemStack getSpecsContents(ItemStack bottle) {
        CompoundTag tags = bottle.m_41784_();
        ItemStack contents = new ItemStack((ItemLike)Items.f_41852_);
        if (!tags.m_128441_("Contents")) {
            contents.m_41739_(new CompoundTag());
        }
        bottle.m_41751_(tags);
        return ItemStack.m_41712_((CompoundTag)tags.m_128469_("Contents"));
    }

    public static boolean getFull(ItemStack itemstack) {
        int max;
        int volume = AdvancedItemUtil.getSpecsVolume(itemstack)[0];
        return volume >= (max = AdvancedItemUtil.getSpecsVolume(itemstack)[1]);
    }

    public static FluidStack getSpecsFluidStack(ItemStack itemStack) {
        FluidStack fluidStack = new FluidStack(Fluids.f_76191_, 0);
        CompoundTag tags = itemStack.m_41784_();
        if (tags.m_128441_("Fluid")) {
            fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)itemStack.m_41784_().m_128469_("Fluid"));
        }
        return fluidStack;
    }

    public static Block getSpecsBlock(ItemStack itemStack) {
        Block block = Blocks.f_50016_;
        CompoundTag tags = itemStack.m_41784_();
        if (tags.m_128441_("Block")) {
            String[] id = tags.m_128461_("Block").split(":");
            block = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)id[0], (String)id[1]));
        }
        return block;
    }

    public static String getSpecsDrink(ItemStack itemStack) {
        CompoundTag tags = itemStack.m_41784_();
        String drink = "Empty";
        if (tags.m_128441_("Drink")) {
            drink = tags.m_128461_("Drink");
        }
        return drink;
    }

    public static void returnOther(boolean OnOther, ItemStack output, Slot slot, @Nullable SlotAccess access) {
        if (OnOther) {
            slot.m_5852_(output);
        } else {
            assert (access != null);
            access.m_142104_(output);
        }
    }

    public static void returnDefault(boolean OnOther, ItemStack output, Slot slot, Player player) {
        if (!OnOther) {
            slot.m_5852_(output);
        } else {
            player.f_36096_.m_142503_(output);
        }
    }

    public static boolean RailShapeCheck(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof RailBlock) {
            RailBlock railBlock = (RailBlock)block;
            RailShape shape = (RailShape)state.m_61143_(railBlock.m_7978_());
            return shape != RailShape.EAST_WEST && shape != RailShape.NORTH_SOUTH;
        }
        return false;
    }

    public static ListTag getItemListTag(List<ItemStack> contents) {
        ListTag listTag = new ListTag();
        for (ItemStack stack : contents) {
            listTag.add((Object)stack.m_41739_(new CompoundTag()));
        }
        return listTag;
    }

    public static SoundEvent getFluidSound(Fluid fluid, LevelAccessor pLevel, BlockPos pPos) {
        SoundEvent soundevent = fluid.getFluidType().getSound(null, (BlockGetter)pLevel, pPos, SoundActions.BUCKET_EMPTY);
        if (soundevent == null) {
            soundevent = fluid.m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
        }
        return soundevent;
    }

    public static SoundEvent getFluidSound(Fluid fluid, Player player) {
        return AdvancedItemUtil.getFluidSound(fluid, (LevelAccessor)player.m_9236_(), player.m_20183_());
    }

    public static void putTooltip(ItemStack itemstack, List<Component> pTooltipComponents) {
        Potion potion;
        List effects;
        List<Component> custommoduletext = ModuleUtil.getModulesComponent(itemstack);
        ArrayList<MutableComponent> newtext = new ArrayList<MutableComponent>();
        ArrayList<Component> advancedtext = new ArrayList<Component>();
        List<MutableComponent> upgrades = AdvancedItemUtil.getUpgradesText(itemstack);
        if (itemstack.m_204117_(ModTags.Items.TIERED_VOLUMES)) {
            newtext.add(AdvancedItemUtil.getVolumeText(itemstack));
        }
        if (itemstack.m_150930_((Item)ModItems.ADVANCED_POTION.get()) && !(effects = (potion = PotionUtils.m_43579_((ItemStack)itemstack)).m_43488_()).isEmpty()) {
            PotionUtils.m_43555_((ItemStack)itemstack, newtext, (float)1.0f);
        }
        int size = pTooltipComponents.size();
        if (Minecraft.m_91087_().f_91066_.f_92125_) {
            int n = size - 2;
            if (n < 0) {
                n = 0;
            }
            if (itemstack.m_41782_()) {
                advancedtext.add(pTooltipComponents.get(n));
            }
            if (++n >= size) {
                n = size - 1;
            }
            advancedtext.add(pTooltipComponents.get(n));
            for (Component component : advancedtext) {
                pTooltipComponents.remove(component);
            }
        }
        if (!upgrades.isEmpty()) {
            newtext.add(Component.m_237113_((String)""));
            if (!InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
                MutableComponent part1 = Component.m_237113_((String)"Hold [").m_130940_(ChatFormatting.DARK_GRAY);
                MutableComponent shift = Component.m_237113_((String)"Shift").m_130940_(ChatFormatting.GRAY);
                MutableComponent part2 = Component.m_237113_((String)"] to view upgrades").m_130940_(ChatFormatting.DARK_GRAY);
                newtext.add(part1.m_6881_().m_7220_((Component)shift).m_7220_((Component)part2));
            } else {
                newtext.add(Component.m_237113_((String)"Upgrades:").m_130940_(ChatFormatting.GRAY));
                newtext.addAll(upgrades);
            }
        }
        pTooltipComponents.addAll(custommoduletext);
        pTooltipComponents.addAll(newtext);
        pTooltipComponents.addAll(advancedtext);
    }

    public static String getNumerals(int num) {
        return switch (num) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            default -> Integer.toString(num);
        };
    }

    public static List<MutableComponent> getUpgradesText(ItemStack stack) {
        ArrayList<MutableComponent> output = new ArrayList<MutableComponent>();
        CompoundTag tags = stack.m_41784_();
        if (tags.m_128441_("modules")) {
            List<ItemStack> modules = ModuleUtil.getSpecsModules(stack);
            for (ItemStack itemStack : modules) {
                Item item = itemStack.m_41720_();
                if (!(item instanceof ModuleItem)) continue;
                ModuleItem module = (ModuleItem)item;
                output.add(Component.m_237113_((String)(" " + module.getDisplayname())).m_130940_(ChatFormatting.BLUE));
            }
        }
        if (stack.m_204117_(ModTags.Items.TIERED_UPGRADABLE)) {
            ArrayList<String> list = new ArrayList<String>();
            Item item = stack.m_41720_();
            if (item instanceof TieredUpgradableItem) {
                TieredUpgradableItem tiered = (TieredUpgradableItem)item;
                for (String string : tiered.getTierMap().keySet()) {
                    if (list.contains(string)) continue;
                    list.add(string);
                }
            }
            for (String string : list) {
                int tier;
                Object translatable = "functionalfeatures.upgrade." + string;
                if (stack.m_41720_() instanceof AdvancedBundleItem && string.equals("max")) {
                    translatable = "functionalfeatures.upgrade.capacity";
                }
                if ((tier = AdvancedItemUtil.getSpecsUpgradeTier(stack, string)) == -1) continue;
                MutableComponent component = Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)translatable).m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237113_((String)(" " + AdvancedItemUtil.getNumerals(tier + 1))).m_130940_(ChatFormatting.BLUE)));
                output.add(component);
            }
        }
        return output;
    }

    public static MutableComponent getVolumeText(ItemStack itemstack) {
        int volume = AdvancedItemUtil.getSpecsVolume(itemstack)[0];
        int max = AdvancedItemUtil.getSpecsVolume(itemstack)[1];
        FluidStack fluidStack = AdvancedItemUtil.getSpecsFluidStack(itemstack);
        Fluid fluid = fluidStack.getFluid();
        Block block = AdvancedItemUtil.getSpecsBlock(itemstack);
        String drink = AdvancedItemUtil.getSpecsDrink(itemstack);
        if (fluid != Fluids.f_76191_) {
            block = fluid.m_76145_().m_76188_().m_60734_();
        }
        String contents = drink.equals("Empty") ? Component.m_237115_((String)block.m_7705_()).getString() : drink;
        String output = volume == 0 ? (!itemstack.m_150930_((Item)ModItems.ADVANCED_BUCKET.get()) ? "0/" + max : "Empty: 0/" + max) : (itemstack.m_150930_((Item)ModItems.ADVANCED_BUCKET.get()) ? "Contains: " + contents + " " + volume + "/" + max : (itemstack.m_150930_((Item)ModItems.ADVANCED_BUCKET.get()) ? "Servings: " + contents + " " + volume + "/" + max : volume + "/" + max));
        return Component.m_237113_((String)output).m_130940_(ChatFormatting.GRAY);
    }

    public static void makeHideableTooltip(List<Component> mainlist, List<Component> hiddenlist) {
        if (!InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
            MutableComponent part1 = Component.m_237113_((String)"Hold [").m_130940_(ChatFormatting.DARK_GRAY);
            MutableComponent shift = Component.m_237113_((String)"Shift").m_130940_(ChatFormatting.GRAY);
            MutableComponent part2 = Component.m_237113_((String)"] to view details").m_130940_(ChatFormatting.DARK_GRAY);
            mainlist.add((Component)part1.m_6881_().m_7220_((Component)shift).m_7220_((Component)part2));
        } else {
            mainlist.addAll(hiddenlist);
        }
    }
}

