/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.util;

import java.util.ArrayList;
import java.util.List;
import jeffdallama.features.item.ModItems;
import jeffdallama.features.item.custom.modules.ModuleItem;
import jeffdallama.features.networking.ModMessages;
import jeffdallama.features.networking.packet.ModuleResultS2CPacket;
import jeffdallama.features.util.ModTags;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;

public class ModuleUtil {
    private static final int absoluteMaxMods = 3;

    public static ItemStack setActive(ItemStack stack, boolean yn) {
        CompoundTag tags = stack.m_41784_();
        tags.m_128379_("Active", yn);
        return stack;
    }

    public static boolean getSpecsActive(ItemStack stack) {
        CompoundTag tags = stack.m_41784_();
        boolean active = false;
        if (tags.m_128441_("Active")) {
            active = tags.m_128471_("Active");
        }
        return active;
    }

    public static void activateInstance(Player player) {
        boolean flag;
        Inventory inventory = player.m_150109_();
        ArrayList<Integer> slots = new ArrayList<Integer>();
        slots.add(player.m_150109_().f_35977_);
        boolean bl = flag = player.m_20202_() != null;
        if (inventory.m_8020_(inventory.f_35977_).m_41720_() instanceof ProjectileWeaponItem) {
            Integer quiverSlot = null;
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                if (!ModuleUtil.hasModule(inventory.m_8020_(i), (Item)ModItems.QUIVER_MODULE.get())) continue;
                quiverSlot = i;
                break;
            }
            if (quiverSlot != null) {
                slots.add(quiverSlot);
            }
        }
        if (flag) {
            slots.add(36);
        }
        slots.add(40);
        slots.add(39);
        slots.add(38);
        slots.add(37);
        if (!flag) {
            slots.add(36);
        }
        for (Integer slot : slots) {
            if (!ModuleUtil.activateModule(player, slot, (Container)player.m_150109_(), false)) continue;
            return;
        }
    }

    public static void activateInventory(Player player, Container inventory, int slot) {
        ModuleUtil.activateModule(player, slot, inventory, true);
    }

    public static boolean activateModule(Player player, Integer slot, Container inventory, boolean flag) {
        ItemStack itemstack = player.m_150109_().m_8020_(slot.intValue());
        ItemStack copystack = itemstack.m_41777_();
        List<ItemStack> modStacks = ModuleUtil.getSpecsModules(itemstack);
        if (modStacks.isEmpty()) {
            return false;
        }
        for (ItemStack moduleStack : modStacks) {
            ServerPlayer serverPlayer;
            Item item = moduleStack.m_41720_();
            if (!(item instanceof ModuleItem)) continue;
            ModuleItem module = (ModuleItem)item;
            if ((!flag && module.getActive() || flag && module.getInventoryActive()) && !player.m_36335_().m_41519_(itemstack.m_41720_()) && module.Activate(player, itemstack, slot, inventory)) {
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    int cooldown = module.getCooldown(player, itemstack);
                    if (cooldown != 0) {
                        player.m_36335_().m_41524_(itemstack.m_41720_(), cooldown);
                    }
                    if (!flag && module.getActive() || flag && module.getinventoryResults()) {
                        ModMessages.sendtoplayer(new ModuleResultS2CPacket(new ItemStack((ItemLike)module), copystack, false), serverPlayer);
                    }
                    SoundEvent sound = module.getActivateSound(itemstack);
                    ModMessages.sendSoundPacket(sound, serverPlayer, player.m_20183_());
                }
                return true;
            }
            if (!(player instanceof ServerPlayer)) continue;
            serverPlayer = (ServerPlayer)player;
            if (!flag && module.getActive() || flag && module.getinventoryResults()) {
                ModMessages.sendtoplayer(new ModuleResultS2CPacket(new ItemStack((ItemLike)module), itemstack, true), serverPlayer);
            }
            SoundEvent sound = module.getFailSound(itemstack);
            ModMessages.sendSoundPacket(sound, serverPlayer, player.m_20183_());
        }
        return false;
    }

    public static List<ItemStack> getSpecsModules(ItemStack itemstack) {
        CompoundTag originalTags = itemstack.m_41784_();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (originalTags.m_128441_("modules")) {
            ListTag listTag = originalTags.m_128437_("modules", 10);
            for (Object object : listTag) {
                CompoundTag compound = (CompoundTag)object;
                list.add(ItemStack.m_41712_((CompoundTag)compound));
            }
        }
        return list;
    }

    public static int getSpecsNumModules(ItemStack stack) {
        return ModuleUtil.getSpecsModules(stack).size();
    }

    public static int getSpecsMaxModules(ItemStack stack) {
        if (stack.m_204117_(ModTags.Items.EXTRA_MODS)) {
            return 3;
        }
        return 1;
    }

    public static ListTag getModulesCompound(List<ItemStack> mods) {
        ListTag output = new ListTag();
        for (ItemStack stack : mods) {
            output.add((Object)stack.m_41739_(new CompoundTag()));
        }
        return output;
    }

    public static List<Component> getModulesComponent(ItemStack itemstack) {
        ArrayList<Component> output = new ArrayList<Component>();
        List<ItemStack> mods = ModuleUtil.getSpecsModules(itemstack);
        if (!mods.isEmpty()) {
            for (ItemStack modstack : mods) {
                ModuleItem mod;
                Component component;
                Item item = modstack.m_41720_();
                if (!(item instanceof ModuleItem) || (component = (mod = (ModuleItem)item).getHoverText(itemstack)) == null) continue;
                output.add(component);
            }
        }
        return output;
    }

    public static ItemStack getItemStackHasModule(Player player, Item module) {
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!ModuleUtil.hasModule(stack, module)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static boolean hasModule(ItemStack itemstack, Item module) {
        List<ItemStack> modules = ModuleUtil.getSpecsModules(itemstack);
        for (ItemStack stack : modules) {
            if (stack.m_41720_() != module) continue;
            return true;
        }
        return false;
    }

    public static ItemStack giveModule(ItemStack itemstack, Item module) {
        if (ModuleUtil.hasModule(itemstack, module)) {
            return itemstack;
        }
        List<ItemStack> modules = ModuleUtil.getSpecsModules(itemstack);
        modules.add(new ItemStack((ItemLike)module));
        ListTag listtag = new ListTag();
        for (ItemStack stack : modules) {
            listtag.add((Object)stack.m_41739_(new CompoundTag()));
        }
        CompoundTag tags = itemstack.m_41784_();
        tags.m_128365_("modules", (Tag)listtag);
        itemstack.m_41751_(tags);
        return itemstack;
    }
}

