/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.foldediron.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;

public class ModelCrow
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"folded_iron", (String)"model_crow"), "main");
    public final ModelPart body;
    public final ModelPart tail;
    public final ModelPart head;
    public final ModelPart wing_right;
    public final ModelPart wing_right_lower;
    public final ModelPart wing_left;
    public final ModelPart wing_left_lower;
    public final ModelPart leg_right;
    public final ModelPart leg_left;

    public ModelCrow(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.tail = this.body.getChild("tail");
        this.head = this.body.getChild("head");
        this.wing_right = this.body.getChild("wing_right");
        this.wing_right_lower = this.wing_right.getChild("wing_right_lower");
        this.wing_left = this.body.getChild("wing_left");
        this.wing_left_lower = this.wing_left.getChild("wing_left_lower");
        this.leg_right = root.getChild("leg_right");
        this.leg_left = root.getChild("leg_left");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)20.0f, (float)1.0f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 12).addBox(-2.0f, -2.0f, -1.0f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)2.0f, (float)-2.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = body.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 5).addBox(-2.0f, -3.0f, -1.0f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-2.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, 0.0f, 0.0f, 6.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 17).addBox(-1.0f, -4.0f, -2.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(10, 20).addBox(-0.5f, -3.0f, -4.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)0.0f, (float)-1.0f));
        PartDefinition wing_right = body.addOrReplaceChild("wing_right", CubeListBuilder.create().texOffs(18, 5).addBox(0.0f, -1.0f, 0.0f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-1.0f, (float)-2.0f));
        PartDefinition wing_right_lower = wing_right.addOrReplaceChild("wing_right_lower", CubeListBuilder.create().texOffs(14, 12).addBox(-0.5f, 0.0f, 0.0f, 0.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-0.5f, (float)0.5f));
        PartDefinition wing_left = body.addOrReplaceChild("wing_left", CubeListBuilder.create().texOffs(18, 5).mirror().addBox(-1.0f, -1.0f, 0.0f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.0f, (float)-1.0f, (float)-2.0f));
        PartDefinition wing_left_lower = wing_left.addOrReplaceChild("wing_left_lower", CubeListBuilder.create().texOffs(14, 12).mirror().addBox(0.5f, 0.0f, 0.0f, 0.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-1.0f, (float)-0.5f, (float)0.5f));
        PartDefinition leg_right = partdefinition.addOrReplaceChild("leg_right", CubeListBuilder.create().texOffs(18, 10).addBox(-0.5f, 3.0f, -2.0f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(10, 17).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)21.0f, (float)2.0f));
        PartDefinition leg_left = partdefinition.addOrReplaceChild("leg_left", CubeListBuilder.create().texOffs(18, 10).mirror().addBox(-0.5f, 3.0f, -2.0f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(10, 17).mirror().addBox(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-1.0f, (float)21.0f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
    }
}

