/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.foldediron.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;

public class ModelDruid
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"folded_iron", (String)"model_druid"), "main");
    public final ModelPart root;
    public final ModelPart head;
    public final ModelPart arm_right;
    public final ModelPart arm_left;
    public final ModelPart leg_right;
    public final ModelPart leg_left;

    public ModelDruid(ModelPart root) {
        super(root);
        this.root = root.getChild("root");
        this.head = this.root.getChild("head");
        this.arm_right = this.head.getChild("arm_right");
        this.arm_left = this.head.getChild("arm_left");
        this.leg_right = this.root.getChild("leg_right");
        this.leg_left = this.root.getChild("leg_left");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 25).mirror().addBox(-5.0f, -7.5f, -2.9375f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 0).addBox(-4.0f, -4.5f, 0.0625f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-4.5f, -4.0f, -1.1875f, 9.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 25).addBox(3.0f, -7.5f, -2.9375f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.5f, (float)-4.0625f));
        PartDefinition arm_right = head.addOrReplaceChild("arm_right", CubeListBuilder.create().texOffs(22, 16).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)-0.5f, (float)4.0625f));
        PartDefinition arm_left = head.addOrReplaceChild("arm_left", CubeListBuilder.create().texOffs(22, 16).mirror().addBox(-3.0f, -2.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-5.0f, (float)-0.5f, (float)4.0625f));
        PartDefinition leg_right = root.addOrReplaceChild("leg_right", CubeListBuilder.create().texOffs(8, 25).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-3.0f, (float)0.0f));
        PartDefinition leg_left = root.addOrReplaceChild("leg_left", CubeListBuilder.create().texOffs(8, 25).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.0f, (float)-3.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
    }
}

