/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.foldediron.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mcreator.foldediron.client.model.ModelBasic_progectile;
import net.mcreator.foldediron.entity.BasicProgectileEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class BasicProgectileRenderer
extends EntityRenderer<BasicProgectileEntity, LivingEntityRenderState> {
    private static final ResourceLocation texture = ResourceLocation.parse((String)"folded_iron:textures/entities/basic_progectile.png");
    private final ModelBasic_progectile model;

    public BasicProgectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new ModelBasic_progectile(context.bakeLayer(ModelBasic_progectile.LAYER_LOCATION));
    }

    public void render(LivingEntityRenderState state, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        VertexConsumer vb = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)texture));
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(state.yRot - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f + state.xRot));
        this.model.setupAnim(state);
        this.model.renderToBuffer(poseStack, vb, packedLightIn, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((EntityRenderState)state, poseStack, bufferIn, packedLightIn);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(BasicProgectileEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, partialTicks);
        state.xRot = entity.getXRot(partialTicks);
        state.yRot = entity.getYRot(partialTicks);
    }
}

