/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.foldediron.client.renderer;

import net.mcreator.foldediron.client.model.ModelCrow;
import net.mcreator.foldediron.client.model.animations.CrowAnimation;
import net.mcreator.foldediron.entity.CrowEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class CrowRenderer
extends MobRenderer<CrowEntity, LivingEntityRenderState, ModelCrow> {
    private CrowEntity entity = null;

    public CrowRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelCrow.LAYER_LOCATION)), 0.2f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(CrowEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"folded_iron:textures/entities/crow_texture.png");
    }

    private static final class AnimatedModel
    extends ModelCrow {
        private CrowEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(CrowEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animate(this.entity.animationState0, CrowAnimation.Fly, state.ageInTicks, 1.0f);
            this.animateWalk(CrowAnimation.walk, state.walkAnimationPos, state.walkAnimationSpeed, 1.0f, 1.0f);
            super.setupAnim(state);
        }
    }
}

