/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.foldediron.client.renderer;

import net.mcreator.foldediron.client.model.ModelDruid;
import net.mcreator.foldediron.client.model.animations.DruidAnimation;
import net.mcreator.foldediron.entity.DruidEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class DruidRenderer
extends MobRenderer<DruidEntity, LivingEntityRenderState, ModelDruid> {
    private DruidEntity entity = null;

    public DruidRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelDruid.LAYER_LOCATION)), 0.2f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(DruidEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"folded_iron:textures/entities/druid.png");
    }

    private static final class AnimatedModel
    extends ModelDruid {
        private DruidEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(DruidEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animate(this.entity.animationState0, DruidAnimation.float_moving, state.ageInTicks, 1.0f);
            this.animate(this.entity.animationState1, DruidAnimation.float_idle, state.ageInTicks, 1.0f);
            this.animate(this.entity.animationState2, DruidAnimation.attack, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

