/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.foldediron.client.renderer;

import net.mcreator.foldediron.client.model.ModelShiver;
import net.mcreator.foldediron.client.model.animations.ShiverAnimation;
import net.mcreator.foldediron.entity.ShiverEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class ShiverRenderer
extends MobRenderer<ShiverEntity, LivingEntityRenderState, ModelShiver> {
    private ShiverEntity entity = null;

    public ShiverRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelShiver.LAYER_LOCATION)), 0.5f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(ShiverEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"folded_iron:textures/entities/shiver.png");
    }

    private static final class AnimatedModel
    extends ModelShiver {
        private ShiverEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(ShiverEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animateWalk(ShiverAnimation.walk, state.walkAnimationPos, state.walkAnimationSpeed, 1.0f, 2.0f);
            this.animate(this.entity.animationState1, ShiverAnimation.attack, state.ageInTicks, 1.0f);
            this.animate(this.entity.animationState2, ShiverAnimation.falling, state.ageInTicks, 1.0f);
            this.animate(this.entity.animationState3, ShiverAnimation.stun, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

