/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.foldediron.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mcreator.foldediron.client.model.ModelSplitter_big_progectile;
import net.mcreator.foldediron.entity.SpliterbigEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class SpliterbigRenderer
extends EntityRenderer<SpliterbigEntity, LivingEntityRenderState> {
    private static final ResourceLocation texture = ResourceLocation.parse((String)"folded_iron:textures/entities/spliter_big.png");
    private final ModelSplitter_big_progectile model;

    public SpliterbigRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new ModelSplitter_big_progectile(context.bakeLayer(ModelSplitter_big_progectile.LAYER_LOCATION));
    }

    public void render(LivingEntityRenderState state, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        VertexConsumer vb = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)texture));
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(state.yRot - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f + state.xRot));
        this.model.setupAnim(state);
        this.model.renderToBuffer(poseStack, vb, packedLightIn, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((EntityRenderState)state, poseStack, bufferIn, packedLightIn);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(SpliterbigEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, partialTicks);
        state.xRot = entity.getXRot(partialTicks);
        state.yRot = entity.getYRot(partialTicks);
    }
}

