/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.foldediron.entity;

import net.mcreator.foldediron.init.FoldedIronModEntities;
import net.mcreator.foldediron.procedures.ShiverAttackPlaybackConditionProcedure;
import net.mcreator.foldediron.procedures.ShiverEntityIsHurtProcedure;
import net.mcreator.foldediron.procedures.ShiverFallPlaybackConditionProcedure;
import net.mcreator.foldediron.procedures.ShiverOnEntityTickUpdateProcedure;
import net.mcreator.foldediron.procedures.ShiverStunPlaybackConditionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class ShiverEntity
extends Monster {
    public static final EntityDataAccessor<Integer> DATA_Particle_timer = SynchedEntityData.defineId(ShiverEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_Stun_duration = SynchedEntityData.defineId(ShiverEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_StunRNG = SynchedEntityData.defineId(ShiverEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_Play_stun_animation = SynchedEntityData.defineId(ShiverEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_Stun_cooldown = SynchedEntityData.defineId(ShiverEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();

    public ShiverEntity(EntityType<ShiverEntity> type, Level world) {
        super(type, world);
        this.xpReward = 5;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_Particle_timer, (Object)0);
        builder.define(DATA_Stun_duration, (Object)0);
        builder.define(DATA_StunRNG, (Object)0);
        builder.define(DATA_Play_stun_animation, (Object)false);
        builder.define(DATA_Stun_cooldown, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new FloatGoal((Mob)this));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        ShiverEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        ShiverEntityIsHurtProcedure.execute((LevelAccessor)world, (Entity)entity, sourceentity);
        return super.hurtServer(level, damagesource, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("DataParticle_timer", ((Integer)this.entityData.get(DATA_Particle_timer)).intValue());
        compound.putInt("DataStun_duration", ((Integer)this.entityData.get(DATA_Stun_duration)).intValue());
        compound.putInt("DataStunRNG", ((Integer)this.entityData.get(DATA_StunRNG)).intValue());
        compound.putBoolean("DataPlay_stun_animation", ((Boolean)this.entityData.get(DATA_Play_stun_animation)).booleanValue());
        compound.putInt("DataStun_cooldown", ((Integer)this.entityData.get(DATA_Stun_cooldown)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataParticle_timer")) {
            this.entityData.set(DATA_Particle_timer, (Object)compound.getInt("DataParticle_timer"));
        }
        if (compound.contains("DataStun_duration")) {
            this.entityData.set(DATA_Stun_duration, (Object)compound.getInt("DataStun_duration"));
        }
        if (compound.contains("DataStunRNG")) {
            this.entityData.set(DATA_StunRNG, (Object)compound.getInt("DataStunRNG"));
        }
        if (compound.contains("DataPlay_stun_animation")) {
            this.entityData.set(DATA_Play_stun_animation, (Object)compound.getBoolean("DataPlay_stun_animation"));
        }
        if (compound.contains("DataStun_cooldown")) {
            this.entityData.set(DATA_Stun_cooldown, (Object)compound.getInt("DataStun_cooldown"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(ShiverAttackPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(ShiverFallPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(ShiverStunPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        ShiverOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)FoldedIronModEntities.SHIVER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.checkMobSpawnRules((EntityType)entityType, (LevelAccessor)world, (EntitySpawnReason)reason, (BlockPos)pos, (RandomSource)random), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.24);
        builder = builder.add(Attributes.MAX_HEALTH, 30.0);
        builder = builder.add(Attributes.ARMOR, 1.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.01);
        return builder;
    }
}

