/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.foldediorn.client.renderer;

import net.mcreator.foldediorn.client.model.Modelmushy;
import net.mcreator.foldediorn.client.model.animations.mushyAnimation;
import net.mcreator.foldediorn.entity.MushyEntity;
import net.mcreator.foldediorn.procedures.MushyAggroRunPlaybackConditionProcedure;
import net.mcreator.foldediorn.procedures.MushyIsEntityModelShakingProcedure;
import net.mcreator.foldediorn.procedures.MushyWalkPlaybackConditionProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class MushyRenderer
extends MobRenderer<MushyEntity, LivingEntityRenderState, Modelmushy> {
    private MushyEntity entity = null;

    public MushyRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelmushy.LAYER_LOCATION)), 0.5f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(MushyEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"folded_iorn:textures/entities/mushyfinal.png");
    }

    protected boolean isShaking(LivingEntityRenderState state) {
        Level world = this.entity.level();
        double x = this.entity.getX();
        double y = this.entity.getY();
        double z = this.entity.getZ();
        return MushyIsEntityModelShakingProcedure.execute((Entity)this.entity);
    }

    private static final class AnimatedModel
    extends Modelmushy {
        private MushyEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(MushyEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            if (MushyWalkPlaybackConditionProcedure.execute((Entity)this.entity)) {
                this.animateWalk(mushyAnimation.Walk, state.walkAnimationPos, state.walkAnimationSpeed, 1.0f, 1.0f);
            }
            if (MushyAggroRunPlaybackConditionProcedure.execute((Entity)this.entity)) {
                this.animateWalk(mushyAnimation.aggrowalk, state.walkAnimationPos, state.walkAnimationSpeed, 1.0f, 1.0f);
            }
            this.animate(this.entity.animationState2, mushyAnimation.mushystun, state.ageInTicks, 1.0f);
            this.animate(this.entity.animationState3, mushyAnimation.Spawn, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

