/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.foldediorn.init;

import net.mcreator.foldediorn.entity.BunnyGoliathEntity;
import net.mcreator.foldediorn.entity.IceTowerEntity;
import net.mcreator.foldediorn.entity.IceTowerGuardEntity;
import net.mcreator.foldediorn.entity.MushyEntity;
import net.mcreator.foldediorn.entity.ShamenEntity;
import net.mcreator.foldediorn.entity.ShiverEntity;
import net.mcreator.foldediorn.entity.VoidedcreeperEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class FoldedIornModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"folded_iorn");
    public static final DeferredHolder<EntityType<?>, EntityType<MushyEntity>> MUSHY = FoldedIornModEntities.register("mushy", EntityType.Builder.of(MushyEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<ShiverEntity>> SHIVER = FoldedIornModEntities.register("shiver", EntityType.Builder.of(ShiverEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<IceTowerEntity>> ICE_TOWER = FoldedIornModEntities.register("ice_tower", EntityType.Builder.of(IceTowerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(1.0f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<IceTowerGuardEntity>> ICE_TOWER_GUARD = FoldedIornModEntities.register("ice_tower_guard", EntityType.Builder.of(IceTowerGuardEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 0.6f));
    public static final DeferredHolder<EntityType<?>, EntityType<BunnyGoliathEntity>> BUNNY_GOLIATH = FoldedIornModEntities.register("bunny_goliath", EntityType.Builder.of(BunnyGoliathEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(3.0f, 4.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<VoidedcreeperEntity>> VOIDEDCREEPER = FoldedIornModEntities.register("voidedcreeper", EntityType.Builder.of(VoidedcreeperEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<ShamenEntity>> SHAMEN = FoldedIornModEntities.register("shamen", EntityType.Builder.of(ShamenEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"folded_iorn", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        MushyEntity.init(event);
        ShiverEntity.init(event);
        IceTowerEntity.init(event);
        IceTowerGuardEntity.init(event);
        BunnyGoliathEntity.init(event);
        VoidedcreeperEntity.init(event);
        ShamenEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)MUSHY.get(), MushyEntity.createAttributes().build());
        event.put((EntityType)SHIVER.get(), ShiverEntity.createAttributes().build());
        event.put((EntityType)ICE_TOWER.get(), IceTowerEntity.createAttributes().build());
        event.put((EntityType)ICE_TOWER_GUARD.get(), IceTowerGuardEntity.createAttributes().build());
        event.put((EntityType)BUNNY_GOLIATH.get(), BunnyGoliathEntity.createAttributes().build());
        event.put((EntityType)VOIDEDCREEPER.get(), VoidedcreeperEntity.createAttributes().build());
        event.put((EntityType)SHAMEN.get(), ShamenEntity.createAttributes().build());
    }
}

