/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.foldediorn.init;

import net.mcreator.foldediorn.potion.CorrodedMobEffect;
import net.mcreator.foldediorn.potion.EnragedMobEffect;
import net.mcreator.foldediorn.potion.FrostedMobEffect;
import net.mcreator.foldediorn.potion.IsIceTowerMobEffect;
import net.mcreator.foldediorn.potion.RabbitchestMobEffect;
import net.mcreator.foldediorn.potion.RegreatMobEffect;
import net.mcreator.foldediorn.potion.StunCooldownMobEffect;
import net.mcreator.foldediorn.potion.SwiftPunchMobEffect;
import net.mcreator.foldediorn.procedures.SwiftPunchEffectExpiresProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class FoldedIornModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"folded_iorn");
    public static final DeferredHolder<MobEffect, MobEffect> SWIFT_PUNCH = REGISTRY.register("swift_punch", () -> new SwiftPunchMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> STUN_COOLDOWN = REGISTRY.register("stun_cooldown", () -> new StunCooldownMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> IS_ICE_TOWER = REGISTRY.register("is_ice_tower", () -> new IsIceTowerMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FROSTED = REGISTRY.register("frosted", () -> new FrostedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CORRODED = REGISTRY.register("corroded", () -> new CorrodedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ENRAGED = REGISTRY.register("enraged", () -> new EnragedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> RABBITCHEST = REGISTRY.register("rabbitchest", () -> new RabbitchestMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> REGREAT = REGISTRY.register("regreat", () -> new RegreatMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            FoldedIornModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            FoldedIornModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(SWIFT_PUNCH)) {
            SwiftPunchEffectExpiresProcedure.execute(entity);
        }
    }
}

