/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.foldediorn.item;

import java.util.List;
import net.mcreator.foldediorn.procedures.FrostHeartItemInHandTickProcedure;
import net.mcreator.foldediorn.procedures.FrostHeartRightclickedProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class FrostHeartItem
extends Item {
    public FrostHeartItem(Item.Properties properties) {
        super(properties.rarity(Rarity.RARE).durability(16).fireResistant());
    }

    public ItemStack getCraftingRemainder(ItemStack itemstack) {
        ItemStack retval = new ItemStack((ItemLike)this);
        retval.setDamageValue(itemstack.getDamageValue() + 1);
        if (retval.getDamageValue() >= retval.getMaxDamage()) {
            return ItemStack.EMPTY;
        }
        return retval;
    }

    public boolean isCombineRepairable(ItemStack itemstack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.folded_iorn.frost_heart.description_0"));
        list.add((Component)Component.translatable((String)"item.folded_iorn.frost_heart.description_1"));
        list.add((Component)Component.translatable((String)"item.folded_iorn.frost_heart.description_2"));
        list.add((Component)Component.translatable((String)"item.folded_iorn.frost_heart.description_3"));
    }

    public InteractionResult use(Level world, Player entity, InteractionHand hand) {
        InteractionResult ar = super.use(world, entity, hand);
        FrostHeartRightclickedProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, entity.getItemInHand(hand));
        return ar;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            FrostHeartItemInHandTickProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ());
        }
    }
}

