/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.foldediorn.item;

import net.mcreator.foldediorn.procedures.SpawnPotionItemInHandTickProcedure;
import net.mcreator.foldediorn.procedures.SpawnPotionPlayerFinishesUsingItemProcedure;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class SpawnPotionItem
extends Item {
    public SpawnPotionItem(Item.Properties properties) {
        super(properties.rarity(Rarity.UNCOMMON).stacksTo(64).food(new FoodProperties.Builder().nutrition(0).saturationModifier(0.0f).alwaysEdible().build()));
    }

    public ItemUseAnimation getUseAnimation(ItemStack itemstack) {
        return ItemUseAnimation.DRINK;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 100;
    }

    public ItemStack finishUsingItem(ItemStack itemstack, Level world, LivingEntity entity) {
        ItemStack retval = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        super.finishUsingItem(itemstack, world, entity);
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        SpawnPotionPlayerFinishesUsingItemProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        if (itemstack.isEmpty()) {
            return retval;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.getAbilities().instabuild && !player.getInventory().add(retval)) {
                player.drop(retval, false);
            }
        }
        return itemstack;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            SpawnPotionItemInHandTickProcedure.execute(entity);
        }
    }
}

