/*
 * Decompiled with CFR 0.152.
 */
package cn.kurt6.landlord;

public class Card {
    private final String suit;
    private final int value;

    public Card(String suit, int value) {
        this.suit = suit;
        this.value = value;
    }

    public String getSuit() {
        return this.suit;
    }

    public int getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return switch (this.value) {
            case 17 -> "\u5927\u738b";
            case 16 -> "\u5c0f\u738b";
            case 15 -> "2";
            case 14 -> "A";
            case 13 -> "K";
            case 12 -> "Q";
            case 11 -> "J";
            default -> String.valueOf(this.value);
        };
    }

    public String toString() {
        if (this.value == 16) {
            return "\ud83c\udccf\u5c0f\u738b";
        }
        if (this.value == 17) {
            return "\ud83c\udccf\u5927\u738b";
        }
        String displayName = this.getDisplayName();
        String colorCode = this.suit.equals("\u2660") || this.suit.equals("\u2663") ? "\u00a77" : "\u00a7c";
        return colorCode + this.suit + displayName + "\u00a7r";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Card card = (Card)obj;
        return this.value == card.value && this.suit.equals(card.suit);
    }

    public int hashCode() {
        return this.suit.hashCode() * 31 + this.value;
    }
}

