/*
 * Decompiled with CFR 0.152.
 */
package cn.kurt6.landlord;

import cn.kurt6.landlord.Card;
import cn.kurt6.landlord.GameLogic;
import cn.kurt6.landlord.GameRoom;
import cn.kurt6.landlord.Landlord;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class CardSelectionGUI
implements Listener {
    private final Landlord plugin;
    private final GameRoom gameRoom;
    private final Map<Player, Inventory> openInventories = new HashMap<Player, Inventory>();
    private final Map<Player, List<Integer>> selectedSlots = new HashMap<Player, List<Integer>>();
    private final Set<Player> intentionallyClosing = new HashSet<Player>();
    private final Set<UUID> reopeningPlayers = new HashSet<UUID>();

    public CardSelectionGUI(Landlord plugin, GameRoom gameRoom) {
        this.plugin = plugin;
        this.gameRoom = gameRoom;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openGUI(Player player, List<Card> cards) {
        if (cards == null || cards.isEmpty()) {
            return;
        }
        if (this.openInventories.containsKey(player) || this.gameRoom.isAutoPlay(player)) {
            return;
        }
        int cardRows = (int)Math.ceil((double)cards.size() / 9.0);
        int totalRows = cardRows + 2;
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)(totalRows * 9), (String)(String.valueOf(ChatColor.GOLD) + "\u9009\u62e9\u8981\u51fa\u7684\u724c"));
        for (int i = 0; i < cards.size(); ++i) {
            inv.setItem(i, this.createCardItem(cards.get(i), false));
        }
        int buttonRow = (totalRows - 2) * 9;
        inv.setItem(buttonRow, this.createButton(Material.LIME_WOOL, String.valueOf(ChatColor.GREEN) + "\u2714 \u786e\u8ba4\u51fa\u724c", Collections.singletonList(String.valueOf(ChatColor.GRAY) + "\u70b9\u51fb\u786e\u8ba4\u51fa\u724c")));
        inv.setItem(buttonRow + 1, this.createButton(Material.RED_WOOL, String.valueOf(ChatColor.RED) + "\u2716 \u6e05\u7a7a\u9009\u62e9", Collections.singletonList(String.valueOf(ChatColor.GRAY) + "\u70b9\u51fb\u6e05\u7a7a\u5df2\u9009\u724c")));
        boolean canPass = !this.gameRoom.getLastPlayedCards().isEmpty() || this.gameRoom.getPassCount() != 0;
        inv.setItem(buttonRow + 2, this.createButton(canPass ? Material.YELLOW_WOOL : Material.GRAY_WOOL, canPass ? String.valueOf(ChatColor.YELLOW) + "\u279c \u8fc7\u724c" : String.valueOf(ChatColor.GRAY) + "\u279c \u4e0d\u80fd\u8fc7\u724c", Collections.singletonList(canPass ? String.valueOf(ChatColor.GRAY) + "\u70b9\u51fb\u8df3\u8fc7\u672c\u8f6e" : String.valueOf(ChatColor.RED) + "\u7b2c\u4e00\u8f6e\u5fc5\u987b\u51fa\u724c\uff01")));
        inv.setItem(buttonRow + 3, this.createButton(Material.BLUE_WOOL, this.gameRoom.isAutoPlay(player) ? String.valueOf(ChatColor.RED) + "\u23f9 \u53d6\u6d88\u6258\u7ba1" : String.valueOf(ChatColor.BLUE) + "\u25b6 \u6258\u7ba1", Collections.singletonList(String.valueOf(ChatColor.GRAY) + "\u70b9\u51fb\u5207\u6362\u6258\u7ba1\u6a21\u5f0f")));
        for (int i = buttonRow + 4; i < buttonRow + 9; ++i) {
            inv.setItem(i, this.createSeparator());
        }
        int infoRow = (totalRows - 1) * 9;
        inv.setItem(infoRow, this.createInfoItem("\u5f53\u524d\u624b\u724c", cards.size() + "\u5f20", Material.PAPER));
        inv.setItem(infoRow + 1, this.createSelectedCardsInfoItem(player, Collections.emptyList()));
        inv.setItem(infoRow + 2, this.createLastPlayedInfoItem());
        inv.setItem(infoRow + 3, this.createInfoItem("\u5f53\u524d\u500d\u6570", "x" + this.gameRoom.getMultiplier(), Material.GOLD_INGOT));
        inv.setItem(infoRow + 4, this.createInfoItem("\u5f53\u524d\u73a9\u5bb6", this.gameRoom.getCurrentPlayer().getName(), Material.PLAYER_HEAD));
        for (int i = infoRow + 5; i < infoRow + 9; ++i) {
            inv.setItem(i, this.createSeparator());
        }
        player.openInventory(inv);
        this.openInventories.put(player, inv);
        this.selectedSlots.put(player, new ArrayList());
    }

    private void updateSelectionValidity(Player player, List<Integer> selected) {
        ItemStack confirmButton;
        Inventory inv = this.openInventories.get(player);
        if (inv == null) {
            return;
        }
        List<Card> cards = this.gameRoom.getPlayerCards(player);
        ArrayList<Card> selectedCards = new ArrayList<Card>();
        for (int index : selected) {
            if (index >= cards.size()) continue;
            selectedCards.add(cards.get(index));
        }
        GameLogic.CardPattern pattern = GameLogic.recognizePattern(selectedCards);
        boolean isValid = pattern.getType() != GameLogic.CardType.INVALID;
        boolean canBeat = true;
        if (isValid && !this.gameRoom.getLastPlayedCards().isEmpty()) {
            GameLogic.CardPattern lastPattern = GameLogic.recognizePattern(this.gameRoom.getLastPlayedCards());
            canBeat = pattern.canBeat(lastPattern);
        }
        if ((confirmButton = inv.getItem((inv.getSize() / 9 - 2) * 9)) != null) {
            ItemMeta meta = confirmButton.getItemMeta();
            if (selected.isEmpty()) {
                confirmButton.setType(Material.GRAY_WOOL);
                meta.setDisplayName(String.valueOf(ChatColor.GRAY) + "\u2716 \u8bf7\u9009\u62e9\u724c");
                meta.setLore(Collections.singletonList(String.valueOf(ChatColor.RED) + "\u8bf7\u5148\u9009\u62e9\u8981\u51fa\u7684\u724c"));
            } else if (isValid) {
                if (canBeat) {
                    confirmButton.setType(Material.LIME_WOOL);
                    meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "\u2714 \u786e\u8ba4\u51fa\u724c");
                    meta.setLore(Collections.singletonList(String.valueOf(ChatColor.GRAY) + "\u724c\u578b: " + GameRoom.getPatternName(pattern.getType())));
                } else {
                    confirmButton.setType(Material.RED_WOOL);
                    meta.setDisplayName(String.valueOf(ChatColor.RED) + "\u2716 \u65e0\u6cd5\u538b\u8fc7");
                    meta.setLore(Collections.singletonList(String.valueOf(ChatColor.RED) + "\u65e0\u6cd5\u538b\u8fc7\u4e0a\u5bb6\u7684\u724c"));
                }
            } else {
                confirmButton.setType(Material.RED_WOOL);
                meta.setDisplayName(String.valueOf(ChatColor.RED) + "\u2716 \u65e0\u6548\u724c\u578b");
                meta.setLore(Collections.singletonList(String.valueOf(ChatColor.RED) + "\u8bf7\u9009\u62e9\u6709\u6548\u724c\u578b"));
            }
            confirmButton.setItemMeta(meta);
        }
        this.updateSelectedCardsInfo(player, selectedCards);
    }

    private ItemStack createSelectedCardsInfoItem(Player player, List<Card> selectedCards) {
        ItemStack item = new ItemStack(Material.BOOK);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "\u5df2\u9009\u724c");
        ArrayList<CallSite> lore = new ArrayList<CallSite>();
        if (selectedCards.isEmpty()) {
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "\u65e0")));
        } else {
            lore.add((CallSite)((Object)(ChatColor.GREEN.toString() + selectedCards.size() + "\u5f20:")));
            StringBuilder cardNames = new StringBuilder();
            for (int i = 0; i < selectedCards.size(); ++i) {
                if (i > 0) {
                    cardNames.append(" ");
                }
                cardNames.append(selectedCards.get(i).toString());
                if (cardNames.length() <= 30 || i >= selectedCards.size() - 1) continue;
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.WHITE) + cardNames.toString())));
                cardNames = new StringBuilder();
            }
            if (cardNames.length() > 0) {
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.WHITE) + cardNames.toString())));
            }
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private void updateSelectedCardsInfo(Player player, List<Card> selectedCards) {
        Inventory inv = this.openInventories.get(player);
        if (inv == null) {
            return;
        }
        int totalRows = inv.getSize() / 9;
        int infoRow = (totalRows - 1) * 9;
        ItemStack selectedInfo = this.createSelectedCardsInfoItem(player, selectedCards);
        inv.setItem(infoRow + 1, selectedInfo);
    }

    private ItemStack createLastPlayedInfoItem() {
        List<Card> lastPlayed = this.gameRoom.getLastPlayedCards();
        ItemStack item = new ItemStack(Material.WRITABLE_BOOK);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "\u4e0a\u5bb6\u51fa\u724c");
        ArrayList<CallSite> lore = new ArrayList<CallSite>();
        if (lastPlayed.isEmpty()) {
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "\u65e0")));
        } else {
            GameLogic.CardPattern pattern = GameLogic.recognizePattern(lastPlayed);
            String patternName = GameRoom.getPatternName(pattern.getType());
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.AQUA) + patternName + " (" + lastPlayed.size() + "\u5f20):")));
            StringBuilder cardNames = new StringBuilder();
            for (int i = 0; i < lastPlayed.size(); ++i) {
                if (i > 0) {
                    cardNames.append(" ");
                }
                cardNames.append(lastPlayed.get(i).toString());
                if (cardNames.length() <= 30 || i >= lastPlayed.size() - 1) continue;
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.WHITE) + cardNames.toString())));
                cardNames = new StringBuilder();
            }
            if (cardNames.length() > 0) {
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.WHITE) + cardNames.toString())));
            }
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private String getSelectedCountText(int count) {
        return count > 0 ? String.valueOf(ChatColor.GREEN) + String.valueOf(count) + "\u5f20" : String.valueOf(ChatColor.GRAY) + "\u65e0";
    }

    private String getLastPlayedText() {
        List<Card> lastPlayed = this.gameRoom.getLastPlayedCards();
        return lastPlayed.isEmpty() ? String.valueOf(ChatColor.GRAY) + "\u65e0" : String.valueOf(ChatColor.YELLOW) + String.valueOf(lastPlayed.size()) + "\u5f20";
    }

    private ItemStack createCardItem(Card card, boolean selected) {
        Material material = this.getCardMaterial(card);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(String.valueOf(selected ? String.valueOf(ChatColor.GOLD) + "\u2605 " : ChatColor.WHITE) + card.toString());
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(String.valueOf(ChatColor.GRAY) + "\u724c\u503c: " + card.getValue());
        lore.add(String.valueOf(ChatColor.GRAY) + "\u82b1\u8272: " + card.getSuit());
        lore.add("");
        lore.add(selected ? String.valueOf(ChatColor.RED) + "\u2605 \u5df2\u9009\u4e2d (\u70b9\u51fb\u53d6\u6d88)" : String.valueOf(ChatColor.GREEN) + "\u70b9\u51fb\u9009\u62e9");
        meta.setLore(lore);
        if (selected) {
            meta.addEnchant(Enchantment.VANISHING_CURSE, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createButton(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createInfoItem(String title, String value, Material material) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + title);
        meta.setLore(Collections.singletonList(String.valueOf(ChatColor.WHITE) + value));
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createSeparator() {
        ItemStack item = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(" ");
        item.setItemMeta(meta);
        return item;
    }

    private Material getCardMaterial(Card card) {
        int value = card.getValue();
        if (value == 16) {
            return Material.PAPER;
        }
        if (value == 17) {
            return Material.BOOK;
        }
        switch (value) {
            case 3: {
                return Material.WHITE_CONCRETE;
            }
            case 4: {
                return Material.ORANGE_CONCRETE;
            }
            case 5: {
                return Material.MAGENTA_CONCRETE;
            }
            case 6: {
                return Material.LIGHT_BLUE_CONCRETE;
            }
            case 7: {
                return Material.YELLOW_CONCRETE;
            }
            case 8: {
                return Material.LIME_CONCRETE;
            }
            case 9: {
                return Material.PINK_CONCRETE;
            }
            case 10: {
                return Material.GRAY_CONCRETE;
            }
            case 11: {
                return Material.LIGHT_GRAY_CONCRETE;
            }
            case 12: {
                return Material.CYAN_CONCRETE;
            }
            case 13: {
                return Material.PURPLE_CONCRETE;
            }
            case 14: {
                return Material.BLUE_CONCRETE;
            }
            case 15: {
                return Material.BROWN_CONCRETE;
            }
        }
        return Material.WHITE_CONCRETE;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (!title.equals(String.valueOf(ChatColor.GOLD) + "\u9009\u62e9\u8981\u51fa\u7684\u724c") && !title.equals(String.valueOf(ChatColor.GOLD) + "\u53eb\u5206\u9009\u62e9(\u70b9\u51fb'1'\u6216'2'\u53ef\u67e5\u770b\u624b\u724c\u548c\u5730\u4e3b\u724c)")) {
            return;
        }
        if (event.getClickedInventory() != event.getView().getTopInventory()) {
            event.setCancelled(true);
            return;
        }
        event.setCancelled(true);
        if (this.gameRoom.isAutoPlay(player)) {
            event.setCancelled(true);
            return;
        }
        if (!this.openInventories.containsKey(player)) {
            return;
        }
        event.setCancelled(true);
        if (event.getClickedInventory() == null) {
            return;
        }
        if (event.getClickedInventory().getHolder() != null && !(event.getClickedInventory().getHolder() instanceof Player)) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        title = ChatColor.stripColor((String)event.getView().getTitle());
        if (title.equals("\u53eb\u5206\u9009\u62e9(\u70b9\u51fb'1'\u6216'2'\u53ef\u67e5\u770b\u624b\u724c\u548c\u5730\u4e3b\u724c)")) {
            switch (event.getSlot()) {
                case 3: {
                    this.gameRoom.handleBiddingCommand(player, "\u4e0d\u53eb");
                    player.closeInventory();
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    if (clickedItem.getType() == Material.GRAY_WOOL) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u53eb\u5206\u5fc5\u987b\u9ad8\u4e8e\u5f53\u524d\u6700\u9ad8\u5206\uff01");
                        return;
                    }
                    String bidCommand = "";
                    switch (event.getSlot()) {
                        case 4: {
                            bidCommand = "1\u5206";
                            break;
                        }
                        case 5: {
                            bidCommand = "2\u5206";
                            break;
                        }
                        case 6: {
                            bidCommand = "3\u5206";
                        }
                    }
                    this.gameRoom.handleBiddingCommand(player, bidCommand);
                    player.closeInventory();
                }
            }
        } else if (title.equals("\u9009\u62e9\u8981\u51fa\u7684\u724c")) {
            if (!player.equals((Object)this.gameRoom.getCurrentPlayer())) {
                event.setCancelled(true);
                player.sendMessage(String.valueOf(ChatColor.RED) + "\u8fd8\u6ca1\u8f6e\u5230\u4f60\uff01");
                return;
            }
            List<Card> cards = this.gameRoom.getPlayerCards(player);
            if (cards == null) {
                player.closeInventory();
                return;
            }
            Inventory inv = this.openInventories.get(player);
            int slot = event.getSlot();
            List<Integer> selected = this.selectedSlots.get(player);
            int totalRows = inv.getSize() / 9;
            int buttonRow = (totalRows - 2) * 9;
            int infoRow = (totalRows - 1) * 9;
            if (slot < cards.size()) {
                this.toggleCardSelection(player, inv, cards, selected, slot);
            } else if (slot >= buttonRow && slot < infoRow) {
                this.handleButtonClick(player, clickedItem);
            }
        }
    }

    private void toggleCardSelection(Player player, Inventory inv, List<Card> cards, List<Integer> selected, int slot) {
        if (selected.contains(slot)) {
            selected.remove((Object)slot);
            inv.setItem(slot, this.createCardItem(cards.get(slot), false));
        } else {
            selected.add(slot);
            inv.setItem(slot, this.createCardItem(cards.get(slot), true));
        }
        this.updateSelectionValidity(player, selected);
    }

    private void handleButtonClick(Player player, ItemStack clickedItem) {
        if (clickedItem == null) {
            return;
        }
        if (!player.equals((Object)this.gameRoom.getCurrentPlayer())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u8fd8\u6ca1\u8f6e\u5230\u4f60\uff01");
            player.closeInventory();
            return;
        }
        List<Integer> selected = this.selectedSlots.get(player);
        switch (clickedItem.getType()) {
            case LIME_WOOL: {
                this.handleConfirm(player, selected);
                break;
            }
            case RED_WOOL: {
                this.clearSelection(player, selected);
                break;
            }
            case YELLOW_WOOL: {
                if (this.gameRoom.getLastPlayedCards().isEmpty() && this.gameRoom.getPassCount() == 0) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "\u7b2c\u4e00\u8f6e\u5fc5\u987b\u51fa\u724c\uff0c\u4e0d\u80fd\u76f4\u63a5\u8fc7\u724c\uff01");
                    return;
                }
                this.intentionallyClosing.add(player);
                this.gameRoom.passCard(player);
                player.closeInventory();
                break;
            }
            case GRAY_WOOL: {
                if (clickedItem.getItemMeta().getDisplayName().contains("\u4e0d\u80fd\u8fc7\u724c")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "\u7b2c\u4e00\u8f6e\u5fc5\u987b\u51fa\u724c\uff01");
                    break;
                }
                if (!clickedItem.getItemMeta().getDisplayName().contains("\u8bf7\u9009\u62e9\u724c")) break;
                player.sendMessage(String.valueOf(ChatColor.RED) + "\u8bf7\u5148\u9009\u62e9\u8981\u51fa\u7684\u724c\uff01");
                break;
            }
            case BLUE_WOOL: {
                this.gameRoom.toggleAutoPlay(player);
                player.closeInventory();
            }
        }
    }

    private void handleConfirm(Player player, List<Integer> selected) {
        GameLogic.CardPattern lastPattern;
        GameLogic.CardPattern currentPattern;
        if (selected.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u8bf7\u5148\u9009\u62e9\u8981\u51fa\u7684\u724c\uff01");
            return;
        }
        List<Card> cards = this.gameRoom.getPlayerCards(player);
        ArrayList<Card> selectedCards = new ArrayList<Card>();
        ArrayList<Integer> selectedIndices = new ArrayList<Integer>(selected);
        selectedIndices.sort(Collections.reverseOrder());
        Iterator iterator = selectedIndices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            if (index >= cards.size()) continue;
            selectedCards.add(cards.get(index));
        }
        if (!this.gameRoom.getLastPlayedCards().isEmpty() && !(currentPattern = GameLogic.recognizePattern(selectedCards)).canBeat(lastPattern = GameLogic.recognizePattern(this.gameRoom.getLastPlayedCards()))) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u65e0\u6cd5\u538b\u8fc7\u4e0a\u5bb6\u7684\u724c\uff01\u8bf7\u91cd\u65b0\u9009\u62e9");
            return;
        }
        this.intentionallyClosing.add(player);
        player.closeInventory();
        this.gameRoom.playSelectedCards(player, selectedCards, selectedIndices);
    }

    private void clearSelection(Player player, List<Integer> selected) {
        if (selected.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u5f53\u524d\u6ca1\u6709\u9009\u4e2d\u7684\u724c");
            return;
        }
        Inventory inv = this.openInventories.get(player);
        List<Card> cards = this.gameRoom.getPlayerCards(player);
        for (int slot : selected) {
            if (slot >= cards.size()) continue;
            inv.setItem(slot, this.createCardItem(cards.get(slot), false));
        }
        selected.clear();
        this.updateSelectionValidity(player, selected);
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u5df2\u6e05\u7a7a\u6240\u6709\u9009\u62e9");
    }

    public void openBiddingGUI(Player player) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)9, (String)(String.valueOf(ChatColor.GOLD) + "\u53eb\u5206\u9009\u62e9(\u70b9\u51fb'1'\u6216'2'\u53ef\u67e5\u770b\u624b\u724c\u548c\u5730\u4e3b\u724c)"));
        int currentBid = this.gameRoom.getCurrentBidScore();
        List<Card> playerCards = this.gameRoom.getPlayerCards(player);
        List<Card> landlordCards = this.gameRoom.getLandlordCards();
        ItemStack handInfo = this.createInfoItem(String.valueOf(ChatColor.GREEN) + "\u624b\u724c", playerCards.size() + "\u5f20", Material.BOOK);
        ItemMeta handMeta = handInfo.getItemMeta();
        ArrayList<CallSite> handLore = new ArrayList<CallSite>();
        handLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "\u4f60\u7684\u624b\u724c\u8be6\u60c5:")));
        for (Card card : playerCards) {
            handLore.add((CallSite)((Object)(String.valueOf(ChatColor.WHITE) + " - " + card.toString())));
        }
        handMeta.setLore(handLore);
        handInfo.setItemMeta(handMeta);
        inv.setItem(0, handInfo);
        ItemStack landlordInfo = this.createInfoItem(String.valueOf(ChatColor.GOLD) + "\u5730\u4e3b\u724c", "3\u5f20", Material.GOLD_NUGGET);
        ItemMeta landlordMeta = landlordInfo.getItemMeta();
        ArrayList<CallSite> landlordLore = new ArrayList<CallSite>();
        landlordLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "\u5730\u4e3b\u724c\u8be6\u60c5:")));
        for (Card card : landlordCards) {
            landlordLore.add((CallSite)((Object)(String.valueOf(ChatColor.WHITE) + " - " + card.toString())));
        }
        landlordMeta.setLore(landlordLore);
        landlordInfo.setItemMeta(landlordMeta);
        inv.setItem(1, landlordInfo);
        inv.setItem(2, this.createSeparator());
        inv.setItem(3, this.createButton(Material.RED_WOOL, String.valueOf(ChatColor.RED) + "\u4e0d\u53eb", Collections.singletonList(String.valueOf(ChatColor.GRAY) + "\u70b9\u51fb\u9009\u62e9\u4e0d\u53eb")));
        inv.setItem(4, this.createButton(currentBid < 1 ? Material.GREEN_WOOL : Material.GRAY_WOOL, currentBid < 1 ? String.valueOf(ChatColor.GREEN) + "1\u5206" : String.valueOf(ChatColor.GRAY) + "1\u5206(\u4e0d\u53ef\u9009)", Collections.singletonList(currentBid < 1 ? String.valueOf(ChatColor.GRAY) + "\u70b9\u51fb\u53eb1\u5206" : String.valueOf(ChatColor.RED) + "\u5fc5\u987b\u9ad8\u4e8e\u5f53\u524d\u53eb\u5206")));
        inv.setItem(5, this.createButton(currentBid < 2 ? Material.YELLOW_WOOL : Material.GRAY_WOOL, currentBid < 2 ? String.valueOf(ChatColor.YELLOW) + "2\u5206" : String.valueOf(ChatColor.GRAY) + "2\u5206(\u4e0d\u53ef\u9009)", Collections.singletonList(currentBid < 2 ? String.valueOf(ChatColor.GRAY) + "\u70b9\u51fb\u53eb2\u5206" : String.valueOf(ChatColor.RED) + "\u5fc5\u987b\u9ad8\u4e8e\u5f53\u524d\u53eb\u5206")));
        inv.setItem(6, this.createButton(currentBid < 3 ? Material.BLUE_WOOL : Material.GRAY_WOOL, currentBid < 3 ? String.valueOf(ChatColor.BLUE) + "3\u5206" : String.valueOf(ChatColor.GRAY) + "3\u5206(\u4e0d\u53ef\u9009)", Collections.singletonList(currentBid < 3 ? String.valueOf(ChatColor.GRAY) + "\u70b9\u51fb\u53eb3\u5206" : String.valueOf(ChatColor.RED) + "\u5fc5\u987b\u9ad8\u4e8e\u5f53\u524d\u53eb\u5206")));
        inv.setItem(7, this.createSeparator());
        inv.setItem(8, this.createInfoItem("\u5f53\u524d\u6700\u9ad8\u5206", currentBid + "\u5206 (" + (this.gameRoom.getCurrentHighestBidder() != null ? this.gameRoom.getCurrentHighestBidder().getName() : "\u65e0\u4eba") + ")", Material.GOLD_INGOT));
        player.openInventory(inv);
        this.openInventories.put(player, inv);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.reopeningPlayers.contains(playerId)) {
            this.reopeningPlayers.remove(playerId);
            return;
        }
        if (this.intentionallyClosing.remove(player)) {
            this.openInventories.remove(player);
            this.selectedSlots.remove(player);
            return;
        }
        if (this.gameRoom.getGameState() == GameRoom.GameState.FINISHED || this.gameRoom.isAutoPlay(player) || !player.equals((Object)this.gameRoom.getCurrentPlayer())) {
            this.openInventories.remove(player);
            this.selectedSlots.remove(player);
            return;
        }
        List<Card> cards = this.gameRoom.getPlayerCards(player);
        if (cards == null || cards.isEmpty()) {
            this.openInventories.remove(player);
            this.selectedSlots.remove(player);
            return;
        }
        this.openInventories.remove(player);
        this.selectedSlots.remove(player);
        if (this.gameRoom.isAutoPlay(player)) {
            return;
        }
        this.reopeningPlayers.add(playerId);
        Runnable reopenTask = () -> {
            this.reopeningPlayers.remove(playerId);
            if (player.isOnline() && this.gameRoom.getPlayerCards(player) != null && !this.gameRoom.getPlayerCards(player).isEmpty() && player.equals((Object)this.gameRoom.getCurrentPlayer()) && !this.intentionallyClosing.contains(player) && !this.gameRoom.isAutoPlay(player)) {
                this.openGUI(player, this.gameRoom.getPlayerCards(player));
            }
        };
        if (this.plugin.isFolia()) {
            player.getScheduler().runDelayed((Plugin)this.plugin, task -> reopenTask.run(), null, 2L);
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, reopenTask, 2L);
        }
    }
}

