/*
 * Decompiled with CFR 0.152.
 */
package cn.kurt6.landlord;

import cn.kurt6.landlord.Card;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class GameLogic {
    public static CardPattern recognizePattern(List<Card> cards) {
        if (cards == null || cards.isEmpty()) {
            return new CardPattern(CardType.INVALID, 0, cards, 0);
        }
        TreeMap<Integer, Integer> valueCount = new TreeMap<Integer, Integer>(Comparator.reverseOrder());
        for (Card card : cards) {
            int value = card.getValue();
            if (value < 3 || value > 17) {
                return new CardPattern(CardType.INVALID, 0, cards, 0);
            }
            valueCount.put(value, valueCount.getOrDefault(value, 0) + 1);
        }
        int size = cards.size();
        ArrayList counts = new ArrayList(valueCount.values());
        counts.sort(Collections.reverseOrder());
        if (GameLogic.isRocket(valueCount)) {
            return new CardPattern(CardType.ROCKET, 17, cards, 0);
        }
        CardPattern bombPattern = GameLogic.checkBomb(valueCount, size, cards);
        if (bombPattern != null) {
            return bombPattern;
        }
        CardPattern basicPattern = GameLogic.checkBasicPatterns(valueCount, size, cards);
        if (basicPattern != null) {
            return basicPattern;
        }
        CardPattern triplePattern = GameLogic.checkTriplePatterns(valueCount, size, cards);
        if (triplePattern != null) {
            return triplePattern;
        }
        CardPattern fourWithPattern = GameLogic.checkFourWithPatterns(valueCount, size, cards);
        if (fourWithPattern != null) {
            return fourWithPattern;
        }
        CardPattern straightPattern = GameLogic.checkStraightPatterns(valueCount, size, cards);
        if (straightPattern != null) {
            return straightPattern;
        }
        return new CardPattern(CardType.INVALID, 0, cards, 0);
    }

    private static boolean isRocket(Map<Integer, Integer> valueCount) {
        return valueCount.size() == 2 && valueCount.containsKey(16) && valueCount.containsKey(17) && valueCount.get(16) == 1 && valueCount.get(17) == 1;
    }

    private static CardPattern checkBomb(Map<Integer, Integer> valueCount, int size, List<Card> cards) {
        int value;
        int count;
        if (size == 4 && valueCount.size() == 1 && (count = valueCount.get(value = valueCount.keySet().iterator().next().intValue()).intValue()) == 4 && value >= 3 && value <= 15) {
            return new CardPattern(CardType.BOMB, value, cards, 0);
        }
        return null;
    }

    private static CardPattern checkBasicPatterns(Map<Integer, Integer> valueCount, int size, List<Card> cards) {
        if (valueCount.size() == 1) {
            int value = valueCount.keySet().iterator().next();
            int count = valueCount.get(value);
            switch (size) {
                case 1: {
                    if (count != 1 || value < 3 || value > 17) break;
                    return new CardPattern(CardType.SINGLE, value, cards, 0);
                }
                case 2: {
                    if (count != 2 || value < 3 || value > 15) break;
                    return new CardPattern(CardType.PAIR, value, cards, 0);
                }
                case 3: {
                    if (count != 3 || value < 3 || value > 15) break;
                    return new CardPattern(CardType.TRIPLE, value, cards, 0);
                }
            }
        }
        return null;
    }

    private static CardPattern checkTriplePatterns(Map<Integer, Integer> valueCount, int size, List<Card> cards) {
        long pairCount;
        List tripleValues = valueCount.entrySet().stream().filter(e -> (Integer)e.getValue() == 3).map(Map.Entry::getKey).collect(Collectors.toList());
        if (tripleValues.size() != 1) {
            return null;
        }
        int mainValue = (Integer)tripleValues.get(0);
        if (mainValue >= 16) {
            return null;
        }
        if (size == 4) {
            long singleCount = valueCount.entrySet().stream().filter(e -> (Integer)e.getKey() != mainValue).filter(e -> (Integer)e.getValue() == 1).count();
            if (singleCount == 1L && valueCount.size() == 2) {
                return new CardPattern(CardType.TRIPLE_SINGLE, mainValue, cards, 0);
            }
        } else if (size == 5 && (pairCount = valueCount.entrySet().stream().filter(e -> (Integer)e.getKey() != mainValue).filter(e -> (Integer)e.getValue() == 2).count()) == 1L && valueCount.size() == 2) {
            return new CardPattern(CardType.TRIPLE_PAIR, mainValue, cards, 0);
        }
        return null;
    }

    private static CardPattern checkFourWithPatterns(Map<Integer, Integer> valueCount, int size, List<Card> cards) {
        boolean hasJokerPairs;
        long pairCount;
        List fourValues = valueCount.entrySet().stream().filter(e -> (Integer)e.getValue() == 4).map(Map.Entry::getKey).collect(Collectors.toList());
        if (fourValues.size() != 1) {
            return null;
        }
        int mainValue = (Integer)fourValues.get(0);
        if (mainValue >= 16) {
            return null;
        }
        if (size == 6) {
            long singleCount = valueCount.entrySet().stream().filter(e -> (Integer)e.getKey() != mainValue).filter(e -> (Integer)e.getValue() == 1).count();
            if (singleCount == 2L && valueCount.size() == 3) {
                boolean hasJokers;
                boolean bl = hasJokers = valueCount.containsKey(16) && valueCount.containsKey(17) && valueCount.get(16) == 1 && valueCount.get(17) == 1;
                if (!hasJokers) {
                    return new CardPattern(CardType.FOUR_WITH_TWO_SINGLES, mainValue, cards, 0);
                }
            }
        } else if (size == 8 && (pairCount = valueCount.entrySet().stream().filter(e -> (Integer)e.getKey() != mainValue).filter(e -> (Integer)e.getValue() == 2).count()) == 2L && valueCount.size() == 3 && !(hasJokerPairs = valueCount.entrySet().stream().filter(e -> (Integer)e.getKey() != mainValue).filter(e -> (Integer)e.getValue() == 2).anyMatch(e -> (Integer)e.getKey() >= 16))) {
            return new CardPattern(CardType.FOUR_WITH_TWO_PAIRS, mainValue, cards, 0);
        }
        return null;
    }

    private static CardPattern checkStraightPatterns(Map<Integer, Integer> valueCount, int size, List<Card> cards) {
        ArrayList<Integer> values = new ArrayList<Integer>(valueCount.keySet());
        values.sort(Collections.reverseOrder());
        if (GameLogic.containsInvalidStraightCards(values)) {
            return null;
        }
        if (size >= 5 && valueCount.values().stream().allMatch(c -> c == 1) && GameLogic.isConsecutive(values) && (Integer)values.get(0) <= 14) {
            return new CardPattern(CardType.STRAIGHT, (Integer)values.get(0), cards, size);
        }
        if (size >= 6 && size % 2 == 0 && valueCount.size() >= 3 && valueCount.values().stream().allMatch(c -> c == 2) && GameLogic.isConsecutive(values) && (Integer)values.get(0) <= 14) {
            return new CardPattern(CardType.PAIR_STRAIGHT, (Integer)values.get(0), cards, size / 2);
        }
        return GameLogic.checkAirplanePattern(valueCount, size, cards);
    }

    private static CardPattern checkAirplanePattern(Map<Integer, Integer> valueCount, int size, List<Card> cards) {
        int availablePairs;
        int availableSingles;
        List<Integer> tripleValues = valueCount.entrySet().stream().filter(e -> (Integer)e.getValue() >= 3).map(Map.Entry::getKey).filter(v -> v <= 14).sorted(Collections.reverseOrder()).collect(Collectors.toList());
        if (tripleValues.size() < 2) {
            return null;
        }
        List<Integer> longestSequence = GameLogic.findLongestConsecutiveSequence(tripleValues);
        if (longestSequence.size() < 2) {
            return null;
        }
        int airplaneCount = longestSequence.size();
        int airplaneCards = airplaneCount * 3;
        int extraCards = size - airplaneCards;
        HashMap<Integer, Integer> extraValueCount = new HashMap<Integer, Integer>(valueCount);
        for (int value : longestSequence) {
            extraValueCount.put(value, (Integer)extraValueCount.get(value) - 3);
            if ((Integer)extraValueCount.get(value) != 0) continue;
            extraValueCount.remove(value);
        }
        if (extraCards == 0) {
            return new CardPattern(CardType.TRIPLE_STRAIGHT, longestSequence.get(0), cards, airplaneCount);
        }
        if (extraCards == airplaneCount ? (availableSingles = (int)extraValueCount.values().stream().filter(count -> count >= 1).count()) >= airplaneCount : extraCards == airplaneCount * 2 && (availablePairs = (int)extraValueCount.values().stream().filter(count -> count >= 2).count()) >= airplaneCount) {
            return new CardPattern(CardType.TRIPLE_STRAIGHT, longestSequence.get(0), cards, airplaneCount);
        }
        return null;
    }

    private static List<Integer> findLongestConsecutiveSequence(List<Integer> values) {
        if (values.isEmpty()) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> longest = new ArrayList<Integer>();
        ArrayList<Integer> current = new ArrayList<Integer>();
        current.add(values.get(0));
        for (int i = 1; i < values.size(); ++i) {
            if (values.get(i) == values.get(i - 1) - 1) {
                current.add(values.get(i));
                continue;
            }
            if (current.size() > longest.size()) {
                longest = new ArrayList(current);
            }
            current.clear();
            current.add(values.get(i));
        }
        if (current.size() > longest.size()) {
            longest = new ArrayList(current);
        }
        return longest;
    }

    private static boolean isConsecutive(List<Integer> values) {
        if (values.size() < 2) {
            return false;
        }
        for (int i = 1; i < values.size(); ++i) {
            if (values.get(i - 1) - values.get(i) == 1) continue;
            return false;
        }
        return true;
    }

    private static boolean containsInvalidStraightCards(List<Integer> values) {
        return values.contains(15) || values.contains(16) || values.contains(17);
    }

    public static List<List<Card>> getPossiblePlays(List<Card> hand, CardPattern lastPattern) {
        ArrayList<List<Card>> possiblePlays = new ArrayList<List<Card>>();
        if (lastPattern == null) {
            possiblePlays.addAll(GameLogic.getAllValidPlays(hand));
        } else {
            possiblePlays.addAll(GameLogic.getBeatingPlays(hand, lastPattern));
        }
        return possiblePlays;
    }

    private static List<List<Card>> getAllValidPlays(List<Card> hand) {
        ArrayList<List<Card>> plays = new ArrayList<List<Card>>();
        HashSet<String> addedPlays = new HashSet<String>();
        for (int len = 1; len <= Math.min(hand.size(), 20); ++len) {
            GameLogic.generateCombinations(hand, len, 0, new ArrayList<Card>(), plays, addedPlays);
        }
        return plays;
    }

    private static List<List<Card>> getBeatingPlays(List<Card> hand, CardPattern target) {
        List rockets;
        ArrayList<List<Card>> beatingPlays = new ArrayList<List<Card>>();
        HashSet<String> addedPlays = new HashSet<String>();
        if (target.getType() != CardType.ROCKET && (rockets = hand.stream().filter(card -> card.getValue() == 16 || card.getValue() == 17).collect(Collectors.toList())).size() == 2) {
            beatingPlays.add(rockets);
            return beatingPlays;
        }
        if (target.getType() != CardType.BOMB && target.getType() != CardType.ROCKET) {
            Map<Integer, List<Card>> valueGroups = hand.stream().filter(card -> card.getValue() >= 3 && card.getValue() <= 15).collect(Collectors.groupingBy(Card::getValue));
            for (Map.Entry entry : valueGroups.entrySet()) {
                if (((List)entry.getValue()).size() != 4) continue;
                if (target.getType() == CardType.BOMB) {
                    if ((Integer)entry.getKey() <= target.getMainValue()) continue;
                    beatingPlays.add(new ArrayList((Collection)entry.getValue()));
                    continue;
                }
                beatingPlays.add(new ArrayList((Collection)entry.getValue()));
            }
        }
        List<List<Card>> allPlays = GameLogic.getAllValidPlays(hand);
        for (List<Card> list : allPlays) {
            String playKey;
            CardPattern pattern = GameLogic.recognizePattern(list);
            if (!GameLogic.isSameTypeAndCanBeat(pattern, target) || addedPlays.contains(playKey = GameLogic.getPlayKey(list))) continue;
            beatingPlays.add(list);
            addedPlays.add(playKey);
        }
        return beatingPlays;
    }

    private static boolean isSameTypeAndCanBeat(CardPattern pattern, CardPattern target) {
        if (pattern.getType() != target.getType() && pattern.getType() != CardType.BOMB && pattern.getType() != CardType.ROCKET) {
            return false;
        }
        switch (pattern.getType().ordinal()) {
            case 7: 
            case 8: 
            case 9: {
                return pattern.getLength() == target.getLength() && pattern.getMainValue() > target.getMainValue();
            }
            case 5: 
            case 6: {
                return pattern.getType() == target.getType() && pattern.getMainValue() > target.getMainValue();
            }
        }
        return pattern.getMainValue() > target.getMainValue();
    }

    private static void generateCombinations(List<Card> hand, int len, int start, List<Card> current, List<List<Card>> result, Set<String> addedPlays) {
        if (current.size() == len) {
            String playKey;
            CardPattern pattern = GameLogic.recognizePattern(current);
            if (pattern.getType() != CardType.INVALID && !addedPlays.contains(playKey = GameLogic.getPlayKey(current))) {
                result.add(new ArrayList<Card>(current));
                addedPlays.add(playKey);
            }
            return;
        }
        for (int i = start; i < hand.size(); ++i) {
            current.add(hand.get(i));
            GameLogic.generateCombinations(hand, len, i + 1, current, result, addedPlays);
            current.remove(current.size() - 1);
        }
    }

    private static String getPlayKey(List<Card> cards) {
        return cards.stream().map(card -> String.valueOf(card.getValue())).sorted().collect(Collectors.joining(","));
    }

    public static List<Card> autoSelectCards(List<Card> hand, CardPattern lastPattern) {
        List<List<Card>> possiblePlays = GameLogic.getPossiblePlays(hand, lastPattern);
        if (possiblePlays.isEmpty()) {
            return null;
        }
        for (List<Card> play : possiblePlays) {
            if (play.size() != hand.size()) continue;
            return play;
        }
        int remainingCards = hand.size();
        possiblePlays.sort((a, b) -> {
            int typesB;
            boolean isBombB;
            CardPattern patternA = GameLogic.recognizePattern(a);
            CardPattern patternB = GameLogic.recognizePattern(b);
            boolean isBombA = patternA.getType() == CardType.BOMB || patternA.getType() == CardType.ROCKET;
            boolean bl = isBombB = patternB.getType() == CardType.BOMB || patternB.getType() == CardType.ROCKET;
            if (isBombA && !isBombB) {
                return remainingCards > 8 ? 1 : -1;
            }
            if (!isBombA && isBombB) {
                return remainingCards > 8 ? -1 : 1;
            }
            int typesA = GameLogic.countRemainingCardTypes(hand, a);
            if (typesA != (typesB = GameLogic.countRemainingCardTypes(hand, b))) {
                return Integer.compare(typesA, typesB);
            }
            if (patternA.getType() == patternB.getType()) {
                return Integer.compare(patternB.getMainValue(), patternA.getMainValue());
            }
            return Integer.compare(GameLogic.getTypePriority(patternA.getType()), GameLogic.getTypePriority(patternB.getType()));
        });
        return possiblePlays.get(0);
    }

    private static int countRemainingCardTypes(List<Card> hand, List<Card> play) {
        ArrayList<Card> remaining = new ArrayList<Card>(hand);
        remaining.removeAll(play);
        return (int)remaining.stream().map(Card::getValue).distinct().count();
    }

    private static int getTypePriority(CardType type) {
        switch (type.ordinal()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 8;
            }
            case 5: {
                return 9;
            }
            case 6: {
                return 10;
            }
            case 10: {
                return 11;
            }
            case 11: {
                return 12;
            }
        }
        return 999;
    }

    public static class CardPattern {
        private final CardType type;
        private final int mainValue;
        private final List<Card> cards;
        private final int length;

        public CardPattern(CardType type, int mainValue, List<Card> cards, int length) {
            this.type = type;
            this.mainValue = mainValue;
            this.cards = new ArrayList<Card>(cards);
            this.length = length;
        }

        public CardType getType() {
            return this.type;
        }

        public int getMainValue() {
            return this.mainValue;
        }

        public List<Card> getCards() {
            return this.cards;
        }

        public int getLength() {
            return this.length;
        }

        public boolean canBeat(CardPattern other) {
            if (other == null) {
                return true;
            }
            if (this.type == CardType.ROCKET) {
                return true;
            }
            if (other.type == CardType.ROCKET) {
                return false;
            }
            if (this.type == CardType.BOMB && other.type != CardType.BOMB) {
                return true;
            }
            if (this.type != CardType.BOMB && other.type == CardType.BOMB) {
                return false;
            }
            if (this.type == CardType.BOMB && other.type == CardType.BOMB) {
                return this.mainValue > other.mainValue;
            }
            if (this.type == other.type) {
                if (this.type == CardType.STRAIGHT || this.type == CardType.PAIR_STRAIGHT || this.type == CardType.TRIPLE_STRAIGHT) {
                    return this.length == other.length && this.mainValue > other.mainValue;
                }
                if (this.type == CardType.FOUR_WITH_TWO_SINGLES && other.type == CardType.FOUR_WITH_TWO_SINGLES) {
                    return this.mainValue > other.mainValue;
                }
                if (this.type == CardType.FOUR_WITH_TWO_PAIRS && other.type == CardType.FOUR_WITH_TWO_PAIRS) {
                    return this.mainValue > other.mainValue;
                }
                return this.mainValue > other.mainValue;
            }
            return false;
        }
    }

    public static enum CardType {
        SINGLE,
        PAIR,
        TRIPLE,
        TRIPLE_SINGLE,
        TRIPLE_PAIR,
        FOUR_WITH_TWO_SINGLES,
        FOUR_WITH_TWO_PAIRS,
        STRAIGHT,
        PAIR_STRAIGHT,
        TRIPLE_STRAIGHT,
        BOMB,
        ROCKET,
        INVALID;

    }
}

