/*
 * Decompiled with CFR 0.152.
 */
package cn.kurt6.landlord;

import cn.kurt6.landlord.Card;
import cn.kurt6.landlord.CardSelectionGUI;
import cn.kurt6.landlord.GameLogic;
import cn.kurt6.landlord.Landlord;
import cn.kurt6.landlord.StatsManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public class GameRoom {
    private final String roomId;
    private final Landlord plugin;
    private final Map<UUID, Player> players = new ConcurrentHashMap<UUID, Player>();
    private final Map<UUID, Boolean> readyStatus = new ConcurrentHashMap<UUID, Boolean>();
    private final Map<UUID, List<Card>> playerCards = new ConcurrentHashMap<UUID, List<Card>>();
    private final Map<UUID, Boolean> autoPlay = new ConcurrentHashMap<UUID, Boolean>();
    private final Map<UUID, List<Integer>> selectedCards = new ConcurrentHashMap<UUID, List<Integer>>();
    private final Map<UUID, BaseComponent[]> lastHandMessages = new ConcurrentHashMap<UUID, BaseComponent[]>();
    private boolean moneyGame = false;
    private final CardSelectionGUI cardSelectionGUI;
    private static final int BIDDING_TIMEOUT = 30;
    private final Map<UUID, Integer> bidStatus = new ConcurrentHashMap<UUID, Integer>();
    private int currentBidScore = 0;
    private Player currentHighestBidder = null;
    private List<Player> biddingOrder = new ArrayList<Player>();
    private int biddingIndex = 0;
    private boolean biddingPhaseComplete = false;
    private BossBar scoreboardBossBar;
    private BossBar bossBar;
    private boolean gameStarted = false;
    private GameState gameState = GameState.WAITING;
    private Player roomOwner;
    private Player landlord;
    private List<Card> landlordCards = new ArrayList<Card>();
    private List<Card> lastPlayedCards = new ArrayList<Card>();
    private Player currentPlayer;
    private Player lastPlayer;
    private int passCount = 0;
    private int multiplier = 1;
    private Map<UUID, BukkitTask> playerTimers = new ConcurrentHashMap<UUID, BukkitTask>();
    private long lastScoreboardUpdate = 0L;

    private int getTurnTimeout() {
        return this.plugin.getTurnTimeout();
    }

    private void runTaskLater(final Runnable task, long delay) {
        try {
            if (this.plugin.isFolia()) {
                Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, t -> task.run(), delay);
            } else {
                new BukkitRunnable(){

                    public void run() {
                        task.run();
                    }
                }.runTaskLater((Plugin)this.plugin, delay);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u8c03\u5ea6\u4efb\u52a1\u65f6\u51fa\u73b0\u9519\u8bef: " + e.getMessage());
        }
    }

    public GameRoom(String roomId, Player owner, Landlord plugin) {
        this.roomId = roomId;
        this.roomOwner = owner;
        this.plugin = plugin;
        this.bossBar = Bukkit.createBossBar((String)("\u623f\u95f4 " + roomId + " - \u7b49\u5f85\u73a9\u5bb6\u52a0\u5165"), (BarColor)BarColor.BLUE, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        if (!plugin.isScoreboardEnabled() || plugin.isFolia()) {
            this.scoreboardBossBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.PURPLE, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        }
        this.cardSelectionGUI = new CardSelectionGUI(plugin, this);
    }

    public void addPlayer(Player player) {
        if (this.moneyGame && this.plugin.isBountyEnabled()) {
            double required = this.plugin.getMoneyMultiplier();
            double playerBalance = this.plugin.getPlayerBalance(player);
            if (playerBalance < required) {
                player.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u52a0\u5165\u5931\u8d25\uff01\u91d1\u5e01\u8d5b\u9700\u8981\u81f3\u5c11 " + required + " \u91d1\u5e01\uff0c\u4f60\u5f53\u524d\u53ea\u6709 " + playerBalance + " \u91d1\u5e01");
                return;
            }
        }
        this.players.put(player.getUniqueId(), player);
        this.readyStatus.put(player.getUniqueId(), false);
        this.autoPlay.put(player.getUniqueId(), false);
        this.selectedCards.put(player.getUniqueId(), new ArrayList());
        this.bidStatus.put(player.getUniqueId(), 0);
        this.bossBar.addPlayer(player);
        if (this.scoreboardBossBar != null) {
            this.scoreboardBossBar.addPlayer(player);
        }
        this.updateBossBar();
        this.updateScoreboard();
        this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.GREEN) + player.getName() + " \u52a0\u5165\u4e86\u623f\u95f4\uff01");
        this.sendGameButtons(player);
        if (this.players.size() == 3) {
            this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u623f\u95f4\u5df2\u6ee1\uff01\u6240\u6709\u73a9\u5bb6\u51c6\u5907\u540e\u5373\u53ef\u5f00\u59cb\u6e38\u620f\uff01");
        }
    }

    public void removePlayer(Player player) {
        if (this.isGameStarted() && player.isOnline()) {
            player.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u6e38\u620f\u8fdb\u884c\u4e2d\uff0c\u65e0\u6cd5\u4e3b\u52a8\u79bb\u5f00\u623f\u95f4\uff01");
            return;
        }
        this.lastHandMessages.remove(player.getUniqueId());
        this.bossBar.removePlayer(player);
        if (this.scoreboardBossBar != null) {
            this.scoreboardBossBar.removePlayer(player);
        }
        try {
            Scoreboard emptyScoreboard;
            ScoreboardManager manager = Bukkit.getScoreboardManager();
            if (manager != null && (emptyScoreboard = manager.getNewScoreboard()) != null) {
                player.setScoreboard(emptyScoreboard);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isGameStarted()) {
            this.autoPlay.put(player.getUniqueId(), true);
            this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.RED) + player.getName() + " \u6389\u7ebf\u4e86\uff0c\u5df2\u81ea\u52a8\u6258\u7ba1\uff01");
            if (player.equals((Object)this.currentPlayer)) {
                this.runTaskLater(() -> {
                    if (this.gameState == GameState.BIDDING) {
                        this.handleBiddingCommand(player, "\u4e0d\u53eb");
                    } else if (this.gameState == GameState.PLAYING) {
                        this.autoPlayCards(player);
                    }
                }, 5L);
            } else if (this.gameState == GameState.BIDDING) {
                this.runTaskLater(() -> {
                    if (this.gameState == GameState.BIDDING && player.equals((Object)this.currentPlayer)) {
                        this.handleBiddingCommand(player, "\u4e0d\u53eb");
                    }
                }, 5L);
            }
        } else {
            this.players.remove(player.getUniqueId());
            this.readyStatus.remove(player.getUniqueId());
            this.playerCards.remove(player.getUniqueId());
            this.autoPlay.remove(player.getUniqueId());
            this.selectedCards.remove(player.getUniqueId());
            this.bidStatus.remove(player.getUniqueId());
            if (player.equals((Object)this.roomOwner) && !this.players.isEmpty()) {
                this.roomOwner = this.players.values().iterator().next();
                this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.YELLOW) + this.roomOwner.getName() + " \u6210\u4e3a\u4e86\u65b0\u623f\u4e3b\uff01");
            }
            this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.RED) + player.getName() + " \u79bb\u5f00\u4e86\u623f\u95f4\uff01");
        }
        this.updateBossBar();
        this.updateScoreboard();
    }

    public void toggleReady(Player player) {
        if (this.gameStarted) {
            player.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u6e38\u620f\u5df2\u5f00\u59cb\uff0c\u65e0\u6cd5\u5207\u6362\u51c6\u5907\u72b6\u6001\uff01");
            return;
        }
        if (!this.readyStatus.containsKey(player.getUniqueId())) {
            this.readyStatus.put(player.getUniqueId(), false);
        }
        if (this.moneyGame && this.plugin.isBountyEnabled()) {
            double required = this.plugin.getMoneyMultiplier();
            double playerBalance = this.plugin.getPlayerBalance(player);
            if (playerBalance < required) {
                player.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u51c6\u5907\u5931\u8d25\uff01\u91d1\u5e01\u8d5b\u9700\u8981\u81f3\u5c11 " + required + " \u91d1\u5e01\uff0c\u4f60\u5f53\u524d\u53ea\u6709 " + playerBalance + " \u91d1\u5e01");
                return;
            }
        }
        boolean ready = this.readyStatus.get(player.getUniqueId()) == false;
        this.readyStatus.put(player.getUniqueId(), ready);
        String status = ready ? String.valueOf(org.bukkit.ChatColor.GREEN) + "\u5df2\u51c6\u5907" : String.valueOf(org.bukkit.ChatColor.RED) + "\u672a\u51c6\u5907";
        this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.YELLOW) + player.getName() + " " + status);
        this.updateBossBar();
        this.updateScoreboard();
        if (this.players.size() == 3 && this.readyStatus.values().stream().allMatch(r -> r)) {
            this.startGame();
        }
    }

    private void startGame() {
        if (this.moneyGame && this.plugin.isBountyEnabled()) {
            double required = this.plugin.getMoneyMultiplier();
            for (Player p : this.players.values()) {
                double playerBalance = this.plugin.getPlayerBalance(p);
                if (!(playerBalance < required)) continue;
                p.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u6e38\u620f\u65e0\u6cd5\u5f00\u59cb\uff01\u73a9\u5bb6 " + p.getName() + " \u91d1\u5e01\u4e0d\u8db3 (\u9700\u8981: " + required + ", \u5f53\u524d: " + playerBalance + ")");
                return;
            }
        }
        this.gameStarted = true;
        this.gameState = GameState.BIDDING;
        this.multiplier = 1;
        this.currentBidScore = 0;
        this.currentHighestBidder = null;
        this.biddingPhaseComplete = false;
        this.biddingIndex = 0;
        for (UUID playerId : this.players.keySet()) {
            this.bidStatus.put(playerId, 0);
        }
        this.dealCards();
        this.biddingOrder = new ArrayList<Player>(this.players.values());
        Collections.shuffle(this.biddingOrder);
        this.updateBossBar();
        this.updateScoreboard();
        for (Player p : this.players.values()) {
            p.spigot().sendMessage((BaseComponent)new TextComponent(" "));
        }
        this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.GOLD) + "\u6e38\u620f\u5f00\u59cb\uff01\u8fdb\u5165\u53eb\u5206\u9636\u6bb5\uff01");
        this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u53eb\u5206\u89c4\u5219\uff1a\u53ef\u4ee5\u53eb1\u5206\u30012\u5206\u30013\u5206\u6216\u4e0d\u53eb\uff0c\u540e\u53eb\u5206\u8005\u5fc5\u987b\u6bd4\u524d\u9762\u7684\u5206\u6570\u9ad8");
        this.showLandlordCardsPreview();
        for (Player player : this.players.values()) {
            this.showPlayerCards(player, false);
        }
        this.startBidding();
    }

    private void startBidding() {
        this.currentBidScore = 0;
        this.currentHighestBidder = null;
        this.biddingPhaseComplete = false;
        this.biddingOrder = new ArrayList<Player>(this.players.values());
        Collections.shuffle(this.biddingOrder);
        this.biddingIndex = 0;
        this.nextBiddingPlayer();
    }

    private void dealCards() {
        int i;
        List<Card> deck = this.createDeck();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (i = 0; i < 3; ++i) {
            Collections.shuffle(deck, random);
        }
        this.landlordCards.clear();
        for (i = 0; i < 3; ++i) {
            int randomIndex = ((Random)random).nextInt(deck.size());
            this.landlordCards.add(deck.remove(randomIndex));
        }
        for (Player player : this.players.values()) {
            ArrayList<Card> cards = new ArrayList<Card>();
            for (int j = 0; j < 17; ++j) {
                int randomIndex = ((Random)random).nextInt(deck.size());
                cards.add(deck.remove(randomIndex));
            }
            cards.sort((a, b) -> Integer.compare(b.getValue(), a.getValue()));
            this.playerCards.put(player.getUniqueId(), cards);
        }
    }

    private List<Card> createDeck() {
        String[] suits;
        ArrayList<Card> deck = new ArrayList<Card>();
        for (String suit : suits = new String[]{"\u2660", "\u2665", "\u2663", "\u2666"}) {
            for (int value = 3; value <= 14; ++value) {
                deck.add(new Card(suit, value));
            }
            deck.add(new Card(suit, 15));
        }
        deck.add(new Card("", 16));
        deck.add(new Card("", 17));
        return deck;
    }

    public void handleGameCommand(Player player, String command) {
        if (!this.gameStarted || !this.players.containsKey(player.getUniqueId())) {
            return;
        }
        switch (this.gameState.ordinal()) {
            case 1: {
                this.handleBiddingCommand(player, command);
                break;
            }
            case 2: {
                this.handlePlayingCommand(player, command);
            }
        }
    }

    public void handleActionCommand(Player player, String action) {
        block25: {
            if (!this.players.containsKey(player.getUniqueId())) {
                return;
            }
            block0 : switch (this.gameState.ordinal()) {
                case 1: {
                    if (action.equals("bid_0")) {
                        this.handleBiddingCommand(player, "\u4e0d\u53eb");
                        break;
                    }
                    if (action.equals("bid_1")) {
                        this.handleBiddingCommand(player, "1\u5206");
                        break;
                    }
                    if (action.equals("bid_2")) {
                        this.handleBiddingCommand(player, "2\u5206");
                        break;
                    }
                    if (!action.equals("bid_3")) break;
                    this.handleBiddingCommand(player, "3\u5206");
                    break;
                }
                case 2: {
                    switch (action) {
                        case "select": {
                            if (player.equals((Object)this.currentPlayer)) {
                                player.sendMessage(String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u8bf7\u70b9\u51fb\u624b\u724c\u9009\u62e9\u8981\u51fa\u7684\u724c\uff01");
                                this.showPlayerCards(player, true);
                                break block0;
                            }
                            player.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u8fd8\u6ca1\u8f6e\u5230\u4f60\u51fa\u724c\uff01");
                            break block0;
                        }
                        case "skip": {
                            this.handlePlayingCommand(player, "\u8fc7");
                            break block0;
                        }
                        case "auto": {
                            boolean current = this.autoPlay.get(player.getUniqueId());
                            this.autoPlay.put(player.getUniqueId(), !current);
                            player.sendMessage(!current ? String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u5df2\u5f00\u542f\u6258\u7ba1\uff0c\u7cfb\u7edf\u5c06\u81ea\u52a8\u51fa\u724c" : String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u5df2\u53d6\u6d88\u6258\u7ba1");
                            if (!current) {
                                TextComponent message = new TextComponent(String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u53ef\u8f93\u5165/landlord_action auto \u53d6\u6d88\u6258\u7ba1");
                                TextComponent cancelButton = new TextComponent(String.valueOf(org.bukkit.ChatColor.RED) + "\u3010\u70b9\u51fb\u53d6\u6d88\u6258\u7ba1\u3011");
                                cancelButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/landlord_action auto"));
                                cancelButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u70b9\u51fb\u53d6\u6d88\u6258\u7ba1\u6a21\u5f0f").create()));
                                player.spigot().sendMessage(new BaseComponent[]{message, cancelButton});
                            }
                            if (current && player.equals((Object)this.currentPlayer)) {
                                this.showPlayerCards(player, true);
                                break block0;
                            }
                            break block25;
                        }
                        case "confirm": {
                            this.confirmSelectedCards(player);
                            break block0;
                        }
                        case "clear": {
                            this.selectedCards.get(player.getUniqueId()).clear();
                            player.sendMessage(String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u5df2\u6e05\u7a7a\u9009\u62e9");
                            this.showPlayerCards(player, true);
                        }
                    }
                }
            }
        }
    }

    private void confirmSelectedCards(Player player) {
        GameLogic.CardPattern lastPattern;
        if (!player.equals((Object)this.currentPlayer)) {
            player.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u8fd8\u6ca1\u8f6e\u5230\u4f60\u51fa\u724c\uff01");
            return;
        }
        List<Integer> selected = this.selectedCards.get(player.getUniqueId());
        if (selected.isEmpty()) {
            player.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u8bf7\u5148\u9009\u62e9\u8981\u51fa\u7684\u724c\uff01");
            return;
        }
        List<Card> cards = this.playerCards.get(player.getUniqueId());
        ArrayList<Card> selectedCardsList = new ArrayList<Card>();
        selected.sort(Collections.reverseOrder());
        for (int index : selected) {
            selectedCardsList.add(cards.get(index));
        }
        GameLogic.CardPattern pattern = GameLogic.recognizePattern(selectedCardsList);
        if (pattern.getType() == GameLogic.CardType.INVALID) {
            player.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u65e0\u6548\u7684\u724c\u578b\uff01\u8bf7\u91cd\u65b0\u9009\u62e9");
            return;
        }
        if (!this.lastPlayedCards.isEmpty() && !pattern.canBeat(lastPattern = GameLogic.recognizePattern(this.lastPlayedCards))) {
            player.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u65e0\u6cd5\u538b\u8fc7\u4e0a\u5bb6\u7684\u724c\uff01\u8bf7\u91cd\u65b0\u9009\u62e9\u6216\u9009\u62e9\u8fc7\u724c");
            return;
        }
        this.playSelectedCards(player, selectedCardsList, selected);
    }

    public void handleBiddingCommand(Player player, String command) {
        if (!player.equals((Object)this.currentPlayer)) {
            return;
        }
        this.cancelCurrentTimer();
        int bidScore = 0;
        if (command.equals("1\u5206")) {
            bidScore = 1;
        } else if (command.equals("2\u5206")) {
            bidScore = 2;
        } else if (command.equals("3\u5206")) {
            bidScore = 3;
        } else if (command.equals("\u4e0d\u53eb")) {
            bidScore = 0;
        }
        if (bidScore > 0) {
            if (bidScore <= this.currentBidScore) {
                if (player.isOnline()) {
                    player.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u53eb\u5206\u5fc5\u987b\u6bd4\u5f53\u524d\u6700\u9ad8\u5206(" + this.currentBidScore + "\u5206)\u66f4\u9ad8\uff01");
                    this.cardSelectionGUI.openBiddingGUI(player);
                }
                this.startBiddingTimer(player);
                return;
            }
            this.currentBidScore = bidScore;
            this.currentHighestBidder = player;
            this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.GREEN) + player.getName() + " \u53eb\u4e86 " + bidScore + " \u5206\uff01");
            if (bidScore == 3) {
                this.confirmLandlord(player, bidScore);
                return;
            }
        } else {
            this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.GRAY) + player.getName() + " \u4e0d\u53eb");
        }
        this.bidStatus.put(player.getUniqueId(), bidScore);
        this.nextBiddingPlayer();
    }

    private void nextBiddingPlayer() {
        this.cancelCurrentTimer();
        if (this.biddingIndex >= this.biddingOrder.size()) {
            if (this.currentHighestBidder == null) {
                this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.RED) + "\u65e0\u4eba\u53eb\u5206\uff0c\u91cd\u65b0\u53d1\u724c\uff01");
                this.resetGame();
                this.startGame();
                return;
            }
            this.confirmLandlord(this.currentHighestBidder, this.currentBidScore);
            return;
        }
        this.currentPlayer = this.biddingOrder.get(this.biddingIndex);
        ++this.biddingIndex;
        if (!this.currentPlayer.isOnline()) {
            this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.RED) + this.currentPlayer.getName() + " \u5df2\u79bb\u7ebf\uff0c\u81ea\u52a8\u8df3\u8fc7\u53eb\u5206");
            this.handleBiddingCommand(this.currentPlayer, "\u4e0d\u53eb");
            return;
        }
        this.updateBossBar();
        this.updateScoreboard();
        this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u8bf7 " + this.currentPlayer.getName() + " \u5728 30 \u79d2\u5185\u53eb\u5206\uff01");
        this.cardSelectionGUI.openBiddingGUI(this.currentPlayer);
        this.startBiddingTimer(this.currentPlayer);
    }

    private void startBiddingTimer(final Player player) {
        this.cancelCurrentTimer();
        final AtomicInteger secondsLeft = new AtomicInteger(30);
        if (this.plugin.isFolia()) {
            player.getScheduler().runAtFixedRate((Plugin)this.plugin, task -> this.handleBiddingTimerTick(player, secondsLeft), null, 20L, 20L);
        } else {
            BukkitTask task2 = new BukkitRunnable(){

                public void run() {
                    GameRoom.this.handleBiddingTimerTick(player, secondsLeft);
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
            this.playerTimers.put(player.getUniqueId(), task2);
        }
    }

    private void handleBiddingTimerTick(Player player, AtomicInteger secondsLeft) {
        if (this.gameState != GameState.BIDDING || !this.gameStarted) {
            return;
        }
        if (!player.isOnline() || this.currentPlayer == null || !this.currentPlayer.equals((Object)player)) {
            return;
        }
        if (this.autoPlay.get(player.getUniqueId()).booleanValue()) {
            this.handleBiddingCommand(player, "\u4e0d\u53eb");
            return;
        }
        if (secondsLeft.get() <= 5) {
            player.sendTitle(String.valueOf(org.bukkit.ChatColor.RED) + "\u26a0 " + secondsLeft.get() + " \u26a0", String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u8d85\u65f6\u5c06\u81ea\u52a8\u4e0d\u53eb", 0, 25, 0);
            this.spawnParticles(player, Particle.GLOW_SQUID_INK, 10);
        }
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_HAT, 0.5f, (float)(1.0 + (double)(30 - secondsLeft.get()) * 0.02));
        if (secondsLeft.decrementAndGet() <= 0) {
            player.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u65f6\u95f4\u5230\uff01\u81ea\u52a8\u9009\u62e9\u4e0d\u53eb");
            player.closeInventory();
            this.forceCloseAllGUIs();
            this.handleBiddingCommand(player, "\u4e0d\u53eb");
        }
    }

    private void confirmLandlord(Player player, int bidScore) {
        this.landlord = player;
        List<Card> cards = this.playerCards.get(this.landlord.getUniqueId());
        cards.addAll(this.landlordCards);
        cards.sort((a, b) -> Integer.compare(b.getValue(), a.getValue()));
        this.gameState = GameState.PLAYING;
        this.currentPlayer = this.landlord;
        this.passCount = 0;
        this.multiplier = bidScore;
        this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.GOLD) + player.getName() + " \u6210\u4e3a\u5730\u4e3b\uff01\u53eb\u5206: " + bidScore + " \u5206");
        this.showLandlordCards();
        player.closeInventory();
        this.forceCloseAllGUIs();
        this.updateBossBar();
        this.updateScoreboard();
        this.runTaskLater(() -> {
            this.startTurnTimer(this.currentPlayer);
            this.showPlayerCards(this.landlord, true);
        }, 2L);
    }

    private void showLandlordCardsPreview() {
        StringBuilder sb = new StringBuilder(String.valueOf(org.bukkit.ChatColor.GOLD) + "\u5730\u4e3b\u724c: ");
        for (int i = 0; i < this.landlordCards.size(); ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(this.landlordCards.get(i).toString());
        }
        this.broadcastToRoom(sb.toString());
    }

    private void handlePlayingCommand(Player player, String command) {
        switch (command) {
            case "\u51fa\u724c": {
                if (!player.equals((Object)this.currentPlayer)) {
                    player.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u8fd8\u6ca1\u8f6e\u5230\u4f60\u51fa\u724c\uff01");
                    return;
                }
                player.sendMessage(String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u8bf7\u70b9\u51fb\u3010\u9009\u62e9\u51fa\u724c\u3011\u6309\u94ae\u9009\u62e9\u8981\u51fa\u7684\u724c\uff01");
                break;
            }
            case "\u8fc7": {
                if (!player.equals((Object)this.currentPlayer)) {
                    player.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u8fd8\u6ca1\u8f6e\u5230\u4f60\uff01");
                    return;
                }
                if (this.lastPlayedCards.isEmpty() && this.passCount == 0) {
                    player.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u7b2c\u4e00\u8f6e\u4e0d\u80fd\u8fc7\u724c\uff01");
                    return;
                }
                this.passCard(player);
                break;
            }
            case "\u6258\u7ba1": {
                this.autoPlay.put(player.getUniqueId(), true);
                player.sendMessage(String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u5df2\u5f00\u542f\u6258\u7ba1\u6a21\u5f0f");
                break;
            }
            case "\u53d6\u6d88\u6258\u7ba1": {
                this.autoPlay.put(player.getUniqueId(), false);
                player.sendMessage(String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u5df2\u53d6\u6d88\u6258\u7ba1\u6a21\u5f0f");
            }
        }
    }

    public void playSelectedCards(Player player, List<Card> selectedCardsList, List<Integer> selectedIndices) {
        if (this.gameState == GameState.FINISHED || !this.gameStarted) {
            return;
        }
        List<Card> cards = this.playerCards.get(player.getUniqueId());
        for (int index : selectedIndices) {
            cards.remove(index);
        }
        this.lastPlayedCards = new ArrayList<Card>(selectedCardsList);
        this.lastPlayer = player;
        this.passCount = 0;
        this.selectedCards.get(player.getUniqueId()).clear();
        GameLogic.CardPattern pattern = GameLogic.recognizePattern(selectedCardsList);
        StringBuilder sb = new StringBuilder();
        for (Card card : selectedCardsList) {
            sb.append(card.toString()).append(" ");
        }
        for (Player p : this.players.values()) {
            p.spigot().sendMessage((BaseComponent)new TextComponent(" "));
        }
        this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.GREEN) + player.getName() + " \u51fa\u4e86 " + GameRoom.getPatternName(pattern.getType()) + ": " + sb.toString());
        if (pattern.getType() == GameLogic.CardType.BOMB) {
            this.multiplier *= 2;
            this.showBombEffect(player, 2);
        } else if (pattern.getType() == GameLogic.CardType.ROCKET) {
            this.multiplier *= 4;
            this.showBombEffect(player, 4);
            this.passCount = 0;
        }
        if (cards.isEmpty()) {
            if (player.equals((Object)this.landlord)) {
                this.endGame("\u5730\u4e3b\u83b7\u80dc\uff01");
            } else {
                this.endGame("\u519c\u6c11\u83b7\u80dc\uff01");
            }
            return;
        }
        this.nextPlayer();
        this.updateScoreboard();
        this.updateBossBar();
        for (Player p : this.players.values()) {
            this.showPlayerCards(p, p.equals((Object)this.currentPlayer));
        }
    }

    private void showBombEffect(Player player, int times) {
        String title = String.valueOf(org.bukkit.ChatColor.RED) + "\u2605 " + (times == 2 ? "\u70b8\u5f39\uff01" : "\u738b\u70b8\uff01") + " \u2605";
        String subtitle = String.valueOf(org.bukkit.ChatColor.GOLD) + "\u500d\u6570 \u00d7" + this.multiplier;
        for (Player p : this.players.values()) {
            p.sendTitle(title, subtitle, 10, 60, 10);
            Location loc = p.getEyeLocation();
            p.spawnParticle(Particle.POOF, loc, 50, 1.0, 1.0, 1.0, 0.5);
            p.spawnParticle(Particle.FLASH, loc, 1);
            p.playSound(loc, Sound.ENTITY_DRAGON_FIREBALL_EXPLODE, 1.5f, times == 2 ? 0.8f : 1.2f);
            if (times != 4) continue;
            p.spawnParticle(Particle.FIREWORK, loc, 100, 0.5, 0.5, 0.5, 0.5);
            p.playSound(loc, Sound.ENTITY_FIREWORK_ROCKET_BLAST, 2.0f, 0.8f);
        }
    }

    public static String getPatternName(GameLogic.CardType type) {
        switch (type) {
            case SINGLE: {
                return "\u5355\u724c";
            }
            case PAIR: {
                return "\u5bf9\u5b50";
            }
            case TRIPLE: {
                return "\u4e09\u5f20";
            }
            case TRIPLE_SINGLE: {
                return "\u4e09\u5e26\u4e00";
            }
            case TRIPLE_PAIR: {
                return "\u4e09\u5e26\u4e8c";
            }
            case FOUR_WITH_TWO_SINGLES: {
                return "\u56db\u5e26\u4e8c";
            }
            case FOUR_WITH_TWO_PAIRS: {
                return "\u56db\u5e26\u4e24\u5bf9";
            }
            case STRAIGHT: {
                return "\u987a\u5b50";
            }
            case PAIR_STRAIGHT: {
                return "\u8fde\u5bf9";
            }
            case TRIPLE_STRAIGHT: {
                return "\u98de\u673a";
            }
            case BOMB: {
                return "\u70b8\u5f39";
            }
            case ROCKET: {
                return "\u738b\u70b8";
            }
        }
        return "\u672a\u77e5";
    }

    public void passCard(Player player) {
        boolean lastWasRocket;
        if (this.gameState == GameState.FINISHED || !this.gameStarted) {
            return;
        }
        this.cancelCurrentTimer();
        ++this.passCount;
        this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.GRAY) + player.getName() + " \u9009\u62e9\u8fc7\u724c");
        boolean bl = lastWasRocket = !this.lastPlayedCards.isEmpty() && GameLogic.recognizePattern(this.lastPlayedCards).getType() == GameLogic.CardType.ROCKET;
        if (this.passCount >= 2 || lastWasRocket) {
            this.lastPlayedCards.clear();
            this.passCount = 0;
            if (this.lastPlayer != null) {
                this.currentPlayer = this.lastPlayer;
            } else {
                ArrayList<Player> playerList = new ArrayList<Player>(this.players.values());
                int nextIndex = (playerList.indexOf(player) + 1) % playerList.size();
                this.currentPlayer = (Player)playerList.get(nextIndex);
            }
            this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u8bf7 " + this.currentPlayer.getName() + " \u51fa\u724c\uff01");
            this.updateBossBar();
            this.updateScoreboard();
        } else {
            this.nextPlayer();
        }
        if (this.autoPlay.get(this.currentPlayer.getUniqueId()).booleanValue()) {
            this.runTaskLater(() -> this.autoPlayCards(this.currentPlayer), 5L);
        } else {
            this.startTurnTimer(this.currentPlayer);
        }
    }

    public void forceCloseAllGUIs() {
        for (Player player : this.players.values()) {
            if (player.equals((Object)this.currentPlayer)) continue;
            player.closeInventory();
        }
    }

    private void nextPlayer() {
        if (this.gameState == GameState.FINISHED || !this.gameStarted) {
            return;
        }
        this.cancelCurrentTimer();
        ArrayList<Player> playerList = new ArrayList<Player>(this.players.values());
        int nextIndex = (playerList.indexOf(this.currentPlayer) + 1) % playerList.size();
        this.currentPlayer = (Player)playerList.get(nextIndex);
        if (!this.currentPlayer.isOnline()) {
            this.autoPlay.put(this.currentPlayer.getUniqueId(), true);
            this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.RED) + this.currentPlayer.getName() + " \u5df2\u6389\u7ebf\uff0c\u81ea\u52a8\u6258\u7ba1\uff01");
            this.autoPlayCards(this.currentPlayer);
            return;
        }
        this.updateBossBar();
        this.updateScoreboard();
        this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u8bf7 " + this.currentPlayer.getName() + " \u5728 " + this.getTurnTimeout() + " \u79d2\u5185\u51fa\u724c\uff01");
        if (this.autoPlay.get(this.currentPlayer.getUniqueId()).booleanValue()) {
            this.currentPlayer.sendMessage(String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u4f60\u5904\u4e8e\u6258\u7ba1\u72b6\u6001\uff0c\u7cfb\u7edf\u5c06\u81ea\u52a8\u51fa\u724c");
            TextComponent mes = new TextComponent(String.valueOf(org.bukkit.ChatColor.RED) + "\u53ef\u8f93\u5165/landlord_action auto \u9000\u51fa\u6258\u7ba1");
            TextComponent cancelButton = new TextComponent(String.valueOf(org.bukkit.ChatColor.RED) + "\u3010\u53d6\u6d88\u6258\u7ba1\u3011");
            cancelButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/landlord_action auto"));
            cancelButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u70b9\u51fb\u53d6\u6d88\u6258\u7ba1").create()));
            this.currentPlayer.spigot().sendMessage((BaseComponent)mes);
            this.currentPlayer.spigot().sendMessage((BaseComponent)cancelButton);
            this.runTaskLater(() -> this.autoPlayCards(this.currentPlayer), 20L);
        } else {
            List<Card> cards = this.getPlayerCards(this.currentPlayer);
            if (cards == null || cards.isEmpty()) {
                return;
            }
            this.cardSelectionGUI.openGUI(this.currentPlayer, this.getPlayerCards(this.currentPlayer));
            this.startTurnTimer(this.currentPlayer);
        }
    }

    private void startTurnTimer(final Player player) {
        this.cancelCurrentTimer();
        final AtomicInteger secondsLeft = new AtomicInteger(this.getTurnTimeout());
        if (this.plugin.isFolia()) {
            player.getScheduler().runAtFixedRate((Plugin)this.plugin, task -> this.handleTimerTick(player, secondsLeft), null, 20L, 20L);
        } else {
            BukkitTask task2 = new BukkitRunnable(){

                public void run() {
                    GameRoom.this.handleTimerTick(player, secondsLeft);
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
            this.playerTimers.put(player.getUniqueId(), task2);
        }
    }

    private void handleTimerTick(Player player, AtomicInteger secondsLeft) {
        if (this.gameState == GameState.FINISHED || !this.gameStarted || !player.isOnline()) {
            return;
        }
        if (!player.isOnline() || this.currentPlayer == null || !this.currentPlayer.equals((Object)player)) {
            return;
        }
        if (secondsLeft.get() <= 5) {
            player.sendTitle(String.valueOf(org.bukkit.ChatColor.RED) + "\u26a0 " + secondsLeft.get() + " \u26a0", String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u8d85\u65f6\u5c06\u81ea\u52a8\u6258\u7ba1", 0, 25, 0);
            this.spawnParticles(player, Particle.GLOW_SQUID_INK, 10);
        }
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_HAT, 0.5f, (float)(1.0 + (double)(this.getTurnTimeout() - secondsLeft.get()) * 0.02));
        if (secondsLeft.decrementAndGet() <= 0) {
            this.autoPlay.put(player.getUniqueId(), true);
            player.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u65f6\u95f4\u5230\uff01\u5df2\u81ea\u52a8\u6258\u7ba1");
            player.closeInventory();
            this.forceCloseAllGUIs();
            if (this.gameState == GameState.BIDDING) {
                this.handleBiddingCommand(player, "\u4e0d\u53eb");
            } else {
                this.autoPlayCards(player);
            }
        }
    }

    private void spawnParticles(Player p, Particle particle, int count) {
        Location loc = p.getLocation().add(0.0, 1.0, 0.0);
        p.spawnParticle(particle, loc, count, 0.5, 0.5, 0.5, 0.1);
    }

    private void cancelCurrentTimer() {
        BukkitTask task;
        if (this.currentPlayer != null && (task = this.playerTimers.remove(this.currentPlayer.getUniqueId())) != null) {
            task.cancel();
        }
    }

    private void autoPlayCards(Player player) {
        if (this.gameState == GameState.FINISHED || !this.gameStarted || !this.players.containsKey(player.getUniqueId())) {
            return;
        }
        if (!player.equals((Object)this.currentPlayer)) {
            return;
        }
        List<Card> cards = this.playerCards.get(player.getUniqueId());
        if (cards == null || cards.isEmpty()) {
            return;
        }
        if (!this.autoPlay.get(player.getUniqueId()).booleanValue()) {
            this.autoPlay.put(player.getUniqueId(), true);
        }
        this.runTaskLater(() -> {
            List<Card> selectedCards = GameLogic.autoSelectCards(cards, this.lastPlayedCards.isEmpty() ? null : GameLogic.recognizePattern(this.lastPlayedCards));
            if (selectedCards != null && !selectedCards.isEmpty()) {
                this.playSelectedCards(player, selectedCards, this.getCardIndices(cards, selectedCards));
                this.showPlayerCards(player, false);
            } else {
                this.passCard(player);
            }
        }, 20L);
    }

    private List<Integer> getCardIndices(List<Card> hand, List<Card> selected) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ArrayList<Card> tempHand = new ArrayList<Card>(hand);
        block0: for (Card card : selected) {
            for (int i = 0; i < tempHand.size(); ++i) {
                if (!((Card)tempHand.get(i)).equals(card)) continue;
                indices.add(i);
                tempHand.remove(i);
                continue block0;
            }
        }
        return indices;
    }

    private void updatePlayerStats(String result) {
        int gameMultiplier;
        boolean isLandlordWin = result.contains("\u5730\u4e3b\u83b7\u80dc");
        int farmerPointsChange = gameMultiplier = this.multiplier;
        for (Player player : this.players.values()) {
            String playerName = player.getName();
            StatsManager.PlayerStats stats = this.plugin.getStatsManager().getPlayerStats(playerName);
            stats.incrementGamesPlayed();
            boolean isOnline = player.isOnline();
            if (player.equals((Object)this.landlord)) {
                if (isLandlordWin) {
                    stats.incrementGamesWon();
                    if (isOnline) {
                        stats.addPoints(gameMultiplier * 2);
                    }
                } else {
                    stats.incrementGamesLost();
                    stats.addPoints(-gameMultiplier * 2);
                }
            } else if (!isLandlordWin) {
                stats.incrementGamesWon();
                if (isOnline) {
                    stats.addPoints(farmerPointsChange);
                }
            } else {
                stats.incrementGamesLost();
                stats.addPoints(-farmerPointsChange);
            }
            this.plugin.getStatsManager().updatePlayerStats(playerName, stats);
        }
    }

    private void endGame(String reason) {
        if (this.gameState == GameState.FINISHED) {
            return;
        }
        this.cancelCurrentTimer();
        this.playerTimers.values().forEach(task -> {
            if (task != null) {
                task.cancel();
            }
        });
        this.playerTimers.clear();
        this.gameState = GameState.FINISHED;
        this.forceCloseAllGUIs();
        for (UUID playerId : this.players.keySet()) {
            this.readyStatus.put(playerId, false);
            this.autoPlay.put(playerId, false);
            this.selectedCards.get(playerId).clear();
        }
        if (this.moneyGame) {
            this.handleMoneyRewards(reason);
        }
        this.lastHandMessages.clear();
        this.playerTimers.values().forEach(BukkitTask::cancel);
        this.playerTimers.clear();
        this.gameStarted = false;
        this.updatePlayerStats(reason);
        for (Player p : this.players.values()) {
            p.spigot().sendMessage((BaseComponent)new TextComponent(" "));
        }
        this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.GOLD) + "=== \u672c\u5c40\u79ef\u5206\u7ed3\u7b97 ===");
        this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u6700\u7ec8\u500d\u6570: x" + this.multiplier);
        boolean isLandlordWin = reason.contains("\u5730\u4e3b\u83b7\u80dc");
        int farmerPoints = this.multiplier;
        Player landlordPlayer = this.landlord;
        boolean landlordOnline = landlordPlayer != null && landlordPlayer.isOnline();
        String landlordMsg = String.valueOf(org.bukkit.ChatColor.RED) + "\u5730\u4e3b " + landlordPlayer.getName() + ": " + (isLandlordWin ? (landlordOnline ? String.valueOf(org.bukkit.ChatColor.GREEN) + "+" + this.multiplier * 2 : String.valueOf(org.bukkit.ChatColor.GRAY) + "+0 (\u6389\u7ebf)") : String.valueOf(org.bukkit.ChatColor.RED) + "-" + this.multiplier * 2);
        this.broadcastToRoom(landlordMsg);
        for (Player player : this.players.values()) {
            if (player.equals((Object)landlordPlayer)) continue;
            boolean farmerOnline = player.isOnline();
            String farmerMsg = String.valueOf(org.bukkit.ChatColor.GREEN) + "\u519c\u6c11 " + player.getName() + ": " + (!isLandlordWin ? (farmerOnline ? String.valueOf(org.bukkit.ChatColor.GREEN) + "+" + farmerPoints : String.valueOf(org.bukkit.ChatColor.GRAY) + "+0 (\u6389\u7ebf)") : String.valueOf(org.bukkit.ChatColor.RED) + "-" + farmerPoints);
            this.broadcastToRoom(farmerMsg);
        }
        this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.GOLD) + "=== \u6e38\u620f\u7ed3\u675f ===");
        this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.YELLOW) + reason);
        TextComponent readyButton = new TextComponent("\u3010\u51c6\u5907/\u53d6\u6d88\u51c6\u5907\u3011");
        readyButton.setColor(ChatColor.GREEN);
        readyButton.setBold(Boolean.valueOf(true));
        readyButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/landlord ready"));
        readyButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u70b9\u51fb\u5207\u6362\u51c6\u5907\u72b6\u6001").color(ChatColor.YELLOW).create()));
        for (Player player : this.players.values()) {
            player.spigot().sendMessage((BaseComponent)new TextComponent(" "));
            player.spigot().sendMessage((BaseComponent)readyButton);
            this.autoPlay.put(player.getUniqueId(), false);
            if (!this.autoPlay.getOrDefault(player.getUniqueId(), false).booleanValue()) continue;
            player.sendMessage(String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u4f60\u7684\u6258\u7ba1\u72b6\u6001\u5df2\u81ea\u52a8\u53d6\u6d88");
        }
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (Map.Entry<UUID, Player> entry : this.players.entrySet()) {
            if (entry.getValue().isOnline()) continue;
            hashSet.add(entry.getKey());
        }
        for (UUID playerId : hashSet) {
            Player player = this.players.get(playerId);
            this.removePlayer(player);
            this.plugin.removePlayerFromRoom(playerId);
        }
        this.runTaskLater(this::resetGame, 40L);
    }

    private void resetGame() {
        for (UUID playerId : this.players.keySet()) {
            this.readyStatus.put(playerId, false);
            this.autoPlay.put(playerId, false);
            this.selectedCards.get(playerId).clear();
        }
        this.lastHandMessages.clear();
        this.gameStarted = false;
        this.gameState = GameState.WAITING;
        this.landlord = null;
        this.landlordCards.clear();
        this.lastPlayedCards.clear();
        this.currentPlayer = null;
        this.lastPlayer = null;
        this.passCount = 0;
        this.multiplier = 1;
        this.currentBidScore = 0;
        this.currentHighestBidder = null;
        this.biddingOrder.clear();
        this.biddingIndex = 0;
        this.biddingPhaseComplete = false;
        this.playerCards.clear();
        this.selectedCards.clear();
        for (UUID playerId : this.players.keySet()) {
            this.selectedCards.put(playerId, new ArrayList());
            this.bidStatus.put(playerId, 0);
            this.autoPlay.put(playerId, false);
        }
        this.cancelCurrentTimer();
        this.playerTimers.values().forEach(BukkitTask::cancel);
        this.playerTimers.clear();
        this.updateBossBar();
        this.updateScoreboard();
        for (Player player : this.players.values()) {
            if (!this.autoPlay.getOrDefault(player.getUniqueId(), false).booleanValue()) continue;
            player.sendMessage(String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u4f60\u7684\u6258\u7ba1\u72b6\u6001\u5df2\u81ea\u52a8\u53d6\u6d88");
        }
    }

    public void showPlayerCards(Player player, boolean allowSelection) {
        if (this.gameState == GameState.FINISHED || !this.gameStarted) {
            return;
        }
        if (this.isAutoPlay(player)) {
            return;
        }
        if (allowSelection && !player.equals((Object)this.currentPlayer)) {
            return;
        }
        List<Card> cards = this.playerCards.get(player.getUniqueId());
        if (cards == null || cards.isEmpty()) {
            return;
        }
        if (allowSelection && player.equals((Object)this.currentPlayer)) {
            this.cardSelectionGUI.openGUI(player, cards);
        } else {
            ComponentBuilder builder = new ComponentBuilder("\u4f60\u7684\u624b\u724c:").color(ChatColor.GREEN);
            for (Card card : cards) {
                builder.append(" ").append(card.toString());
            }
            player.spigot().sendMessage(builder.create());
        }
    }

    public boolean isAutoPlay(Player player) {
        return this.autoPlay.getOrDefault(player.getUniqueId(), false);
    }

    public List<Card> getPlayerCards(Player player) {
        return this.playerCards.get(player.getUniqueId());
    }

    public void toggleAutoPlay(Player player) {
        boolean current = this.autoPlay.get(player.getUniqueId());
        this.autoPlay.put(player.getUniqueId(), !current);
        player.sendMessage(!current ? String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u5df2\u5f00\u542f\u6258\u7ba1" : String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u5df2\u53d6\u6d88\u6258\u7ba1");
        if (!current && player.equals((Object)this.currentPlayer)) {
            this.autoPlayCards(player);
        }
    }

    private void showLandlordCards() {
        StringBuilder sb = new StringBuilder(String.valueOf(org.bukkit.ChatColor.GOLD) + "\u5730\u4e3b\u724c: ");
        for (int i = 0; i < this.landlordCards.size(); ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(this.landlordCards.get(i).toString());
        }
        this.broadcastToRoom(sb.toString());
        this.updateScoreboard();
    }

    private void sendGameButtons(Player player) {
        player.sendMessage(String.valueOf(org.bukkit.ChatColor.AQUA) + "=== \u6e38\u620f\u64cd\u4f5c ===");
        player.sendMessage(String.valueOf(org.bukkit.ChatColor.GREEN) + "\u8f93\u5165/ddz ready \u51c6\u5907/\u53d6\u6d88\u51c6\u5907");
        TextComponent readyButton = new TextComponent("\u3010\u51c6\u5907/\u53d6\u6d88\u51c6\u5907\u3011");
        readyButton.setColor(ChatColor.GREEN);
        readyButton.setBold(Boolean.valueOf(true));
        readyButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/landlord ready"));
        readyButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u70b9\u51fb\u5207\u6362\u51c6\u5907\u72b6\u6001").color(ChatColor.YELLOW).create()));
        player.spigot().sendMessage((BaseComponent)readyButton);
    }

    private void updateBossBar() {
        BarColor color;
        String title;
        if (this.bossBar == null) {
            return;
        }
        double progress = switch (this.gameState.ordinal()) {
            case 0 -> {
                title = "\u623f\u95f4 " + this.roomId + " - \u7b49\u5f85\u73a9\u5bb6 (" + this.players.size() + "/3)" + (String)(this.moneyGame ? " " + String.valueOf(org.bukkit.ChatColor.GOLD) + "[\u91d1\u5e01\u8d5b]" : "");
                color = BarColor.BLUE;
                yield (double)this.players.size() / 3.0;
            }
            case 1 -> {
                title = "\u53eb\u5206\u9636\u6bb5 - \u5f53\u524d: " + (this.currentPlayer != null ? this.currentPlayer.getName() : "\u65e0") + " | \u6700\u9ad8\u5206: " + this.currentBidScore + (String)(this.moneyGame ? " " + String.valueOf(org.bukkit.ChatColor.GOLD) + "[\u91d1\u5e01\u8d5b]" : "");
                color = BarColor.YELLOW;
                yield 0.5;
            }
            case 2 -> {
                String currentPlayerName = this.currentPlayer != null ? this.currentPlayer.getName() : "\u65e0";
                title = "\u6e38\u620f\u4e2d - \u5f53\u524d: " + currentPlayerName + " | \u500d\u6570: x" + this.multiplier + (String)(this.landlord != null ? " | \u5730\u4e3b: " + this.landlord.getName() : "") + (String)(this.moneyGame ? " " + String.valueOf(org.bukkit.ChatColor.GOLD) + "[\u91d1\u5e01\u8d5b]" : "");
                color = BarColor.GREEN;
                yield 1.0;
            }
            case 3 -> {
                title = "\u6e38\u620f\u7ed3\u675f - \u5373\u5c06\u91cd\u7f6e" + (String)(this.moneyGame ? " " + String.valueOf(org.bukkit.ChatColor.GOLD) + "[\u91d1\u5e01\u8d5b]" : "");
                color = BarColor.RED;
                yield 0.0;
            }
            default -> {
                title = "\u623f\u95f4 " + this.roomId + (String)(this.moneyGame ? " " + String.valueOf(org.bukkit.ChatColor.GOLD) + "[\u91d1\u5e01\u8d5b]" : "");
                color = BarColor.WHITE;
                yield 0.0;
            }
        };
        this.bossBar.setTitle(title);
        this.bossBar.setColor(color);
        this.bossBar.setProgress(Math.max(0.0, Math.min(1.0, progress)));
    }

    private void updateScoreboard() {
        if (this.gameState == GameState.FINISHED) {
            return;
        }
        if (!this.plugin.isScoreboardEnabled() || this.plugin.isFolia()) {
            for (Player player : this.players.values()) {
                this.updateScoreboardBossBar(player);
            }
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastScoreboardUpdate < 100L) {
            return;
        }
        this.lastScoreboardUpdate = now;
        for (Player player : this.players.values()) {
            if (this.plugin.isFolia()) {
                this.updatePlayerScoreboardNow(player);
                continue;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.updatePlayerScoreboardNow(player));
        }
    }

    private void updatePlayerScoreboardNow(Player player) {
        try {
            if (!player.isOnline()) {
                return;
            }
            player.getScheduler().run((Plugin)this.plugin, task -> {
                try {
                    ScoreboardManager manager = Bukkit.getScoreboardManager();
                    if (manager == null) {
                        this.plugin.getLogger().warning("ScoreboardManager\u672a\u521d\u59cb\u5316\uff01");
                        return;
                    }
                    Scoreboard scoreboard = manager.getNewScoreboard();
                    Objective objective = scoreboard.registerNewObjective("landlord_" + player.getName(), "dummy", String.valueOf(org.bukkit.ChatColor.GOLD) + "\u6597\u5730\u4e3b");
                    objective.setDisplaySlot(DisplaySlot.SIDEBAR);
                    AtomicInteger line = new AtomicInteger(10);
                    objective.getScore(String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u623f\u95f4: " + this.roomId).setScore(line.getAndDecrement());
                    objective.getScore("").setScore(line.getAndDecrement());
                    if (this.gameStarted) {
                        if (this.gameState == GameState.BIDDING) {
                            objective.getScore(String.valueOf(org.bukkit.ChatColor.GOLD) + "\u25b6 \u53eb\u5206\u9636\u6bb5").setScore(line.getAndDecrement());
                            objective.getScore(String.valueOf(org.bukkit.ChatColor.WHITE) + "\u5f53\u524d\u53eb\u5206: " + (this.currentPlayer != null ? this.currentPlayer.getName() : "\u65e0")).setScore(line.getAndDecrement());
                            objective.getScore(String.valueOf(org.bukkit.ChatColor.AQUA) + "\u6700\u9ad8\u5206: " + this.currentBidScore + "\u5206").setScore(line.getAndDecrement());
                        } else if (this.gameState == GameState.PLAYING) {
                            if (this.landlord != null) {
                                objective.getScore(String.valueOf(org.bukkit.ChatColor.RED) + "\u5730\u4e3b: " + this.landlord.getName()).setScore(line.getAndDecrement());
                                objective.getScore(String.valueOf(org.bukkit.ChatColor.AQUA) + "\u500d\u6570: \u00d7" + this.multiplier).setScore(line.getAndDecrement());
                            }
                            objective.getScore(String.valueOf(org.bukkit.ChatColor.WHITE) + "\u5f53\u524d\u51fa\u724c: " + (this.currentPlayer != null ? this.currentPlayer.getName() : "\u65e0")).setScore(line.getAndDecrement());
                        }
                        objective.getScore(String.valueOf(org.bukkit.ChatColor.GREEN) + "\u624b\u724c\u6570\u91cf:").setScore(line.getAndDecrement());
                        this.players.values().forEach(p -> {
                            List<Card> cards = this.playerCards.get(p.getUniqueId());
                            int count = cards != null ? cards.size() : 0;
                            objective.getScore(p.getName() + ": " + count + "\u5f20").setScore(line.getAndDecrement());
                        });
                    } else {
                        objective.getScore(String.valueOf(org.bukkit.ChatColor.WHITE) + "\u73a9\u5bb6\u5217\u8868:").setScore(line.getAndDecrement());
                        this.players.values().forEach(p -> {
                            boolean ready = this.readyStatus.getOrDefault(p.getUniqueId(), false);
                            objective.getScore((ready ? String.valueOf(org.bukkit.ChatColor.GREEN) + "\u2713 " : String.valueOf(org.bukkit.ChatColor.RED) + "\u2717 ") + p.getName()).setScore(line.getAndDecrement());
                        });
                    }
                    player.setScoreboard(scoreboard);
                }
                catch (Exception e) {
                    this.updateScoreboardBossBar(player);
                }
            }, null);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u8c03\u5ea6\u8ba1\u5206\u677f\u66f4\u65b0\u5931\u8d25: " + e.getMessage());
        }
    }

    private void updateScoreboardBossBar(Player player) {
        if (this.gameState == GameState.FINISHED && this.lastHandMessages.containsKey(player.getUniqueId())) {
            return;
        }
        if (this.scoreboardBossBar == null) {
            return;
        }
        StringBuilder info = new StringBuilder();
        if (this.gameStarted) {
            info.append(org.bukkit.ChatColor.AQUA).append("\u624b\u724c\u6570\u91cf: ");
            ArrayList<Player> orderedPlayers = new ArrayList<Player>(this.players.values());
            orderedPlayers.sort(Comparator.comparing(Player::getName));
            for (Player p : orderedPlayers) {
                List<Card> cards = this.playerCards.get(p.getUniqueId());
                int cardCount = cards != null ? cards.size() : 0;
                String name = p.getName();
                info.append(name).append(":").append(cardCount).append(" ");
            }
        } else {
            info.append(org.bukkit.ChatColor.WHITE).append("\u73a9\u5bb6\u72b6\u6001: ");
            ArrayList<Player> orderedPlayers = new ArrayList<Player>(this.players.values());
            orderedPlayers.sort(Comparator.comparing(Player::getName));
            for (Player p : orderedPlayers) {
                boolean ready = this.readyStatus.get(p.getUniqueId());
                String status = ready ? String.valueOf(org.bukkit.ChatColor.GREEN) + "\u2713" : String.valueOf(org.bukkit.ChatColor.RED) + "\u2717";
                String name = p.getName();
                info.append(status).append(name).append(" ");
            }
        }
        this.scoreboardBossBar.setTitle(info.toString());
        this.scoreboardBossBar.setProgress(1.0);
    }

    private void broadcastToRoom(String message) {
        for (Player player : this.players.values()) {
            player.sendMessage(message);
        }
    }

    public void cleanup() {
        this.lastHandMessages.clear();
        this.playerTimers.values().forEach(BukkitTask::cancel);
        this.playerTimers.clear();
        if (this.bossBar != null) {
            this.bossBar.removeAll();
        }
        if (this.scoreboardBossBar != null) {
            this.scoreboardBossBar.removeAll();
        }
        for (Player player : this.players.values()) {
            try {
                player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
            }
            catch (Exception exception) {}
        }
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public List<Card> getLastPlayedCards() {
        return new ArrayList<Card>(this.lastPlayedCards);
    }

    public Player getCurrentPlayer() {
        return this.currentPlayer;
    }

    public int getCurrentBidScore() {
        return this.currentBidScore;
    }

    public Player getCurrentHighestBidder() {
        return this.currentHighestBidder;
    }

    public List<Card> getLandlordCards() {
        return new ArrayList<Card>(this.landlordCards);
    }

    public Map<UUID, Boolean> getReadyStatus() {
        return this.readyStatus;
    }

    public int getPassCount() {
        return this.passCount;
    }

    public GameState getGameState() {
        return this.gameState;
    }

    public Player getRoomOwner() {
        return this.roomOwner;
    }

    public String getRoomId() {
        return this.roomId;
    }

    public int getPlayerCount() {
        return this.players.size();
    }

    public boolean isGameStarted() {
        return this.gameStarted;
    }

    public void toggleMoneyGame(Player player) {
        String status;
        if (!player.equals((Object)this.roomOwner)) {
            player.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u53ea\u6709\u623f\u4e3b\u53ef\u4ee5\u8bbe\u7f6e\u91d1\u5e01\u8d5b\uff01");
            return;
        }
        if (this.gameStarted) {
            player.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u6e38\u620f\u5df2\u7ecf\u5f00\u59cb\uff0c\u65e0\u6cd5\u4fee\u6539\u91d1\u5e01\u8d5b\u8bbe\u7f6e\uff01");
            return;
        }
        if (!this.plugin.isBountyEnabled() || this.plugin.getEconomy() == null) {
            player.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u91d1\u5e01\u8d5b\u529f\u80fd\u672a\u542f\u7528\u6216Vault\u7ecf\u6d4e\u7cfb\u7edf\u4e0d\u53ef\u7528\uff01");
            return;
        }
        this.moneyGame = !this.moneyGame;
        String string = status = this.moneyGame ? String.valueOf(org.bukkit.ChatColor.GREEN) + "\u5df2\u5f00\u542f" : String.valueOf(org.bukkit.ChatColor.RED) + "\u5df2\u5173\u95ed";
        if (this.moneyGame) {
            boolean allHaveMoney = true;
            if (this.moneyGame && this.plugin.isBountyEnabled()) {
                double required = this.plugin.getMoneyMultiplier();
                double playerBalance = this.plugin.getPlayerBalance(player);
                if (playerBalance < required) {
                    player.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u8b66\u544a\uff01\u91d1\u5e01\u8d5b\u9700\u8981\u81f3\u5c11 " + required + " \u91d1\u5e01\uff0c\u4f60\u5f53\u524d\u53ea\u6709 " + playerBalance + " \u91d1\u5e01");
                    return;
                }
            }
            if (!allHaveMoney) {
                player.sendMessage(String.valueOf(org.bukkit.ChatColor.YELLOW) + "\u5df2\u5f00\u542f\u91d1\u5e01\u8d5b\uff0c\u4f46\u6709\u4e9b\u73a9\u5bb6\u91d1\u5e01\u4e0d\u8db3\uff01");
            }
        }
        this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.GOLD) + "\u91d1\u5e01\u8d5b " + status + String.valueOf(org.bukkit.ChatColor.GOLD) + "\uff01\u672c\u5c40\u91d1\u5e01\u500d\u7387: " + this.plugin.getMoneyMultiplier() + " (\u9700\u8981\u81f3\u5c11 " + this.plugin.getMoneyMultiplier() + " \u91d1\u5e01)");
        this.updateBossBar();
    }

    private void handleMoneyRewards(String result) {
        if (!this.moneyGame || !this.plugin.isBountyEnabled()) {
            return;
        }
        Economy economy = (Economy)this.plugin.getEconomy();
        if (economy == null) {
            this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.RED) + "\u7ecf\u6d4e\u7cfb\u7edf\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u5904\u7406\u91d1\u5e01\u5956\u52b1\uff01");
            return;
        }
        boolean isLandlordWin = result.contains("\u5730\u4e3b\u83b7\u80dc");
        int baseAmount = this.multiplier * this.plugin.getMoneyMultiplier();
        Player landlordPlayer = this.landlord;
        List farmers = this.players.values().stream().filter(p -> !p.equals((Object)landlordPlayer)).collect(Collectors.toList());
        if (isLandlordWin) {
            for (Player farmer : farmers) {
                if (!farmer.isOnline() && !isLandlordWin) continue;
                double farmerBalance = economy.getBalance((OfflinePlayer)farmer);
                if (farmerBalance >= (double)baseAmount) {
                    this.forceTransferMoney(farmer, landlordPlayer, baseAmount, "\u8f93\u7ed9\u5730\u4e3b");
                    continue;
                }
                if (farmerBalance > 0.0) {
                    this.forceTransferMoney(farmer, landlordPlayer, farmerBalance, "\u8f93\u7ed9\u5730\u4e3b(\u90e8\u5206\u652f\u4ed8)");
                }
                this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.RED) + farmer.getName() + " \u91d1\u5e01\u4e0d\u8db3\uff0c\u65e0\u6cd5\u652f\u4ed8\u5168\u90e8\u8d4c\u6ce8\uff01");
            }
        } else {
            int farmerReward = baseAmount / 2;
            double landlordBalance = economy.getBalance((OfflinePlayer)landlordPlayer);
            double totalRequired = farmerReward * farmers.size();
            if (!landlordPlayer.isOnline() && isLandlordWin) {
                return;
            }
            if (landlordBalance >= totalRequired) {
                for (Player farmer : farmers) {
                    this.forceTransferMoney(landlordPlayer, farmer, farmerReward, "\u8d62\u5f97\u6bd4\u8d5b");
                }
            } else {
                double eachFarmerGets = landlordBalance / (double)farmers.size();
                if (eachFarmerGets > 0.0) {
                    for (Player farmer : farmers) {
                        this.forceTransferMoney(landlordPlayer, farmer, eachFarmerGets, "\u5e73\u5206\u5730\u4e3b\u5269\u4f59\u91d1\u5e01");
                    }
                }
                this.broadcastToRoom(String.valueOf(org.bukkit.ChatColor.RED) + String.format("\u5730\u4e3b\u91d1\u5e01\u4e0d\u8db3\uff01\u519c\u6c11\u5e73\u5206\u4e86\u5730\u4e3b\u5269\u4f59\u7684 %.2f \u91d1\u5e01", landlordBalance));
            }
        }
    }

    private void forceTransferMoney(Player from, Player to, double amount, String reason) {
        Economy econ = (Economy)this.plugin.getEconomy();
        if (from == null || to == null || econ == null) {
            return;
        }
        String fromName = from.getName();
        String toName = to.getName();
        double fromBalance = econ.getBalance((OfflinePlayer)from);
        double actualAmount = Math.min(amount, fromBalance);
        if (actualAmount <= 0.0) {
            this.plugin.getLogger().warning(fromName + " \u91d1\u5e01\u4e0d\u8db3\uff0c\u65e0\u6cd5\u652f\u4ed8 " + amount + " \u7ed9 " + toName);
            if (from.isOnline()) {
                from.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "\u4f60\u7684\u91d1\u5e01\u4e0d\u8db3\uff0c\u65e0\u6cd5\u5b8c\u6210\u652f\u4ed8\uff01");
            }
            return;
        }
        EconomyResponse withdrawResponse = econ.withdrawPlayer((OfflinePlayer)from, actualAmount);
        if (!withdrawResponse.transactionSuccess()) {
            this.plugin.getLogger().warning(fromName + " \u91d1\u5e01\u6263\u9664\u5931\u8d25: " + withdrawResponse.errorMessage);
            return;
        }
        EconomyResponse depositResponse = econ.depositPlayer((OfflinePlayer)to, actualAmount);
        if (!depositResponse.transactionSuccess()) {
            econ.depositPlayer((OfflinePlayer)from, actualAmount);
            this.plugin.getLogger().warning(toName + " \u91d1\u5e01\u8f6c\u8d26\u5931\u8d25: " + depositResponse.errorMessage);
            return;
        }
        StatsManager.PlayerStats fromStats = this.plugin.getStatsManager().getPlayerStats(fromName);
        fromStats.addNetMoney(-actualAmount);
        this.plugin.getStatsManager().updatePlayerStats(fromName, fromStats);
        StatsManager.PlayerStats toStats = this.plugin.getStatsManager().getPlayerStats(toName);
        toStats.addNetMoney(actualAmount);
        this.plugin.getStatsManager().updatePlayerStats(toName, toStats);
        if (from.isOnline()) {
            from.sendMessage(String.valueOf(org.bukkit.ChatColor.YELLOW) + String.format("\u4f60\u652f\u4ed8\u4e86 %.2f \u91d1\u5e01\u7ed9 %s (%s)", actualAmount, toName, reason));
        }
        if (to.isOnline()) {
            to.sendMessage(String.valueOf(org.bukkit.ChatColor.GREEN) + String.format("\u4f60\u6536\u5230\u4e86 %.2f \u91d1\u5e01\u6765\u81ea %s (%s)", actualAmount, fromName, reason));
        }
    }

    public boolean isMoneyGame() {
        return this.moneyGame;
    }

    public static enum GameState {
        WAITING,
        BIDDING,
        PLAYING,
        FINISHED;

    }
}

