/*
 * Decompiled with CFR 0.152.
 */
package cn.kurt6.landlord;

import cn.kurt6.landlord.GameRoom;
import cn.kurt6.landlord.StatsManager;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Landlord
extends JavaPlugin
implements Listener,
CommandExecutor,
TabCompleter {
    private final Map<UUID, GameRoom> playerRooms = new ConcurrentHashMap<UUID, GameRoom>();
    private final Map<String, GameRoom> gameRooms = new ConcurrentHashMap<String, GameRoom>();
    private int roomCounter = 1;
    private StatsManager statsManager;
    private int turnTimeout = 60;
    private Object econ = null;
    private boolean bountyEnabled;
    private int moneyMultiplier;
    private boolean scoreboardEnabled = true;
    private boolean vaultAvailable = false;
    private final Map<UUID, Long> lastJoinAttempt = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Long> lastClickTimes = new HashMap<UUID, Long>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.vaultAvailable = Bukkit.getPluginManager().getPlugin("Vault") != null;
        this.loadConfig();
        if (this.bountyEnabled && this.vaultAvailable) {
            if (!this.setupEconomy()) {
                this.getLogger().warning("\u672a\u627e\u5230Vault\u7ecf\u6d4e\u7cfb\u7edf\u63d2\u4ef6\uff0c\u91d1\u5e01\u8d5b\u529f\u80fd\u5c06\u4e0d\u53ef\u7528\uff01");
                this.bountyEnabled = false;
            }
        } else {
            this.bountyEnabled = false;
        }
        this.statsManager = new StatsManager(this);
        this.getCommand("landlord").setExecutor((CommandExecutor)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("\u91d1\u5e01\u8d5b\u529f\u80fd: " + (this.bountyEnabled ? "\u5df2\u542f\u7528" : "\u5df2\u7981\u7528"));
    }

    private boolean setupEconomy() {
        if (!this.bountyEnabled || !this.vaultAvailable) {
            return false;
        }
        try {
            Class<?> economyClass = Class.forName("net.milkbowl.vault.economy.Economy");
            RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(economyClass);
            if (rsp == null) {
                return false;
            }
            this.econ = rsp.getProvider();
            return this.econ != null;
        }
        catch (ClassNotFoundException e) {
            this.getLogger().warning("Vault Economy\u7c7b\u4e0d\u5b58\u5728");
            return false;
        }
        catch (Exception e) {
            this.getLogger().warning("\u521d\u59cb\u5316\u7ecf\u6d4e\u7cfb\u7edf\u65f6\u51fa\u9519: " + e.getMessage());
            return false;
        }
    }

    public double getPlayerBalance(Player player) {
        if (!this.bountyEnabled || this.econ == null) {
            return 0.0;
        }
        try {
            return (Double)this.econ.getClass().getMethod("getBalance", OfflinePlayer.class).invoke(this.econ, player);
        }
        catch (Exception e) {
            this.getLogger().warning("\u83b7\u53d6\u73a9\u5bb6\u4f59\u989d\u65f6\u51fa\u9519: " + e.getMessage());
            return 0.0;
        }
    }

    public void loadConfig() {
        this.reloadConfig();
        this.turnTimeout = this.getConfig().getInt("turn-timeout", 60);
        boolean configBountyEnabled = this.getConfig().getBoolean("bounty-enabled", false);
        this.bountyEnabled = configBountyEnabled && this.vaultAvailable;
        this.moneyMultiplier = this.getConfig().getInt("money-multiplier", 100);
        this.scoreboardEnabled = this.getConfig().getBoolean("scoreboard-enabled", true);
        if (!this.bountyEnabled) {
            this.econ = null;
        }
    }

    public boolean isScoreboardEnabled() {
        return this.scoreboardEnabled;
    }

    public int getTurnTimeout() {
        return this.turnTimeout;
    }

    public void onDisable() {
        for (GameRoom room : this.gameRooms.values()) {
            room.cleanup();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u53ea\u6709\u73a9\u5bb6\u624d\u80fd\u4f7f\u7528\u6b64\u547d\u4ee4\uff01");
            return true;
        }
        Player player = (Player)sender;
        if (command.getName().equals("landlord_action")) {
            GameRoom room;
            if (args.length > 0 && (room = this.playerRooms.get(player.getUniqueId())) != null) {
                room.handleActionCommand(player, args[0]);
            }
            return true;
        }
        if (args.length == 0) {
            this.openMainMenu(player);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "create": {
                this.createRoom(player, args);
                break;
            }
            case "join": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "\u8bf7\u8f93\u5165\u623f\u95f4\u53f7\uff01\u7528\u6cd5: /ddz join <\u623f\u95f4\u53f7>");
                    return true;
                }
                this.joinRoom(player, args[1]);
                break;
            }
            case "leave": {
                this.leaveRoom(player);
                break;
            }
            case "help": {
                this.sendHelpMessage(player);
                break;
            }
            case "ready": {
                this.toggleReady(player);
                break;
            }
            case "list": {
                if (args.length > 1) {
                    try {
                        int page = Integer.parseInt(args[1]);
                        player.setMetadata("landlord_page", (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)page));
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u9875\u7801\u5fc5\u987b\u662f\u6570\u5b57\uff01");
                    }
                }
                this.listRooms(player);
                break;
            }
            case "stats": {
                this.statsManager.showStats(player);
                break;
            }
            case "top": {
                this.showTopPlayers((CommandSender)player, args.length > 1 ? Integer.parseInt(args[1]) : 10);
                break;
            }
            case "money": {
                this.toggleMoneyGame(player);
                break;
            }
            default: {
                this.sendHelpMessage(player);
            }
        }
        return true;
    }

    private void toggleMoneyGame(Player player) {
        if (!this.bountyEnabled) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u91d1\u5e01\u8d5b\u529f\u80fd\u672a\u542f\u7528\uff01");
            return;
        }
        GameRoom room = this.playerRooms.get(player.getUniqueId());
        if (room == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u4e0d\u5728\u4efb\u4f55\u623f\u95f4\u4e2d\uff01");
            return;
        }
        room.toggleMoneyGame(player);
    }

    private void showTopPlayers(CommandSender sender, int topN) {
        int playerRank;
        Object playerName2;
        topN = Math.max(1, Math.min(topN, 100));
        ConfigurationSection playersSection = this.statsManager.getStatsConfig().getConfigurationSection("players");
        if (playersSection == null) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u6682\u65e0\u73a9\u5bb6\u7edf\u8ba1\u6570\u636e");
            return;
        }
        ArrayList<PlayerStatsData> statsList = new ArrayList<PlayerStatsData>();
        for (Object playerName2 : playersSection.getKeys(false)) {
            StatsManager.PlayerStats stats = this.statsManager.getPlayerStats((String)playerName2);
            double winRate = stats.getGamesPlayed() > 0 ? (double)stats.getGamesWon() / (double)stats.getGamesPlayed() * 100.0 : 0.0;
            statsList.add(new PlayerStatsData((String)playerName2, stats.getPoints(), stats.getGamesWon(), stats.getGamesLost(), stats.getNetMoney(), winRate));
        }
        if (statsList.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u6682\u65e0\u73a9\u5bb6\u7edf\u8ba1\u6570\u636e");
            return;
        }
        statsList.sort((a, b) -> Integer.compare(b.getPoints(), a.getPoints()));
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== \u6597\u5730\u4e3b\u6392\u884c\u699c TOP " + Math.min(topN, statsList.size()) + " ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + String.format("%-4s %-12s %-6s %-4s %-4s %-10s %-6s", "\u6392\u540d", "\u73a9\u5bb6\u540d\u79f0", "\u79ef\u5206", "\u80dc\u573a", "\u8d25\u573a", "\u51c0\u6536\u76ca", "\u80dc\u7387"));
        int rank = 1;
        playerName2 = statsList.iterator();
        while (playerName2.hasNext()) {
            PlayerStatsData data = (PlayerStatsData)playerName2.next();
            if (rank > topN) break;
            String rankColor = this.getRankColor(rank);
            sender.sendMessage(String.format("%s%-4d %s%-12s %s%-6d %s%-4d %s%-4d %s%-10.2f %s%.1f%%", rankColor, rank, ChatColor.AQUA, data.getPlayerName(), ChatColor.GOLD, data.getPoints(), ChatColor.GREEN, data.getWins(), ChatColor.RED, data.getLosses(), ChatColor.YELLOW, data.getNetMoney(), ChatColor.LIGHT_PURPLE, data.getWinRate()));
            ++rank;
        }
        if (sender instanceof Player && (playerRank = this.getPlayerRank(statsList, (String)(playerName2 = sender.getName()))) > 0 && playerRank > topN) {
            PlayerStatsData playerData = (PlayerStatsData)statsList.get(playerRank - 1);
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "\u4f60\u7684\u6392\u540d: " + playerRank + " (\u79ef\u5206: " + String.valueOf(ChatColor.GOLD) + playerData.getPoints() + String.valueOf(ChatColor.GRAY) + " \u80dc\u573a: " + String.valueOf(ChatColor.GREEN) + playerData.getWins() + String.valueOf(ChatColor.GRAY) + " \u8d25\u573a: " + String.valueOf(ChatColor.RED) + playerData.getLosses() + String.valueOf(ChatColor.GRAY) + " \u51c0\u6536\u76ca: " + String.valueOf(ChatColor.YELLOW) + String.format("%.2f", playerData.getNetMoney()) + String.valueOf(ChatColor.GRAY) + " \u80dc\u7387: " + String.valueOf(ChatColor.LIGHT_PURPLE) + String.format("%.1f%%", playerData.getWinRate()) + ")");
        }
    }

    private int getPlayerRank(List<PlayerStatsData> statsList, String playerName) {
        for (int i = 0; i < statsList.size(); ++i) {
            if (!statsList.get(i).getPlayerName().equals(playerName)) continue;
            return i + 1;
        }
        return -1;
    }

    private String getRankColor(int rank) {
        switch (rank) {
            case 1: {
                return ChatColor.GOLD.toString();
            }
            case 2: {
                return ChatColor.GRAY.toString();
            }
            case 3: {
                return ChatColor.RED.toString();
            }
        }
        return ChatColor.WHITE.toString();
    }

    private void sendHelpMessage(Player player) {
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "=== \u6597\u5730\u4e3b\u6e38\u620f\u5e2e\u52a9 ===");
        TextComponent maingui = new TextComponent(String.valueOf(ChatColor.YELLOW) + "/ddz - \u6253\u5f00\u4e3b\u83dc\u5355GUI");
        maingui.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u70b9\u51fb\u6253\u5f00\u4e3b\u83dc\u5355GUI").color(ChatColor.GRAY).create()));
        maingui.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/ddz "));
        player.spigot().sendMessage((BaseComponent)maingui);
        TextComponent createMsg = new TextComponent(String.valueOf(ChatColor.YELLOW) + "/ddz create <\u623f\u95f4\u53f7 \u53ef\u9009> - \u521b\u5efa\u623f\u95f4");
        createMsg.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u70b9\u51fb\u81ea\u52a8\u8f93\u5165\u521b\u5efa\u547d\u4ee4\n\u623f\u95f4\u53f7\u89c4\u5219: \u5b57\u6bcd/\u6570\u5b57/_-\uff0c\u957f\u5ea63-16").color(ChatColor.GRAY).create()));
        createMsg.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/ddz create "));
        player.spigot().sendMessage((BaseComponent)createMsg);
        TextComponent joinMsg = new TextComponent(String.valueOf(ChatColor.YELLOW) + "/ddz join <\u623f\u95f4\u53f7> - \u52a0\u5165\u623f\u95f4");
        joinMsg.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u70b9\u51fb\u81ea\u52a8\u8f93\u5165\u52a0\u5165\u547d\u4ee4\nTab\u952e\u53ef\u8865\u5168\u73b0\u6709\u623f\u95f4\u53f7").color(ChatColor.GRAY).create()));
        joinMsg.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/ddz join "));
        player.spigot().sendMessage((BaseComponent)joinMsg);
        TextComponent leaveMsg = new TextComponent(String.valueOf(ChatColor.YELLOW) + "/ddz leave - \u79bb\u5f00\u623f\u95f4");
        leaveMsg.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u70b9\u51fb\u7acb\u5373\u6267\u884c\u79bb\u5f00\u623f\u95f4\u547d\u4ee4").color(ChatColor.GRAY).create()));
        leaveMsg.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ddz leave"));
        player.spigot().sendMessage((BaseComponent)leaveMsg);
        TextComponent readyMsg = new TextComponent(String.valueOf(ChatColor.YELLOW) + "/ddz ready - \u51c6\u5907/\u53d6\u6d88\u51c6\u5907");
        readyMsg.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u70b9\u51fb\u7acb\u5373\u5207\u6362\u51c6\u5907\u72b6\u6001").color(ChatColor.GRAY).create()));
        readyMsg.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ddz ready"));
        player.spigot().sendMessage((BaseComponent)readyMsg);
        TextComponent listMsg = new TextComponent(String.valueOf(ChatColor.YELLOW) + "/ddz list - \u6253\u5f00\u623f\u95f4\u5217\u8868GUI");
        listMsg.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u70b9\u51fb\u7acb\u5373\u67e5\u770b\u6240\u6709\u53ef\u7528\u623f\u95f4").color(ChatColor.GRAY).create()));
        listMsg.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ddz list"));
        player.spigot().sendMessage((BaseComponent)listMsg);
        TextComponent statsMsg = new TextComponent(String.valueOf(ChatColor.YELLOW) + "/ddz stats - \u67e5\u770b\u4e2a\u4eba\u7edf\u8ba1");
        statsMsg.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u70b9\u51fb\u67e5\u770b\u4f60\u7684\u6e38\u620f\u7edf\u8ba1\u6570\u636e").color(ChatColor.GRAY).create()));
        statsMsg.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ddz stats"));
        player.spigot().sendMessage((BaseComponent)statsMsg);
        TextComponent topMsg = new TextComponent(String.valueOf(ChatColor.YELLOW) + "/ddz top [\u6570\u91cf] - \u67e5\u770b\u79ef\u5206\u6392\u884c\u699c");
        topMsg.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u70b9\u51fb\u67e5\u770b\u524d10\u540d\u73a9\u5bb6\n\u53ef\u6307\u5b9a\u6570\u91cf\u5982/ddz top 5").color(ChatColor.GRAY).create()));
        topMsg.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/ddz top 10"));
        player.spigot().sendMessage((BaseComponent)topMsg);
        if (this.bountyEnabled) {
            TextComponent moneyMsg = new TextComponent(String.valueOf(ChatColor.YELLOW) + "/ddz money - \u623f\u4e3b\u5f00\u5173\u91d1\u5e01\u8d5b");
            moneyMsg.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u70b9\u51fb\u5207\u6362\u91d1\u5e01\u8d5b\u6a21\u5f0f\n\u9700\u8981Vault\u7ecf\u6d4e\u7cfb\u7edf\u652f\u6301").color(ChatColor.GRAY).create()));
            moneyMsg.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ddz money"));
            player.spigot().sendMessage((BaseComponent)moneyMsg);
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (command.getName().equalsIgnoreCase("landlord")) {
            if (args.length == 1) {
                List<String> subCommands = Arrays.asList("create", "join", "leave", "ready", "list", "stats", "top", "help", "money", "help");
                for (String subCmd : subCommands) {
                    if (!subCmd.startsWith(args[0].toLowerCase())) continue;
                    completions.add(subCmd);
                }
            } else if (args.length == 2 && args[0].equalsIgnoreCase("create")) {
                completions.add("<\u623f\u95f4\u53f7\uff08\u53ef\u9009\uff09>");
                completions.add("\u89c4\u5219: \u5b57\u6bcd/\u6570\u5b57/_-\uff0c\u957f\u5ea63-16");
            } else if (args.length == 2 && args[0].equalsIgnoreCase("join")) {
                for (String roomId : this.gameRooms.keySet()) {
                    if (!roomId.startsWith(args[1])) continue;
                    completions.add(roomId);
                }
            } else if (args.length == 2 && args[0].equalsIgnoreCase("list")) {
                completions.add("<\u9875\u7801>");
            }
        }
        return completions;
    }

    private void createRoom(Player player, String[] args) {
        Object roomId;
        if (this.playerRooms.containsKey(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u5df2\u7ecf\u5728\u4e00\u4e2a\u623f\u95f4\u4e2d\u4e86\uff01");
            return;
        }
        if (args.length > 1) {
            roomId = args[1];
            if (!this.isValidRoomId((String)roomId)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "\u623f\u95f4\u53f7\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf(_)\u6216\u6a2a\u7ebf(-)\uff0c\u4e14\u957f\u5ea6\u4e3a3-16\u5b57\u7b26\uff01");
                return;
            }
            if (this.gameRooms.containsKey(roomId)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "\u623f\u95f4\u53f7\u5df2\u5b58\u5728\uff01");
                return;
            }
        } else {
            roomId = "room" + this.roomCounter++;
        }
        GameRoom room = new GameRoom((String)roomId, player, this);
        this.gameRooms.put((String)roomId, room);
        this.playerRooms.put(player.getUniqueId(), room);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u623f\u95f4\u521b\u5efa\u6210\u529f\uff01\u623f\u95f4\u53f7: " + (String)roomId);
        if (this.bountyEnabled) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u623f\u4e3b\u53ef\u8f93\u5165 /ddz money \u5f00\u5173\u91d1\u5e01\u8d5b");
        }
        room.addPlayer(player);
    }

    private boolean isValidRoomId(String roomId) {
        String regex = "^[a-zA-Z0-9_-]{3,16}$";
        return roomId.matches(regex);
    }

    private void joinRoom(Player player, String roomId) {
        long lastClick;
        long now = System.currentTimeMillis();
        if (this.lastJoinAttempt.containsKey(player.getUniqueId()) && now - (lastClick = this.lastJoinAttempt.get(player.getUniqueId()).longValue()) < 100L) {
            return;
        }
        this.lastJoinAttempt.put(player.getUniqueId(), now);
        GameRoom targetRoom = this.gameRooms.get(roomId);
        if (targetRoom.isMoneyGame() && this.isBountyEnabled()) {
            double required = this.getMoneyMultiplier();
            double playerBalance = this.getPlayerBalance(player);
            if (playerBalance < required) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "\u52a0\u5165\u5931\u8d25\uff01\u8be5\u623f\u95f4\u662f\u91d1\u5e01\u8d5b\uff0c\u9700\u8981\u81f3\u5c11 " + required + " \u91d1\u5e01\uff0c\u4f60\u5f53\u524d\u53ea\u6709 " + playerBalance + " \u91d1\u5e01");
                player.closeInventory();
                return;
            }
        }
        if (this.playerRooms.containsKey(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u5df2\u7ecf\u5728\u4e00\u4e2a\u623f\u95f4\u4e2d\u4e86\uff01");
            return;
        }
        GameRoom room = this.gameRooms.get(roomId);
        if (room == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u623f\u95f4\u4e0d\u5b58\u5728\uff01");
            return;
        }
        if (room.isGameStarted()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u6e38\u620f\u8fdb\u884c\u4e2d\uff0c\u65e0\u6cd5\u52a0\u5165\u623f\u95f4\uff01");
            return;
        }
        if (room.getPlayerCount() >= 3) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u623f\u95f4\u5df2\u6ee1\uff01");
            return;
        }
        this.playerRooms.put(player.getUniqueId(), room);
        room.addPlayer(player);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6210\u529f\u52a0\u5165\u623f\u95f4: " + roomId);
    }

    private void leaveRoom(Player player) {
        GameRoom room = this.playerRooms.get(player.getUniqueId());
        if (room == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u4e0d\u5728\u4efb\u4f55\u623f\u95f4\u4e2d\uff01");
            return;
        }
        if (room.isGameStarted()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u6e38\u620f\u8fdb\u884c\u4e2d\uff0c\u65e0\u6cd5\u79bb\u5f00\u623f\u95f4\uff01");
            return;
        }
        room.removePlayer(player);
        this.playerRooms.remove(player.getUniqueId());
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u5df2\u79bb\u5f00\u623f\u95f4");
        if (room.getPlayerCount() == 0) {
            this.gameRooms.remove(room.getRoomId());
        }
    }

    private void toggleReady(Player player) {
        GameRoom room = this.playerRooms.get(player.getUniqueId());
        if (room == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u4e0d\u5728\u4efb\u4f55\u623f\u95f4\u4e2d\uff01");
            return;
        }
        room.toggleReady(player);
    }

    private void listRooms(Player player) {
        if (this.playerRooms.containsKey(player.getUniqueId())) {
            GameRoom currentRoom = this.playerRooms.get(player.getUniqueId());
            Inventory confirmGui = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)(String.valueOf(ChatColor.RED) + "\u786e\u8ba4\u5207\u6362\u623f\u95f4?"));
            ItemStack confirm = new ItemStack(Material.GREEN_WOOL);
            ItemMeta confirmMeta = confirm.getItemMeta();
            confirmMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "\u786e\u8ba4\u5207\u6362");
            confirmMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "\u4f60\u5f53\u524d\u5728\u623f\u95f4: " + currentRoom.getRoomId(), String.valueOf(ChatColor.RED) + "\u5207\u6362\u623f\u95f4\u5c06\u81ea\u52a8\u79bb\u5f00\u5f53\u524d\u623f\u95f4"));
            confirm.setItemMeta(confirmMeta);
            confirmGui.setItem(11, confirm);
            ItemStack cancel = new ItemStack(Material.RED_WOOL);
            ItemMeta cancelMeta = cancel.getItemMeta();
            cancelMeta.setDisplayName(String.valueOf(ChatColor.RED) + "\u53d6\u6d88");
            cancel.setItemMeta(cancelMeta);
            confirmGui.setItem(15, cancel);
            player.openInventory(confirmGui);
        } else {
            this.openRoomListGUI(player, 1);
        }
    }

    private void openRoomListGUI(Player player, int page) {
        if (this.gameRooms.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u5f53\u524d\u6ca1\u6709\u623f\u95f4");
            player.closeInventory();
            return;
        }
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)(String.valueOf(ChatColor.GOLD) + "\u623f\u95f4\u5217\u8868 - \u7b2c " + page + " \u9875"));
        ArrayList<GameRoom> sortedRooms = new ArrayList<GameRoom>(this.gameRooms.values());
        sortedRooms.sort((r1, r2) -> {
            if (r1.isGameStarted() == r2.isGameStarted()) {
                return 0;
            }
            return r1.isGameStarted() ? 1 : -1;
        });
        int itemsPerPage = 45;
        int startIndex = (page - 1) * itemsPerPage;
        int endIndex = Math.min(startIndex + itemsPerPage, sortedRooms.size());
        for (int i = startIndex; i < endIndex; ++i) {
            GameRoom room = (GameRoom)sortedRooms.get(i);
            gui.setItem(i - startIndex, this.createRoomItem(player, room));
        }
        this.addPaginationButtons(gui, page, (int)Math.ceil((double)sortedRooms.size() / (double)itemsPerPage));
        player.openInventory(gui);
    }

    private ItemStack createRoomItem(Player viewer, GameRoom room) {
        if (room.isMoneyGame()) {
            double required;
            boolean hasEnough;
            double playerBalance = this.getPlayerBalance(viewer);
            boolean bl = hasEnough = playerBalance >= (required = (double)this.getMoneyMultiplier());
            Material material = hasEnough ? (room.isGameStarted() ? Material.GOLD_BLOCK : Material.EMERALD_BLOCK) : (room.isGameStarted() ? Material.REDSTONE_BLOCK : Material.COAL_BLOCK);
            ItemStack item = new ItemStack(material);
            ItemMeta meta = item.getItemMeta();
            if (hasEnough) {
                meta.addEnchant(Enchantment.VANISHING_CURSE, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            String status = room.isGameStarted() ? String.valueOf(ChatColor.RED) + "\u6e38\u620f\u4e2d(\u91d1\u5e01\u623f)" : String.valueOf(ChatColor.GREEN) + "\u7b49\u5f85\u4e2d(\u91d1\u5e01\u623f)";
            meta.setDisplayName(String.valueOf(hasEnough ? ChatColor.GOLD : ChatColor.GRAY) + room.getRoomId());
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add(String.valueOf(ChatColor.GRAY) + "\u72b6\u6001: " + status);
            lore.add(String.valueOf(ChatColor.GRAY) + "\u73a9\u5bb6: " + room.getPlayerCount() + "/3");
            lore.add(String.valueOf(ChatColor.GRAY) + "\u500d\u6570: " + room.getMultiplier());
            lore.add(String.valueOf(ChatColor.GOLD) + "\u91d1\u5e01\u8981\u6c42: " + required);
            lore.add(String.valueOf(ChatColor.YELLOW) + "\u6211\u7684\u91d1\u5e01: " + playerBalance + (hasEnough ? String.valueOf(ChatColor.GREEN) + " (\u6ee1\u8db3\u8981\u6c42)" : String.valueOf(ChatColor.RED) + " (\u4e0d\u6ee1\u8db3\u8981\u6c42)"));
            if (room.getRoomOwner() != null) {
                lore.add(String.valueOf(ChatColor.GRAY) + "\u623f\u4e3b: " + room.getRoomOwner().getName());
            }
            lore.add("");
            lore.add(hasEnough ? String.valueOf(ChatColor.YELLOW) + "\u70b9\u51fb\u52a0\u5165\u623f\u95f4" : String.valueOf(ChatColor.GRAY) + "\u91d1\u5e01\u4e0d\u8db3\u65e0\u6cd5\u52a0\u5165");
            meta.setLore(lore);
            item.setItemMeta(meta);
            return item;
        }
        Material material = room.isGameStarted() ? Material.RED_WOOL : Material.LIME_WOOL;
        ChatColor color = room.isGameStarted() ? ChatColor.RED : ChatColor.GREEN;
        String status = room.isGameStarted() ? "\u6e38\u620f\u4e2d" : "\u7b49\u5f85\u4e2d";
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(String.valueOf(color) + room.getRoomId());
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(String.valueOf(ChatColor.GRAY) + "\u72b6\u6001: " + String.valueOf(color) + status);
        lore.add(String.valueOf(ChatColor.GRAY) + "\u73a9\u5bb6: " + room.getPlayerCount() + "/3");
        if (room.getRoomOwner() != null) {
            lore.add(String.valueOf(ChatColor.GRAY) + "\u623f\u4e3b: " + room.getRoomOwner().getName());
        }
        lore.add("");
        lore.add(String.valueOf(ChatColor.YELLOW) + "\u70b9\u51fb\u52a0\u5165\u623f\u95f4");
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private void addPaginationButtons(Inventory gui, int currentPage, int totalPages) {
        if (currentPage > 1) {
            ItemStack prevPage = new ItemStack(Material.ARROW);
            ItemMeta prevMeta = prevPage.getItemMeta();
            prevMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "\u4e0a\u4e00\u9875");
            prevPage.setItemMeta(prevMeta);
            gui.setItem(48, prevPage);
        }
        ItemStack pageInfo = new ItemStack(Material.PAPER);
        ItemMeta pageMeta = pageInfo.getItemMeta();
        pageMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "\u7b2c " + currentPage + "/" + totalPages + " \u9875");
        pageInfo.setItemMeta(pageMeta);
        gui.setItem(49, pageInfo);
        if (currentPage < totalPages) {
            ItemStack nextPage = new ItemStack(Material.ARROW);
            ItemMeta nextMeta = nextPage.getItemMeta();
            nextMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "\u4e0b\u4e00\u9875");
            nextPage.setItemMeta(nextMeta);
            gui.setItem(50, nextPage);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        long lastClick;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory clickedInventory = event.getClickedInventory();
        String title = event.getView().getTitle();
        if (!(title.startsWith(String.valueOf(ChatColor.GOLD) + "\u6597\u5730\u4e3b\u4e3b\u83dc\u5355") || title.startsWith(String.valueOf(ChatColor.GOLD) + "\u623f\u95f4\u5217\u8868") || title.equals(String.valueOf(ChatColor.RED) + "\u786e\u8ba4\u5207\u6362\u623f\u95f4?"))) {
            return;
        }
        long now = System.currentTimeMillis();
        if (this.lastClickTimes.containsKey(player.getUniqueId()) && now - (lastClick = this.lastClickTimes.get(player.getUniqueId()).longValue()) < 100L) {
            event.setCancelled(true);
            return;
        }
        this.lastClickTimes.put(player.getUniqueId(), now);
        if (clickedInventory != event.getView().getTopInventory()) {
            event.setCancelled(true);
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        if (title.startsWith(String.valueOf(ChatColor.GOLD) + "\u6597\u5730\u4e3b\u4e3b\u83dc\u5355")) {
            this.handleMainMenuClick(player, clicked);
            return;
        }
        if (title.equals(String.valueOf(ChatColor.RED) + "\u786e\u8ba4\u5207\u6362\u623f\u95f4?")) {
            this.handleConfirmDialogClick(player, clicked);
            return;
        }
        if (title.startsWith(String.valueOf(ChatColor.GOLD) + "\u623f\u95f4\u5217\u8868")) {
            this.handleRoomListClick(player, clicked, title);
        }
    }

    private void handleConfirmDialogClick(Player player, ItemStack clicked) {
        GameRoom room = this.playerRooms.get(player.getUniqueId());
        if (room == null) {
            return;
        }
        if (room.isGameStarted()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u6e38\u620f\u8fdb\u884c\u4e2d\uff0c\u65e0\u6cd5\u79bb\u5f00\u623f\u95f4\uff01");
            return;
        }
        String displayName = clicked.getItemMeta().getDisplayName();
        if (displayName.equals(String.valueOf(ChatColor.GREEN) + "\u786e\u8ba4\u5207\u6362")) {
            GameRoom currentRoom = this.playerRooms.get(player.getUniqueId());
            if (currentRoom != null) {
                currentRoom.removePlayer(player);
                this.playerRooms.remove(player.getUniqueId());
                if (currentRoom.getPlayerCount() == 0) {
                    this.gameRooms.remove(currentRoom.getRoomId());
                }
            }
            this.openRoomListGUI(player, 1);
        } else if (displayName.equals(String.valueOf(ChatColor.RED) + "\u53d6\u6d88")) {
            player.closeInventory();
        }
    }

    private void handleRoomListClick(Player player, ItemStack clicked, String title) {
        String displayName = clicked.getItemMeta().getDisplayName();
        try {
            List lore;
            int currentPage = Integer.parseInt(ChatColor.stripColor((String)title.split(" - \u7b2c ")[1].split(" \u9875")[0]));
            if (displayName.equals(String.valueOf(ChatColor.YELLOW) + "\u4e0a\u4e00\u9875")) {
                this.openRoomListGUI(player, currentPage - 1);
                return;
            }
            if (displayName.equals(String.valueOf(ChatColor.YELLOW) + "\u4e0b\u4e00\u9875")) {
                this.openRoomListGUI(player, currentPage + 1);
                return;
            }
            if (clicked.getItemMeta().hasLore() && (lore = clicked.getItemMeta().getLore()).contains(String.valueOf(ChatColor.YELLOW) + "\u70b9\u51fb\u52a0\u5165\u623f\u95f4")) {
                String roomId = ChatColor.stripColor((String)displayName);
                this.joinRoomFromGUI(player, roomId);
            }
        }
        catch (Exception e) {
            this.getLogger().warning("\u5904\u7406GUI\u70b9\u51fb\u65f6\u51fa\u9519: " + e.getMessage());
        }
    }

    private void joinRoomFromGUI(Player player, String roomId) {
        GameRoom targetRoom = this.gameRooms.get(roomId);
        if (targetRoom == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u623f\u95f4\u4e0d\u5b58\u5728\u6216\u5df2\u5173\u95ed\uff01");
            return;
        }
        if (targetRoom.isMoneyGame() && this.isBountyEnabled()) {
            double required = this.getMoneyMultiplier();
            double playerBalance = this.getPlayerBalance(player);
            if (playerBalance < required) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "\u52a0\u5165\u5931\u8d25\uff01\u8be5\u623f\u95f4\u662f\u91d1\u5e01\u8d5b\uff0c\u9700\u8981\u81f3\u5c11 " + required + " \u91d1\u5e01\uff0c\u4f60\u5f53\u524d\u53ea\u6709 " + playerBalance + " \u91d1\u5e01");
                player.closeInventory();
                return;
            }
        }
        player.closeInventory();
        this.joinRoom(player, roomId);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        GameRoom room = this.playerRooms.get(player.getUniqueId());
        if (room != null) {
            room.removePlayer(player);
            if (!room.isGameStarted()) {
                this.playerRooms.remove(player.getUniqueId());
                if (room.getPlayerCount() == 0) {
                    this.gameRooms.remove(room.getRoomId());
                }
            }
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        String message;
        Player player = event.getPlayer();
        GameRoom room = this.playerRooms.get(player.getUniqueId());
        if (room != null && room.isGameStarted() && ((message = event.getMessage().toLowerCase()).equals("\u51fa\u724c") || message.equals("\u8fc7") || message.equals("\u62a2\u5730\u4e3b") || message.equals("\u4e0d\u62a2") || message.equals("\u6258\u7ba1") || message.equals("\u53d6\u6d88\u6258\u7ba1"))) {
            event.setCancelled(true);
            Bukkit.getScheduler().runTask((Plugin)this, () -> room.handleGameCommand(player, message));
        }
    }

    private void openMainMenu(Player player) {
        boolean isBiddingPhase;
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)(String.valueOf(ChatColor.GOLD) + "\u6597\u5730\u4e3b\u4e3b\u83dc\u5355"));
        ItemStack createRoom = new ItemStack(Material.OAK_SIGN);
        ItemMeta createMeta = createRoom.getItemMeta();
        createMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "\u521b\u5efa\u623f\u95f4");
        createMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "\u70b9\u51fb\u521b\u5efa\u4e00\u4e2a\u65b0\u7684\u6597\u5730\u4e3b\u623f\u95f4", String.valueOf(ChatColor.GRAY) + "\u53ef\u4ee5\u81ea\u5b9a\u4e49\u623f\u95f4\u53f7\u6216\u4f7f\u7528\u81ea\u52a8\u751f\u6210"));
        createRoom.setItemMeta(createMeta);
        gui.setItem(11, createRoom);
        GameRoom currentRoom = this.playerRooms.get(player.getUniqueId());
        boolean isInRoom = currentRoom != null;
        boolean isRoomOwner = isInRoom && currentRoom.getRoomOwner() != null && currentRoom.getRoomOwner().equals((Object)player);
        ItemStack moneyGame = new ItemStack(isRoomOwner && currentRoom != null && currentRoom.isMoneyGame() ? Material.GOLD_INGOT : Material.BARRIER);
        ItemMeta moneyMeta = moneyGame.getItemMeta();
        if (isInRoom) {
            moneyMeta.setDisplayName(isRoomOwner ? String.valueOf(ChatColor.GOLD) + "\u91d1\u5e01\u8d5b: " + (currentRoom.isMoneyGame() ? String.valueOf(ChatColor.GREEN) + "\u5df2\u5f00\u542f" : String.valueOf(ChatColor.RED) + "\u5df2\u5173\u95ed") : String.valueOf(ChatColor.GRAY) + "\u91d1\u5e01\u8d5b: \u4ec5\u623f\u4e3b\u53ef\u7528");
        } else {
            moneyMeta.setDisplayName(String.valueOf(ChatColor.RED) + "\u91d1\u5e01\u8d5b: \u672a\u5728\u623f\u95f4\u4e2d");
        }
        ArrayList<CallSite> moneyLore = new ArrayList<CallSite>();
        if (isRoomOwner) {
            moneyLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "\u5f53\u524d\u72b6\u6001: " + (currentRoom.isMoneyGame() ? String.valueOf(ChatColor.GREEN) + "\u5df2\u5f00\u542f" : String.valueOf(ChatColor.RED) + "\u5df2\u5173\u95ed"))));
            moneyLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "\u91d1\u5e01\u500d\u7387: " + this.getMoneyMultiplier())));
            moneyLore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "\u70b9\u51fb\u5207\u6362\u91d1\u5e01\u8d5b\u72b6\u6001")));
        } else if (isInRoom) {
            moneyLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "\u53ea\u6709\u623f\u4e3b\u53ef\u4ee5\u5f00\u5173\u91d1\u5e01\u8d5b")));
        } else {
            moneyLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "\u4f60\u9700\u8981\u5148\u52a0\u5165\u6216\u521b\u5efa\u4e00\u4e2a\u623f\u95f4")));
        }
        moneyMeta.setLore(moneyLore);
        moneyGame.setItemMeta(moneyMeta);
        gui.setItem(13, moneyGame);
        ItemStack roomList = new ItemStack(Material.BOOK);
        ItemMeta listMeta = roomList.getItemMeta();
        listMeta.setDisplayName(String.valueOf(ChatColor.BLUE) + "\u623f\u95f4\u5217\u8868");
        listMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "\u70b9\u51fb\u67e5\u770b\u6240\u6709\u53ef\u7528\u623f\u95f4", String.valueOf(ChatColor.GRAY) + "\u53ef\u4ee5\u52a0\u5165\u5176\u4ed6\u73a9\u5bb6\u7684\u623f\u95f4"));
        roomList.setItemMeta(listMeta);
        gui.setItem(15, roomList);
        ItemStack readyBtn = new ItemStack(currentRoom != null ? (currentRoom.getReadyStatus().getOrDefault(player.getUniqueId(), false).booleanValue() ? Material.LIME_DYE : Material.GRAY_DYE) : Material.BARRIER);
        ItemMeta readyMeta = readyBtn.getItemMeta();
        readyMeta.setDisplayName(currentRoom != null ? String.valueOf(ChatColor.YELLOW) + "\u51c6\u5907\u72b6\u6001: " + (currentRoom.getReadyStatus().getOrDefault(player.getUniqueId(), false) != false ? String.valueOf(ChatColor.GREEN) + "\u5df2\u51c6\u5907" : String.valueOf(ChatColor.RED) + "\u672a\u51c6\u5907") : String.valueOf(ChatColor.RED) + "\u4f60\u4e0d\u5728\u623f\u95f4\u4e2d");
        ArrayList<CallSite> readyLore = new ArrayList<CallSite>();
        if (currentRoom != null) {
            readyLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "\u5f53\u524d\u72b6\u6001: " + (currentRoom.getReadyStatus().getOrDefault(player.getUniqueId(), false) != false ? String.valueOf(ChatColor.GREEN) + "\u5df2\u51c6\u5907" : String.valueOf(ChatColor.RED) + "\u672a\u51c6\u5907"))));
            readyLore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "\u70b9\u51fb\u5207\u6362\u51c6\u5907\u72b6\u6001")));
        } else {
            readyLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "\u4f60\u9700\u8981\u5148\u52a0\u5165\u4e00\u4e2a\u623f\u95f4")));
        }
        readyMeta.setLore(readyLore);
        readyBtn.setItemMeta(readyMeta);
        gui.setItem(20, readyBtn);
        boolean bl = isBiddingPhase = currentRoom != null && currentRoom.getGameState() == GameRoom.GameState.BIDDING;
        ItemStack autoPlayBtn = new ItemStack(currentRoom != null && currentRoom.isGameStarted() && !isBiddingPhase ? (currentRoom.isAutoPlay(player) ? Material.REDSTONE_TORCH : Material.LEVER) : Material.BARRIER);
        ItemMeta autoMeta = autoPlayBtn.getItemMeta();
        autoMeta.setDisplayName(currentRoom != null && currentRoom.isGameStarted() && !isBiddingPhase ? String.valueOf(ChatColor.YELLOW) + "\u6258\u7ba1\u72b6\u6001: " + (currentRoom.isAutoPlay(player) ? String.valueOf(ChatColor.RED) + "\u5df2\u5f00\u542f" : String.valueOf(ChatColor.GREEN) + "\u5df2\u5173\u95ed") : (isBiddingPhase ? String.valueOf(ChatColor.RED) + "\u53eb\u5206\u9636\u6bb5\u4e0d\u53ef\u6258\u7ba1" : String.valueOf(ChatColor.RED) + "\u6e38\u620f\u672a\u5f00\u59cb"));
        ArrayList<CallSite> autoLore = new ArrayList<CallSite>();
        if (currentRoom != null && currentRoom.isGameStarted() && !isBiddingPhase) {
            autoLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "\u5f53\u524d\u72b6\u6001: " + (currentRoom.isAutoPlay(player) ? String.valueOf(ChatColor.RED) + "\u5df2\u5f00\u542f" : String.valueOf(ChatColor.GREEN) + "\u5df2\u5173\u95ed"))));
            autoLore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "\u70b9\u51fb\u5207\u6362\u6258\u7ba1\u72b6\u6001")));
            autoLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "\u6258\u7ba1\u72b6\u6001\u4e0b\u7cfb\u7edf\u4f1a\u81ea\u52a8\u51fa\u724c")));
        } else if (isBiddingPhase) {
            autoLore.add((CallSite)((Object)(String.valueOf(ChatColor.RED) + "\u53eb\u5206\u9636\u6bb5\u4e0d\u5141\u8bb8\u4f7f\u7528\u6258\u7ba1")));
        } else if (currentRoom != null) {
            autoLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "\u6e38\u620f\u5f00\u59cb\u540e\u624d\u80fd\u4f7f\u7528\u6258\u7ba1")));
        } else {
            autoLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "\u4f60\u9700\u8981\u5148\u52a0\u5165\u4e00\u4e2a\u623f\u95f4")));
        }
        autoMeta.setLore(autoLore);
        autoPlayBtn.setItemMeta(autoMeta);
        gui.setItem(22, autoPlayBtn);
        boolean canLeave = currentRoom != null && !currentRoom.isGameStarted();
        ItemStack leaveRoom = new ItemStack(canLeave ? Material.RED_BED : Material.BARRIER);
        ItemMeta leaveMeta = leaveRoom.getItemMeta();
        leaveMeta.setDisplayName(currentRoom != null ? (canLeave ? String.valueOf(ChatColor.RED) + "\u79bb\u5f00\u623f\u95f4" : String.valueOf(ChatColor.RED) + "\u6e38\u620f\u8fdb\u884c\u4e2d\u7981\u6b62\u79bb\u5f00") : String.valueOf(ChatColor.GRAY) + "\u4f60\u4e0d\u5728\u623f\u95f4\u4e2d");
        ArrayList<CallSite> leaveLore = new ArrayList<CallSite>();
        if (currentRoom != null) {
            leaveLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "\u5f53\u524d\u623f\u95f4: " + currentRoom.getRoomId())));
            if (canLeave) {
                leaveLore.add((CallSite)((Object)(String.valueOf(ChatColor.RED) + "\u70b9\u51fb\u79bb\u5f00\u5f53\u524d\u623f\u95f4")));
            } else {
                leaveLore.add((CallSite)((Object)(String.valueOf(ChatColor.RED) + "\u6e38\u620f\u8fdb\u884c\u4e2d\u65e0\u6cd5\u79bb\u5f00")));
            }
        } else {
            leaveLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "\u4f60\u9700\u8981\u5148\u52a0\u5165\u4e00\u4e2a\u623f\u95f4")));
        }
        leaveMeta.setLore(leaveLore);
        leaveRoom.setItemMeta(leaveMeta);
        gui.setItem(24, leaveRoom);
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        fillerMeta.setDisplayName(" ");
        filler.setItemMeta(fillerMeta);
        for (int i = 0; i < gui.getSize(); ++i) {
            if (gui.getItem(i) != null) continue;
            gui.setItem(i, filler);
        }
        player.openInventory(gui);
    }

    private void handleMainMenuClick(Player player, ItemStack clicked) {
        String displayName = clicked.getItemMeta().getDisplayName();
        if (displayName.contains("\u521b\u5efa\u623f\u95f4")) {
            player.closeInventory();
            player.performCommand("ddz create");
        } else if (displayName.contains("\u91d1\u5e01\u8d5b")) {
            GameRoom room = this.playerRooms.get(player.getUniqueId());
            if (room == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u4e0d\u5728\u4efb\u4f55\u623f\u95f4\u4e2d\uff01");
                return;
            }
            if (room.getRoomOwner() != null && room.getRoomOwner().equals((Object)player)) {
                room.toggleMoneyGame(player);
                this.openMainMenu(player);
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "\u53ea\u6709\u623f\u4e3b\u53ef\u4ee5\u5f00\u5173\u91d1\u5e01\u8d5b\uff01");
            }
        } else if (displayName.contains("\u623f\u95f4\u5217\u8868")) {
            player.closeInventory();
            player.performCommand("ddz list");
        } else if (displayName.contains("\u51c6\u5907\u72b6\u6001")) {
            GameRoom room = this.playerRooms.get(player.getUniqueId());
            if (room != null) {
                room.toggleReady(player);
                this.openMainMenu(player);
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u4e0d\u5728\u4efb\u4f55\u623f\u95f4\u4e2d\uff01");
            }
        } else if (displayName.contains("\u6258\u7ba1\u72b6\u6001")) {
            GameRoom room = this.playerRooms.get(player.getUniqueId());
            if (room == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u4e0d\u5728\u4efb\u4f55\u623f\u95f4\u4e2d\uff01");
                return;
            }
            if (room.getGameState() == GameRoom.GameState.BIDDING) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "\u53eb\u5206\u9636\u6bb5\u4e0d\u5141\u8bb8\u4f7f\u7528\u6258\u7ba1\uff01");
                return;
            }
            if (!room.isGameStarted()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "\u6e38\u620f\u672a\u5f00\u59cb\uff0c\u65e0\u6cd5\u4f7f\u7528\u6258\u7ba1\uff01");
                return;
            }
            room.toggleAutoPlay(player);
            this.openMainMenu(player);
        } else if (displayName.contains("\u79bb\u5f00\u623f\u95f4")) {
            GameRoom room = this.playerRooms.get(player.getUniqueId());
            if (room != null) {
                if (room.isGameStarted()) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "\u6e38\u620f\u8fdb\u884c\u4e2d\uff0c\u65e0\u6cd5\u79bb\u5f00\u623f\u95f4\uff01");
                } else {
                    player.closeInventory();
                    player.performCommand("ddz leave");
                }
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u4e0d\u5728\u4efb\u4f55\u623f\u95f4\u4e2d\uff01");
            }
        }
    }

    public void removePlayerFromRoom(UUID playerId) {
        GameRoom room = this.playerRooms.get(playerId);
        if (room != null) {
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player != null) {
                room.removePlayer(player);
            }
            this.playerRooms.remove(playerId);
        }
    }

    public StatsManager getStatsManager() {
        return this.statsManager;
    }

    public boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Deprecated
    public Object getEconomy() {
        if (!this.bountyEnabled) {
            return null;
        }
        return this.econ;
    }

    public boolean isBountyEnabled() {
        return this.bountyEnabled;
    }

    public int getMoneyMultiplier() {
        return this.moneyMultiplier;
    }

    public boolean isVaultAvailable() {
        return this.vaultAvailable;
    }

    private static class PlayerStatsData {
        private final String playerName;
        private final int wins;
        private final int losses;
        private final double netMoney;
        private final double winRate;
        private final int points;

        public PlayerStatsData(String playerName, int points, int wins, int losses, double netMoney, double winRate) {
            this.playerName = playerName;
            this.points = points;
            this.wins = wins;
            this.losses = losses;
            this.netMoney = netMoney;
            this.winRate = winRate;
        }

        public int getPoints() {
            return this.points;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public int getWins() {
            return this.wins;
        }

        public int getLosses() {
            return this.losses;
        }

        public double getNetMoney() {
            return this.netMoney;
        }

        public double getWinRate() {
            return this.winRate;
        }
    }
}

