/*
 * Decompiled with CFR 0.152.
 */
package cn.kurt6.landlord;

import cn.kurt6.landlord.Landlord;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class StatsManager {
    private final Landlord plugin;
    private final Map<UUID, PlayerStats> statsCache = new HashMap<UUID, PlayerStats>();
    private File statsFile;
    private YamlConfiguration statsConfig;

    public StatsManager(Landlord plugin) {
        this.plugin = plugin;
        this.loadStats();
    }

    private void loadStats() {
        this.statsFile = new File(this.plugin.getDataFolder(), "stats.yml");
        if (!this.statsFile.exists()) {
            this.plugin.saveResource("stats.yml", false);
        }
        this.statsConfig = YamlConfiguration.loadConfiguration((File)this.statsFile);
    }

    public void saveStats() {
        try {
            this.statsConfig.save(this.statsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("\u65e0\u6cd5\u4fdd\u5b58\u7edf\u8ba1\u6587\u4ef6: " + e.getMessage());
        }
    }

    public PlayerStats getPlayerStats(String playerName) {
        String path = "players." + playerName;
        if (!this.statsConfig.contains(path)) {
            return new PlayerStats();
        }
        return new PlayerStats(this.statsConfig.getInt(path + ".gamesPlayed"), this.statsConfig.getInt(path + ".gamesWon"), this.statsConfig.getInt(path + ".gamesLost"), this.statsConfig.getInt(path + ".points"), this.statsConfig.getDouble(path + ".netMoney", 0.0));
    }

    public void updatePlayerStats(String playerName, PlayerStats stats) {
        String path = "players." + playerName;
        this.statsConfig.set(path + ".gamesPlayed", (Object)stats.getGamesPlayed());
        this.statsConfig.set(path + ".gamesWon", (Object)stats.getGamesWon());
        this.statsConfig.set(path + ".gamesLost", (Object)stats.getGamesLost());
        this.statsConfig.set(path + ".points", (Object)stats.getPoints());
        this.statsConfig.set(path + ".netMoney", (Object)stats.getNetMoney());
        this.saveStats();
    }

    public void showStats(Player player) {
        PlayerStats stats = this.getPlayerStats(player.getName());
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "=== \u4f60\u7684\u6e38\u620f\u7edf\u8ba1 ===");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u603b\u6e38\u620f\u573a\u6b21: " + stats.getGamesPlayed());
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u80dc\u5229\u573a\u6b21: " + stats.getGamesWon());
        player.sendMessage(String.valueOf(ChatColor.RED) + "\u5931\u8d25\u573a\u6b21: " + stats.getGamesLost());
        player.sendMessage(String.valueOf(ChatColor.AQUA) + "\u5f53\u524d\u79ef\u5206: " + stats.getPoints());
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u51c0\u6536\u76ca\u91d1\u5e01: " + String.format("%.2f", stats.getNetMoney()));
        if (stats.getGamesPlayed() > 0) {
            int winRate = (int)((double)stats.getGamesWon() / (double)stats.getGamesPlayed() * 100.0);
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u80dc\u7387: " + winRate + "%");
        }
    }

    public YamlConfiguration getStatsConfig() {
        return this.statsConfig;
    }

    public static class PlayerStats {
        private int gamesPlayed;
        private int gamesWon;
        private int gamesLost;
        private int points;
        private double netMoney;

        public PlayerStats() {
        }

        public PlayerStats(int gamesPlayed, int gamesWon, int gamesLost, int points, double netMoney) {
            this.gamesPlayed = gamesPlayed;
            this.gamesWon = gamesWon;
            this.gamesLost = gamesLost;
            this.points = points;
            this.netMoney = netMoney;
        }

        public int getGamesPlayed() {
            return this.gamesPlayed;
        }

        public void incrementGamesPlayed() {
            ++this.gamesPlayed;
        }

        public int getGamesWon() {
            return this.gamesWon;
        }

        public void incrementGamesWon() {
            ++this.gamesWon;
        }

        public int getGamesLost() {
            return this.gamesLost;
        }

        public void incrementGamesLost() {
            ++this.gamesLost;
        }

        public int getPoints() {
            return this.points;
        }

        public void addPoints(int amount) {
            this.points += amount;
        }

        public double getNetMoney() {
            return this.netMoney;
        }

        public void addNetMoney(double amount) {
            this.netMoney += amount;
        }
    }
}

