/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.homePlugin;

import de.scholle.homePlugin.HomePlugin;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class HomeCommand
implements CommandExecutor {
    private final HomePlugin plugin;

    public HomeCommand(HomePlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        String name = args.length > 0 ? args[0].toLowerCase() : "";
        Location home = this.plugin.getHome(player, name);
        if (home == null) {
            player.sendMessage(ChatColor.RED + "That home does not exist!");
            return true;
        }
        if (!this.plugin.isSafe(home)) {
            this.plugin.sendActionBar(player, "Area is unsafe!");
            return true;
        }
        player.teleport(home);
        player.sendMessage(ChatColor.GREEN + "Teleported to your home " + (String)(name.isEmpty() ? "" : "'" + name + "'") + "!");
        return true;
    }
}

