/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.homePlugin;

import de.scholle.homePlugin.DelHomeCommand;
import de.scholle.homePlugin.HomeCommand;
import de.scholle.homePlugin.Placeholder;
import de.scholle.homePlugin.SetHomeCommand;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class HomePlugin
extends JavaPlugin {
    private static HomePlugin instance;
    private File homesFile;
    private FileConfiguration homesConfig;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.createHomesFile();
        this.getCommand("sethome").setExecutor((CommandExecutor)new SetHomeCommand(this));
        this.getCommand("home").setExecutor((CommandExecutor)new HomeCommand(this));
        this.getCommand("delhome").setExecutor((CommandExecutor)new DelHomeCommand(this));
        this.getLogger().info("HomePlugin enabled!");
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new Placeholder(this).register();
        }
    }

    public void onDisable() {
        this.saveHomesFile();
    }

    public static HomePlugin getInstance() {
        return instance;
    }

    private void createHomesFile() {
        this.homesFile = new File(this.getDataFolder(), "homes.yml");
        if (!this.homesFile.exists()) {
            this.homesFile.getParentFile().mkdirs();
            try {
                this.homesFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.homesConfig = new YamlConfiguration();
        try {
            this.homesConfig.load(this.homesFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration getHomesConfig() {
        return this.homesConfig;
    }

    public void saveHomesFile() {
        try {
            this.homesConfig.save(this.homesFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setHome(Player player, String name, Location location) {
        if (name == null || name.isEmpty()) {
            name = "default";
        }
        String basePath = "homes." + player.getUniqueId();
        this.homesConfig.set(basePath + "." + name + ".world", (Object)location.getWorld().getName());
        this.homesConfig.set(basePath + "." + name + ".x", (Object)location.getX());
        this.homesConfig.set(basePath + "." + name + ".y", (Object)location.getY());
        this.homesConfig.set(basePath + "." + name + ".z", (Object)location.getZ());
        this.homesConfig.set(basePath + "." + name + ".yaw", (Object)Float.valueOf(location.getYaw()));
        this.homesConfig.set(basePath + "." + name + ".pitch", (Object)Float.valueOf(location.getPitch()));
        this.saveHomesFile();
    }

    public Location getHome(Player player, String name) {
        String path;
        if (name == null || name.isEmpty()) {
            name = "default";
        }
        if (!this.homesConfig.contains(path = "homes." + player.getUniqueId() + "." + name)) {
            return null;
        }
        String world = this.homesConfig.getString(path + ".world");
        double x = this.homesConfig.getDouble(path + ".x");
        double y = this.homesConfig.getDouble(path + ".y");
        double z = this.homesConfig.getDouble(path + ".z");
        float yaw = (float)this.homesConfig.getDouble(path + ".yaw");
        float pitch = (float)this.homesConfig.getDouble(path + ".pitch");
        return new Location(Bukkit.getWorld((String)world), x, y, z, yaw, pitch);
    }

    public void deleteHome(Player player, String name) {
        if (name == null || name.isEmpty()) {
            name = "default";
        }
        this.homesConfig.set("homes." + player.getUniqueId() + "." + name, null);
        this.saveHomesFile();
    }

    public Set<String> getHomeNames(Player player) {
        String path = "homes." + player.getUniqueId();
        if (this.homesConfig.contains(path)) {
            return this.homesConfig.getConfigurationSection(path).getKeys(false);
        }
        return null;
    }

    public int getMaxHomes(Player player) {
        FileConfiguration cfg = this.getConfig();
        int defaultLimit = cfg.getInt("default-home-limit", 1);
        if (cfg.isConfigurationSection("rank-limits")) {
            for (String group : cfg.getConfigurationSection("rank-limits").getKeys(false)) {
                if (!player.hasPermission("betterhome.group." + group.toLowerCase())) continue;
                return cfg.getInt("rank-limits." + group);
            }
        }
        return defaultLimit;
    }

    public boolean isSafe(Location loc) {
        if (loc == null || loc.getWorld() == null) {
            return false;
        }
        Material feet = loc.getBlock().getType();
        Material head = loc.clone().add(0.0, 1.0, 0.0).getBlock().getType();
        Material ground = loc.clone().add(0.0, -1.0, 0.0).getBlock().getType();
        return ground.isSolid() && !feet.isSolid() && !head.isSolid();
    }

    public void sendActionBar(final Player player, final String message) {
        new BukkitRunnable(){

            public void run() {
                player.sendActionBar(ChatColor.RED + message);
            }
        }.runTask((Plugin)this);
    }
}

