/*
 * Decompiled with CFR 0.152.
 */
package dev.sygii.realpain;

import com.google.gson.JsonObject;
import dev.sygii.realpain.Creator;
import dev.sygii.realpain.PainAttachments;
import dev.sygii.realpain.body.damage.DamageDistribution;
import dev.sygii.realpain.body.damage.distribution.RandomAllDamageDistribution;
import dev.sygii.realpain.body.damage.distribution.RandomDamageDistribution;
import dev.sygii.realpain.body.damage.distribution.SplitAllDamageDistribution;
import dev.sygii.realpain.body.damage.distribution.SplitDamageDistribution;
import dev.sygii.realpain.body.entity.PlayerBody;
import dev.sygii.realpain.config.MainConfig;
import dev.sygii.realpain.content.MorphineCriterion;
import dev.sygii.realpain.content.OverdoseCriterion;
import dev.sygii.realpain.content.effect.MorphineStatusEffect;
import dev.sygii.realpain.content.effect.OverdoseStatusEffect;
import dev.sygii.realpain.content.item.BandageItem;
import dev.sygii.realpain.content.item.MedkitItem;
import dev.sygii.realpain.content.item.MorphineItem;
import dev.sygii.realpain.data.DamageDistributionLoader;
import java.util.ArrayList;
import java.util.List;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_174;
import net.minecraft.class_1761;
import net.minecraft.class_179;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_4174;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PainMain
implements ModInitializer {
    public static final String MOD_ID = "realpain";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"realpain");
    public static final List<DamageDistribution> damageDistributionMap = new ArrayList<DamageDistribution>();
    public static final Creator<JsonObject, DamageDistribution> damageDistributionCreator = new Creator();
    public static MainConfig MAIN = (MainConfig)ConfigApiJava.registerAndLoadConfig(MainConfig::new);
    public static final class_5321<class_1761> PAIN_GROUP = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)PainMain.id("items"));
    public static final class_1792 MORPHINE_ITEM = new MorphineItem((class_1792.class_1793)new FabricItemSettings());
    public static final class_1792 BANDAGE_ITEM = new BandageItem((class_1792.class_1793)new FabricItemSettings());
    public static final class_1792 MEDICINAL_HERB = new class_1792(new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(1).method_19237(0.1f).method_19241().method_19240().method_19242()));
    public static final class_1792 MEDKIT_ITEM = new MedkitItem((class_1792.class_1793)new FabricItemSettings().maxCount(1));
    public static final class_1291 MORPHINE_EFFECT = new MorphineStatusEffect();
    public static final class_1291 OVERDOSE_EFFECT = new OverdoseStatusEffect();
    public static final OverdoseCriterion OVERDOSE_CRITERION = (OverdoseCriterion)class_174.method_767((class_179)new OverdoseCriterion());
    public static final MorphineCriterion MORPHINE_CRITERION = (MorphineCriterion)class_174.method_767((class_179)new MorphineCriterion());
    public static final class_5321<class_8110> OVERDOSE_DAMAGE_TYPE = class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)PainMain.id("overdose"));

    public static class_1282 of(class_1937 world, class_5321<class_8110> key) {
        return new class_1282((class_6880)world.method_30349().method_30530(class_7924.field_42534).method_40290(key));
    }

    public void onInitialize() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new DamageDistributionLoader());
        class_2378.method_39197((class_2378)class_7923.field_44687, PAIN_GROUP, (Object)FabricItemGroup.builder().method_47320(() -> new class_1799((class_1935)MORPHINE_ITEM)).method_47321((class_2561)class_2561.method_43471((String)"realpain.items")).method_47317((features, entries) -> {
            entries.method_45421((class_1935)MORPHINE_ITEM);
            entries.method_45421((class_1935)BANDAGE_ITEM);
            entries.method_45421((class_1935)MEDICINAL_HERB);
            entries.method_45421((class_1935)MEDKIT_ITEM);
        }).method_47324());
        damageDistributionCreator.registerCreator(SplitDamageDistribution.ID, data -> new SplitDamageDistribution());
        damageDistributionCreator.registerCreator(RandomDamageDistribution.ID, data -> new RandomDamageDistribution());
        damageDistributionCreator.registerCreator(RandomAllDamageDistribution.ID, data -> new RandomAllDamageDistribution());
        damageDistributionCreator.registerCreator(SplitAllDamageDistribution.ID, data -> new SplitAllDamageDistribution());
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)PainMain.id("morphine"), (Object)MORPHINE_ITEM);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)PainMain.id("bandage"), (Object)BANDAGE_ITEM);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)PainMain.id("medicinal_herb"), (Object)MEDICINAL_HERB);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)PainMain.id("medkit"), (Object)MEDKIT_ITEM);
        class_2378.method_10230((class_2378)class_7923.field_41174, (class_2960)PainMain.id("morphine"), (Object)MORPHINE_EFFECT);
        class_2378.method_10230((class_2378)class_7923.field_41174, (class_2960)PainMain.id("overdosed"), (Object)OVERDOSE_EFFECT);
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            PlayerBody body = (PlayerBody)PainAttachments.body.get((Object)newPlayer);
            PainAttachments.body.syncFromServer(newPlayer, (Object)newPlayer, (Object)body);
        });
    }

    public static void log(String s) {
        if (PainMain.MAIN.debugLogging) {
            LOGGER.info(s);
        }
    }

    public static class_2960 id(String path) {
        return class_2960.method_43902((String)MOD_ID, (String)path);
    }

    public static int incrementEffect(class_1309 entity, class_1291 effect, int duration) {
        int overdoseAmp = 0;
        if (entity.method_6059(effect)) {
            overdoseAmp = entity.method_6112(effect).method_5578() + 1;
        }
        entity.method_6092(new class_1293(effect, duration, overdoseAmp));
        return overdoseAmp;
    }

    public static int incrementEffect(class_1309 entity, class_1291 effect, int duration, int overdoseAmp) {
        if (overdoseAmp >= 0) {
            if (entity.method_6059(effect)) {
                overdoseAmp += entity.method_6112(effect).method_5578() + 1;
                if (entity.method_6112(effect).method_5584() < 5) {
                    entity.method_6092(new class_1293(effect, duration, overdoseAmp));
                }
            } else {
                entity.method_6092(new class_1293(effect, duration, overdoseAmp));
            }
            return overdoseAmp;
        }
        return 0;
    }
}

