/*
 * Decompiled with CFR 0.152.
 */
package dev.sygii.realpain.body.entity;

import dev.sygii.realpain.PainMain;
import dev.sygii.realpain.body.Body;
import dev.sygii.realpain.body.BodyPart;
import dev.sygii.realpain.body.parts.Arm;
import dev.sygii.realpain.body.parts.Head;
import dev.sygii.realpain.body.parts.Leg;
import dev.sygii.realpain.body.parts.Torso;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class PlayerBody
extends Body {
    public PlayerBody(class_1657 entity) {
        super((class_1309)entity);
        this.addBodyPart(PainMain.id("torso"), new Torso((class_1309)entity));
        this.addBodyPart(PainMain.id("head"), new Head((class_1309)entity).setParent(this.getPart(PainMain.id("torso"))));
        this.addBodyPart(PainMain.id("left_arm"), new Arm((class_1309)entity, BodyPart.BodySide.LEFT).setParent(this.getPart(PainMain.id("torso"))));
        this.addBodyPart(PainMain.id("right_arm"), new Arm((class_1309)entity, BodyPart.BodySide.RIGHT).setParent(this.getPart(PainMain.id("torso"))));
        this.addBodyPart(PainMain.id("left_leg"), new Leg((class_1309)entity, BodyPart.BodySide.LEFT).setParent(this.getPart(PainMain.id("torso"))));
        this.addBodyPart(PainMain.id("right_leg"), new Leg((class_1309)entity, BodyPart.BodySide.RIGHT).setParent(this.getPart(PainMain.id("torso"))));
        this.addSlotPart(class_1304.field_6174, PainMain.id("torso"));
        this.addSlotPart(class_1304.field_6174, PainMain.id("left_arm"));
        this.addSlotPart(class_1304.field_6174, PainMain.id("right_arm"));
        this.addSlotPart(class_1304.field_6169, PainMain.id("head"));
        this.addSlotPart(class_1304.field_6172, PainMain.id("left_leg"));
        this.addSlotPart(class_1304.field_6172, PainMain.id("right_leg"));
        this.addSlotPart(class_1304.field_6166, PainMain.id("left_leg"));
        this.addSlotPart(class_1304.field_6166, PainMain.id("right_leg"));
        this.addTickedDebuff(PainMain.id("torso"), class_1294.field_5911, 40, part -> {
            if (part.getPartHealth() <= part.getPartMaxHealth() * 0.25f) {
                return 1;
            }
            return 0;
        });
        this.addTickedDebuff(PainMain.id("head"), class_1294.field_5911, 40, part -> {
            if (part.getPartHealth() <= part.getPartMaxHealth() * 0.25f) {
                return 1;
            }
            return 0;
        });
        this.addTickedDebuff(PainMain.id("head"), class_1294.field_5916, 1000, part -> {
            if (part.getPartHealth() <= part.getPartMaxHealth() * 0.15f) {
                return 1;
            }
            return 0;
        });
        this.addTickedDebuff(PainMain.id("right_leg"), class_1294.field_5909, 40, part -> {
            if (part.getPartHealth() <= part.getPartMaxHealth() * 0.25f) {
                return 2;
            }
            if (part.getPartHealth() <= part.getPartMaxHealth() * 0.5f) {
                return 1;
            }
            return 0;
        });
        this.addTickedDebuff(PainMain.id("left_leg"), class_1294.field_5909, 40, part -> {
            if (part.getPartHealth() <= part.getPartMaxHealth() * 0.25f) {
                return 2;
            }
            if (part.getPartHealth() <= part.getPartMaxHealth() * 0.5f) {
                return 1;
            }
            return 0;
        });
        this.addTickedDebuff(PainMain.id("right_arm"), class_1294.field_5901, 40, part -> {
            if (part.getPartHealth() <= part.getPartMaxHealth() * 0.25f) {
                return 2;
            }
            if (part.getPartHealth() <= part.getPartMaxHealth() * 0.5f) {
                return 1;
            }
            return 0;
        });
        this.addTickedDebuff(PainMain.id("left_arm"), class_1294.field_5901, 40, part -> {
            if (part.getPartHealth() <= part.getPartMaxHealth() * 0.25f) {
                return 2;
            }
            if (part.getPartHealth() <= part.getPartMaxHealth() * 0.5f) {
                return 1;
            }
            return 0;
        });
        this.initBodyParts();
    }

    @Override
    public void applyHealing(float amount) {
        if (amount > 0.0f) {
            this.getPart(PainMain.id("torso")).heal(amount);
        }
    }

    @Override
    public void tick() {
        class_1309 class_13092;
        if (this.entity != null && (class_13092 = this.entity) instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)class_13092;
            if (serverPlayerEntity.field_13974.method_14257().method_8388()) {
                int morphineAmount = this.entity.method_6059(PainMain.MORPHINE_EFFECT) ? this.entity.method_6112(PainMain.MORPHINE_EFFECT).method_5578() + 2 : 1;
                this.debuffs.forEach((effect, debuffs) -> {
                    AtomicInteger amplifier = new AtomicInteger(-morphineAmount);
                    AtomicInteger duration = new AtomicInteger(0);
                    debuffs.forEach(debuff -> {
                        amplifier.getAndAdd(debuff.runner().run(debuff.part()));
                        duration.getAndAdd(debuff.duration());
                    });
                    this.applyStatusEffectWithAmplifier((class_1291)effect, duration.get(), amplifier.get());
                });
            }
        }
    }

    public void applyStatusEffectWithAmplifier(class_1291 effect, int duration, int amplifier) {
        if (amplifier >= 0) {
            class_1293 s = this.entity.method_6112(effect);
            if (s == null) {
                this.entity.method_6092(new class_1293(effect, duration, amplifier));
            } else if (s.method_5584() <= 5 || s.method_5578() != amplifier) {
                this.entity.method_6092(new class_1293(effect, duration, amplifier));
            }
        }
    }

    public int getAmplifier(BodyPart part) {
        float threshold1 = part.getPartMaxHealth() * 0.75f;
        float threshold2 = part.getPartMaxHealth() * 0.5f;
        float threshold3 = part.getPartMaxHealth() * 0.25f;
        if (part.getPartHealth() <= threshold3) {
            return 3;
        }
        if (part.getPartHealth() <= threshold2) {
            return 2;
        }
        if (part.getPartHealth() <= threshold1) {
            return 1;
        }
        return 0;
    }
}

