/*
 * Decompiled with CFR 0.152.
 */
package dev.sygii.realpain.mixin;

import dev.sygii.realpain.PainAttachments;
import dev.sygii.realpain.PainMain;
import dev.sygii.realpain.body.BodyPart;
import dev.sygii.realpain.body.damage.DamageDistribution;
import dev.sygii.realpain.body.entity.PlayerBody;
import java.util.ArrayList;
import net.minecraft.class_1280;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_8103;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Debug(export=true)
@Mixin(value={class_1309.class})
public class LivingEntityMixin {
    class_1309 entity = (class_1309)this;
    @Unique
    boolean shouldKillAfterOverdose = false;

    @Inject(method={"applyArmorToDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleArmor(class_1282 source, float amount, CallbackInfoReturnable<Float> cir) {
        class_1309 class_13092 = this.entity;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (!source.method_48789(class_8103.field_42241)) {
                PlayerBody body = (PlayerBody)PainAttachments.body.get((Object)this.entity);
                DamageDistribution dist = body.get();
                int[] slots = new int[]{0, 1, 2, 3};
                double armor = this.entity.method_26825(class_5134.field_23724);
                double toughness = this.entity.method_26825(class_5134.field_23725);
                for (int slot : slots) {
                    class_1792 class_17922 = player.method_31548().method_7372(slot).method_7909();
                    if (!(class_17922 instanceof class_1738)) continue;
                    class_1738 armorItem = (class_1738)class_17922;
                    armor -= (double)armorItem.method_7687();
                    toughness -= (double)armorItem.method_26353();
                }
                ArrayList<class_1304> slotsToScan = new ArrayList<class_1304>();
                for (BodyPart part : dist.getRealParts()) {
                    for (class_1304 slot : part.activeSlots) {
                        if (slotsToScan.contains(slot)) continue;
                        slotsToScan.add(slot);
                    }
                }
                for (class_1304 slot : slotsToScan) {
                    class_1792 class_17923 = player.method_31548().method_7372(slot.method_5927()).method_7909();
                    if (!(class_17923 instanceof class_1738)) continue;
                    class_1738 armorItem = (class_1738)class_17923;
                    player.method_31548().method_7375(source, amount, new int[]{slot.method_5927()});
                    if (slot.equals((Object)class_1304.field_6169)) {
                        armor += (double)((float)armorItem.method_7687() * ((Float)PainMain.MAIN.PARTS.headArmorPadding.get()).floatValue());
                        toughness += (double)(armorItem.method_26353() * ((Float)PainMain.MAIN.PARTS.headToughnessPadding.get()).floatValue());
                        PainMain.log("Adding " + (float)armorItem.method_7687() * ((Float)PainMain.MAIN.PARTS.headArmorPadding.get()).floatValue() + "a " + armorItem.method_26353() * ((Float)PainMain.MAIN.PARTS.headToughnessPadding.get()).floatValue() + "t  padding for head");
                    }
                    armor += (double)armorItem.method_7687();
                    toughness += (double)armorItem.method_26353();
                    PainMain.log("Adding needed " + armorItem.method_7687() + " | " + armorItem.method_26353());
                }
                float damageLeft = class_1280.method_5496((float)amount, (float)((float)armor), (float)((float)toughness));
                PainMain.log("Getting leftover damage with: " + armor + "a " + toughness + "t | " + amount + " -> " + damageLeft);
                cir.setReturnValue((Object)Float.valueOf(damageLeft));
            }
        }
    }

    @ModifyVariable(method={"setHealth"}, at=@At(value="HEAD"), argsOnly=true)
    private float handleHealth(float value) {
        class_1657 player;
        float oldHealth = this.entity.method_6032();
        class_1309 class_13092 = this.entity;
        if (class_13092 instanceof class_1657 && (player = (class_1657)class_13092) instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)player;
            PainMain.log("Setting Health: " + value);
            if (PainAttachments.body.get((Object)serverPlayerEntity) != null) {
                if (((PlayerBody)PainAttachments.body.get((Object)serverPlayerEntity)).newlyLoaded) {
                    PainMain.log("Just loaded");
                    ((PlayerBody)PainAttachments.body.get((Object)serverPlayerEntity)).newlyLoaded = false;
                } else if (oldHealth < value) {
                    float amount = value - oldHealth;
                    PainMain.log("Healing: " + amount);
                    ((PlayerBody)PainAttachments.body.get((Object)serverPlayerEntity)).applyHealing(amount);
                } else if (value < oldHealth && value > 0.0f && ((PlayerBody)PainAttachments.body.get((Object)this.entity)).hasBeenDamaged) {
                    float amount = oldHealth - value;
                    PainMain.log("Damaging: " + amount);
                    value = ((PlayerBody)PainAttachments.body.get((Object)this.entity)).applyDamage(value, amount);
                }
                if (serverPlayerEntity.field_13987 != null) {
                    PainMain.log("Syncing Health");
                    PlayerBody body = (PlayerBody)PainAttachments.body.get((Object)serverPlayerEntity);
                    PainAttachments.body.syncFromServer(serverPlayerEntity, (Object)this.entity, (Object)body);
                }
            }
        }
        return value;
    }

    @ModifyArg(method={"clearStatusEffects"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;onStatusEffectRemoved(Lnet/minecraft/entity/effect/StatusEffectInstance;)V"))
    private class_1293 handleOverdoseRemoval(class_1293 effect) {
        if (effect.method_5579().equals(PainMain.OVERDOSE_EFFECT)) {
            this.shouldKillAfterOverdose = true;
        }
        return effect;
    }

    @Inject(method={"clearStatusEffects"}, at={@At(value="TAIL")})
    private void handleOverdoseRemoval2(CallbackInfoReturnable<Boolean> cir) {
        if (this.shouldKillAfterOverdose) {
            this.entity.method_5643(PainMain.of(this.entity.method_37908(), PainMain.OVERDOSE_DAMAGE_TYPE), Float.MAX_VALUE);
            this.shouldKillAfterOverdose = false;
        }
    }
}

