/*
 * Decompiled with CFR 0.152.
 */
package dev.sygii.realpain.util;

import dev.sygii.realpain.util.AABBAlignedBoundingBox;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1366;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;

public class PlayerSizeHelper {
    private static final Map<class_1304, AABBAlignedBoundingBox> NORMAL_BOXES;
    private static final Map<class_1304, AABBAlignedBoundingBox> SNEAKING_BOXES;

    public static Map<class_1304, AABBAlignedBoundingBox> getBoxes(class_1297 entity) {
        switch (entity.method_18376()) {
            case field_18076: {
                return NORMAL_BOXES;
            }
            case field_18081: {
                return SNEAKING_BOXES;
            }
            case field_18080: 
            case field_18077: {
                return Collections.emptyMap();
            }
        }
        return Collections.emptyMap();
    }

    public static class_1304 getSlotTypeForProjectileHit(class_1297 hittingObject, class_1657 toTest) {
        float[] inflationSteps;
        Map<class_1304, AABBAlignedBoundingBox> toUse = PlayerSizeHelper.getBoxes((class_1297)toTest);
        class_243 oldPosition = hittingObject.method_19538();
        class_243 newPosition = oldPosition.method_1019(hittingObject.method_18798());
        for (float inflation : inflationSteps = new float[]{0.01f, 0.1f, 0.2f, 0.3f}) {
            class_1304 bestSlot = null;
            double bestValue = Double.MAX_VALUE;
            for (Map.Entry<class_1304, AABBAlignedBoundingBox> entry : toUse.entrySet()) {
                double d2;
                double d1;
                class_238 axisalignedbb = entry.getValue().createAABB(toTest.method_5829()).method_1014((double)inflation);
                Optional optional = axisalignedbb.method_992(oldPosition, newPosition);
                if (!optional.isPresent() || !((d1 = oldPosition.method_1025((class_243)optional.get())) + (d2 = 0.0) < bestValue)) continue;
                bestSlot = entry.getKey();
                bestValue = d1 + d2;
            }
            if (bestSlot == null) continue;
            return bestSlot;
        }
        return null;
    }

    public static List<class_1304> getMeleeDistribution(class_1657 player, class_1282 source) {
        Map<class_1304, AABBAlignedBoundingBox> boxes;
        class_1308 mobEntity;
        class_1297 causingEntity = source.method_5529();
        if (causingEntity != null && causingEntity == source.method_5526() && causingEntity instanceof class_1308 && (mobEntity = (class_1308)causingEntity).method_5968() == player && mobEntity.field_6201.method_19048().anyMatch(prioritizedGoal -> prioritizedGoal.method_19058() instanceof class_1366) && !(boxes = PlayerSizeHelper.getBoxes((class_1297)player)).isEmpty()) {
            ArrayList<class_1304> allowedParts = new ArrayList<class_1304>();
            class_238 modAABB = mobEntity.method_5829().method_1009((double)(mobEntity.method_17681() * 2.0f + player.method_17681()), 0.0, (double)(mobEntity.method_17681() * 2.0f + player.method_17681()));
            for (Map.Entry<class_1304, AABBAlignedBoundingBox> entry : boxes.entrySet()) {
                class_238 partAABB = entry.getValue().createAABB(player.method_5829());
                if (!modAABB.method_994(partAABB)) continue;
                allowedParts.add(entry.getKey());
            }
            if (allowedParts.isEmpty() && player.method_23318() > mobEntity.method_23318() && player.method_23318() - mobEntity.method_23318() < (double)(mobEntity.method_17682() * 2.0f)) {
                allowedParts.add(class_1304.field_6166);
            }
            if (!allowedParts.isEmpty()) {
                return allowedParts;
            }
        }
        return null;
    }

    static {
        LinkedHashMap<class_1304, AABBAlignedBoundingBox> builder = new LinkedHashMap<class_1304, AABBAlignedBoundingBox>();
        builder.put(class_1304.field_6166, new AABBAlignedBoundingBox(0.0, 0.0, 0.0, 1.0, 0.15, 1.0));
        builder.put(class_1304.field_6172, new AABBAlignedBoundingBox(0.0, 0.15, 0.0, 1.0, 0.45, 1.0));
        builder.put(class_1304.field_6174, new AABBAlignedBoundingBox(0.0, 0.45, 0.0, 1.0, 0.8, 1.0));
        builder.put(class_1304.field_6169, new AABBAlignedBoundingBox(0.0, 0.8, 0.0, 1.0, 1.0, 1.0));
        NORMAL_BOXES = Collections.unmodifiableMap(builder);
        builder = new LinkedHashMap();
        builder.put(class_1304.field_6166, new AABBAlignedBoundingBox(0.0, 0.0, 0.0, 1.0, 0.15, 1.0));
        builder.put(class_1304.field_6172, new AABBAlignedBoundingBox(0.0, 0.15, 0.0, 1.0, 0.4, 1.0));
        builder.put(class_1304.field_6174, new AABBAlignedBoundingBox(0.0, 0.4, 0.0, 1.0, 0.75, 1.0));
        builder.put(class_1304.field_6169, new AABBAlignedBoundingBox(0.0, 0.75, 0.0, 1.0, 1.0, 1.0));
        SNEAKING_BOXES = Collections.unmodifiableMap(builder);
    }
}

