/*
 * Decompiled with CFR 0.152.
 */
package dev.sygii.realpain.body;

import dev.sygii.realpain.PainMain;
import dev.sygii.realpain.body.BodyPart;
import dev.sygii.realpain.body.damage.DamageDistribution;
import dev.sygii.realpain.body.damage.distribution.SplitAllDamageDistribution;
import dev.sygii.realpain.body.debuff.DebuffRunner;
import dev.sygii.realpain.body.debuff.TickedDebuff;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;

public class Body {
    public final HashMap<class_2960, BodyPart> bodyParts = new HashMap();
    public final HashMap<class_1304, ArrayList<BodyPart>> slotToPart = new HashMap();
    public final class_1309 entity;
    public float bodyWeight;
    public final Map<class_1657, Pair<class_1297, class_239>> hitList = new WeakHashMap<class_1657, Pair<class_1297, class_239>>();
    public final Map<class_1291, List<TickedDebuff>> debuffs = new WeakHashMap<class_1291, List<TickedDebuff>>();
    public DamageDistribution currentDistribution = null;
    public boolean hasBeenDamaged = false;
    public boolean fatality = false;
    public boolean newlyLoaded = false;

    public Body(class_1309 entity) {
        this.entity = entity;
    }

    public void initBodyParts() {
        for (BodyPart part : this.bodyParts.values()) {
            if (this.entity instanceof class_1657) {
                // empty if block
            }
            part.health = part.getPartMaxHealth();
        }
    }

    public void addBodyPart(class_2960 id, BodyPart part) {
        part.id = id;
        part.mainBody = this;
        this.bodyWeight += part.healthWeight;
        this.bodyParts.put(part.id, part);
    }

    public void addSlotPart(class_1304 slot, class_2960 id) {
        if (this.slotToPart.get(slot) == null) {
            this.slotToPart.put(slot, new ArrayList());
        }
        this.slotToPart.get(slot).add(this.getPart(id));
    }

    public void addTickedDebuff(class_2960 id, class_1291 effect, int duration, DebuffRunner runner) {
        if (this.debuffs.get(effect) == null) {
            this.debuffs.put(effect, new ArrayList());
        }
        this.debuffs.get(effect).add(new TickedDebuff(this.getPart(id), duration, runner));
    }

    public void tick() {
    }

    public DamageDistribution getDistribution(class_1282 source) {
        for (DamageDistribution dist : PainMain.damageDistributionMap) {
            dist.getRealParts().clear();
            for (class_2960 partId : dist.getBodyPartsList()) {
                dist.addRealPart(this.getPart(partId));
            }
            if (!dist.shouldApply(source, this.entity)) continue;
            return dist;
        }
        return null;
    }

    public DamageDistribution get() {
        if (this.currentDistribution != null) {
            return this.currentDistribution;
        }
        PainMain.log("Falling back to split damage (null)");
        SplitAllDamageDistribution defaultReturn = new SplitAllDamageDistribution();
        this.getBodyParts().values().forEach(defaultReturn::addRealPart);
        return defaultReturn;
    }

    public void setDistribution(class_1282 source) {
        this.currentDistribution = this.getDistribution(source);
        this.hasBeenDamaged = true;
    }

    public float applyDamage(float original, float amount) {
        DamageDistribution dist = this.get();
        PainMain.log(String.valueOf(dist.getIdentifier()) + " " + amount);
        dist.handleDamage(amount, dist.getRealParts(), this.entity, this);
        if (this.isFatal()) {
            this.setFatality(false);
            return 0.0f;
        }
        this.hasBeenDamaged = false;
        return original;
    }

    public boolean isFatal() {
        return this.fatality;
    }

    public void setFatality(boolean fatal) {
        this.fatality = fatal;
    }

    public void applyHealing(float amount) {
    }

    public BodyPart getPart(class_2960 identifier) {
        return this.getBodyParts().get(identifier);
    }

    public List<BodyPart> getPartForSlot(class_1304 slot) {
        return this.slotToPart.get(slot);
    }

    public HashMap<class_2960, BodyPart> getBodyParts() {
        return this.bodyParts;
    }
}

