/*
 * Decompiled with CFR 0.152.
 */
package dev.sygii.realpain.body;

import dev.sygii.realpain.PainMain;
import dev.sygii.realpain.body.Body;
import dev.sygii.realpain.body.debuff.HitDebuff;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_591;
import net.minecraft.class_742;

public class BodyPart {
    public final class_1309 entity;
    public final float healthWeight;
    public final BodySide side;
    public final boolean fatal;
    public Body mainBody;
    public float health;
    public class_2960 id;
    public BodyPart parent;
    public List<BodyPart> children = new ArrayList<BodyPart>();
    public final List<HitDebuff> hitDebuffs = new ArrayList<HitDebuff>();
    public final List<class_1304> activeSlots = new ArrayList<class_1304>();

    public BodyPart(class_1309 entity, float healthWeight) {
        this(entity, healthWeight, BodySide.CENTER, false);
    }

    public BodyPart(class_1309 entity, float healthWeight, BodySide side) {
        this(entity, healthWeight, side, false);
    }

    public BodyPart(class_1309 entity, float healthWeight, boolean fatal) {
        this(entity, healthWeight, BodySide.CENTER, fatal);
    }

    public BodyPart(class_1309 entity, float healthWeight, BodySide side, boolean fatal) {
        this.entity = entity;
        this.healthWeight = healthWeight;
        this.side = side;
        this.fatal = fatal;
    }

    public void renderModel(class_591<class_742> model, class_4587 matrices, class_4588 vc, int light, int overlay) {
    }

    public void renderFlat(class_332 context, class_4587 matrices, class_4588 vc, int light, int overlay) {
    }

    public int getColor() {
        int[] damageColors = new int[]{-4784128, -492544, -9882, -7352832, -9587378};
        float healthPercentage = this.getPartHealth() / this.getPartMaxHealth();
        int size = damageColors.length - 1;
        Color merged = BodyPart.interpolateColorHue(new Color(0xB70000), new Color(6347564), healthPercentage);
        return merged.getRGB();
    }

    public float[] getColors() {
        int[] damageColors = new int[]{-4784128, -492544, -9882, -7352832, -9587378};
        float healthPercentage = this.getPartHealth() / this.getPartMaxHealth();
        int size = damageColors.length - 1;
        Color merged = BodyPart.interpolateColorHue(new Color(0xB70000), new Color(6347564), healthPercentage);
        int color = merged.getRGB();
        int j = (color & 0xFF0000) >> 16;
        int k = (color & 0xFF00) >> 8;
        int l = (color & 0xFF) >> 0;
        return new float[]{(float)j / 255.0f, (float)k / 255.0f, (float)l / 255.0f};
    }

    public static Double interpolate(double oldValue, double newValue, double interpolationValue) {
        return oldValue + (newValue - oldValue) * interpolationValue;
    }

    public static float interpolateFloat(float oldValue, float newValue, double interpolationValue) {
        return BodyPart.interpolate(oldValue, newValue, (float)interpolationValue).floatValue();
    }

    public static int interpolateInt(int oldValue, int newValue, double interpolationValue) {
        return BodyPart.interpolate(oldValue, newValue, (float)interpolationValue).intValue();
    }

    public static Color interpolateColorC(Color color1, Color color2, float amount) {
        amount = Math.min(1.0f, Math.max(0.0f, amount));
        return new Color(BodyPart.interpolateInt(color1.getRed(), color2.getRed(), amount), BodyPart.interpolateInt(color1.getGreen(), color2.getGreen(), amount), BodyPart.interpolateInt(color1.getBlue(), color2.getBlue(), amount), BodyPart.interpolateInt(color1.getAlpha(), color2.getAlpha(), amount));
    }

    public static Color interpolateColorHue(Color color1, Color color2, float amount) {
        amount = Math.min(1.0f, Math.max(0.0f, amount));
        float[] color1HSB = Color.RGBtoHSB(color1.getRed(), color1.getGreen(), color1.getBlue(), null);
        float[] color2HSB = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null);
        Color resultColor = Color.getHSBColor(BodyPart.interpolateFloat(color1HSB[0], color2HSB[0], amount), BodyPart.interpolateFloat(color1HSB[1], color2HSB[1], amount), BodyPart.interpolateFloat(color1HSB[2], color2HSB[2], amount));
        return new Color(resultColor.getRed(), resultColor.getGreen(), resultColor.getBlue(), BodyPart.interpolateInt(color1.getAlpha(), color2.getAlpha(), amount));
    }

    public void heal(float amount) {
        float remainingToHeal = this.getPartMaxHealth() - this.health;
        if (amount > remainingToHeal) {
            float remaining = amount - remainingToHeal;
            int childSize = 0;
            for (BodyPart child : this.children) {
                if (!(child.getPartHealth() < child.getPartMaxHealth())) continue;
                ++childSize;
            }
            for (BodyPart child : this.children) {
                if (!(child.getPartHealth() < child.getPartMaxHealth())) continue;
                PainMain.log("Healing child: " + remaining / (float)childSize);
                child.heal(remaining / (float)childSize);
            }
        }
        this.setHealth(this.health + amount);
    }

    public void takeDamage(float amount) {
        if (amount > this.health) {
            float remaining = amount - this.health;
            if (this.parent != null) {
                this.parent.takeDamage(remaining);
            }
        }
        this.setHealth(this.health - amount);
        if (this.fatal && this.getPartHealth() <= 0.0f) {
            this.mainBody.setFatality(true);
        }
        for (HitDebuff hitDebuff : this.hitDebuffs) {
            class_1309 class_13092;
            if (!(this.getPartHealth() <= this.getPartMaxHealth() * hitDebuff.threshold()) || !((class_13092 = this.entity) instanceof class_3222)) continue;
            class_3222 serverPlayerEntity = (class_3222)class_13092;
            if (serverPlayerEntity.field_13987 == null) continue;
            this.entity.method_6092(new class_1293(hitDebuff.effect(), hitDebuff.duration(), hitDebuff.amplifier()));
        }
    }

    public void fillInTheBlank(float amount) {
        this.health = Math.min(Math.max(amount, 0.0f), 100.0f);
    }

    public void setHealth(float amount) {
        this.health = Math.min(Math.max(amount, 0.0f), this.getPartMaxHealth());
    }

    public float getPartHealth() {
        return this.health;
    }

    public float getPartMaxHealth() {
        if (this.entity == null || this.entity.method_29504()) {
            return 1.0f;
        }
        return this.entity.method_6063() * (this.healthWeight / this.mainBody.bodyWeight);
    }

    public void addChild(BodyPart child) {
        this.children.add(child);
    }

    public BodyPart setParent(BodyPart parent) {
        parent.addChild(this);
        this.parent = parent;
        return this;
    }

    public static enum BodySide {
        CENTER,
        LEFT,
        RIGHT;

    }
}

