/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.epfd.block.entity.base;

import me.jddev0.ep.block.entity.base.UpgradableEnergyStorageBlockEntity;
import me.jddev0.ep.energy.IEnergizedPowerEnergyStorage;
import me.jddev0.ep.machine.configuration.IRedstoneModeHandler;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurableUpgradableEnergyStorageBlockEntity<E extends IEnergizedPowerEnergyStorage>
extends UpgradableEnergyStorageBlockEntity<E>
implements RedstoneModeUpdate,
IRedstoneModeHandler {
    @NotNull
    protected RedstoneMode redstoneMode = RedstoneMode.IGNORE;

    public ConfigurableUpgradableEnergyStorageBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, String machineName, int baseEnergyCapacity, int baseEnergyTransferRate, UpgradeModuleModifier ... upgradeModifierSlots) {
        super(type, blockPos, blockState, machineName, baseEnergyCapacity, baseEnergyTransferRate, upgradeModifierSlots);
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putInt("configuration.redstone_mode", this.redstoneMode.ordinal());
    }

    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.redstoneMode = RedstoneMode.fromIndex((int)nbt.getInt("configuration.redstone_mode"));
    }

    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex((int)(this.redstoneMode.ordinal() + 1));
        this.setChanged();
    }

    @NotNull
    public @NotNull RedstoneMode @NotNull [] getAvailableRedstoneModes() {
        return RedstoneMode.values();
    }

    @NotNull
    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public boolean setRedstoneMode(@NotNull RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        this.setChanged();
        return true;
    }
}

