/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.epfd.datagen;

import java.util.Objects;
import me.jddev0.epfd.block.EPFDBlocks;
import me.jddev0.epfd.block.ElectricStoveBlock;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "energizedpowerfd", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.registerBlocks();
    }

    private void registerBlocks() {
        this.activatableOrientableBlockWithItem((Holder<? extends Block>)EPFDBlocks.ELECTRIC_STOVE, this.orientableBlockModel((Holder<? extends Block>)EPFDBlocks.ELECTRIC_STOVE, true), this.orientableBlockModel((Holder<? extends Block>)EPFDBlocks.ELECTRIC_STOVE, "_on", "_top_on", "_bottom", "_front_on", "_side"), ElectricStoveBlock.LIT);
        this.activatableOrientableBlockWithItem((Holder<? extends Block>)EPFDBlocks.INDUCTION_STOVE, this.orientableBlockModel((Holder<? extends Block>)EPFDBlocks.INDUCTION_STOVE, true), this.orientableBlockModel((Holder<? extends Block>)EPFDBlocks.INDUCTION_STOVE, "_on", "_top_on", "_bottom", "_front_on", "_side"), ElectricStoveBlock.LIT);
    }

    private ModelFile orientableBlockModel(Holder<? extends Block> block, boolean uniqueBottomTexture) {
        return this.orientableBlockModel(block, "", "_top", uniqueBottomTexture ? "_bottom" : "_top", "_front", "_side");
    }

    private ModelFile orientableBlockModel(Holder<? extends Block> block, String fileSuffix, String topSuffix, String bottomSuffix, String frontSuffix, String sideSuffix) {
        ResourceLocation blockId = Objects.requireNonNull(block.getKey()).location();
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.getPath() + fileSuffix, "block/orientable")).texture("particle", "#top")).texture("top", this.getBlockTexture(block, topSuffix))).texture("bottom", this.getBlockTexture(block, bottomSuffix))).texture("front", this.getBlockTexture(block, frontSuffix))).texture("side", this.getBlockTexture(block, sideSuffix));
    }

    private void activatableOrientableBlockWithItem(Holder<? extends Block> block, ModelFile modelNormal, ModelFile modelActive, BooleanProperty isActiveProperty) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.value()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(modelActive).addModel()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(false)).modelForState().rotationY(180).modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(true)).modelForState().rotationY(180).modelFile(modelActive).addModel()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(false)).modelForState().rotationY(90).modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(true)).modelForState().rotationY(90).modelFile(modelActive).addModel()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(false)).modelForState().rotationY(270).modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(true)).modelForState().rotationY(270).modelFile(modelActive).addModel()).partialState();
        this.simpleBlockItem((Block)block.value(), modelNormal);
    }

    private ResourceLocation getBlockTexture(Holder<? extends Block> block, String pathSuffix) {
        ResourceLocation blockId = Objects.requireNonNull(block.getKey()).location();
        return ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)("block/" + blockId.getPath() + pathSuffix));
    }
}

