/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.epfd.block.entity;

import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.util.EnergyUtils;
import me.jddev0.epfd.block.entity.base.ConfigurableUpgradableEnergyStorageBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.energy.IEnergyStorage;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.tag.ModTags;

public abstract class AbstractStoveBlockEntity
extends ConfigurableUpgradableEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage> {
    protected final int baseEnergyConsumptionPerTick;
    protected boolean hasEnoughEnergy;
    protected int timeoutOffState;

    public AbstractStoveBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, String machineName, int baseEnergyCapacity, int baseEnergyTransferRate, int baseEnergyConsumptionPerTick) {
        super(type, blockPos, blockState, machineName, baseEnergyCapacity, baseEnergyTransferRate, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.baseEnergyConsumptionPerTick = baseEnergyConsumptionPerTick;
    }

    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * AbstractStoveBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            public int getMaxReceive() {
                return Math.max(1, (int)Math.ceil((double)this.maxReceive * AbstractStoveBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            protected void onChange() {
                AbstractStoveBlockEntity.this.m_6596_();
                AbstractStoveBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    protected ContainerData initContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> AbstractStoveBlockEntity.this.redstoneMode.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        AbstractStoveBlockEntity.this.redstoneMode = RedstoneMode.fromIndex((int)value);
                    }
                }
            }

            public int m_6499_() {
                return 1;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)("container.energizedpowerfd." + this.machineName));
    }

    public int getRedstoneOutput() {
        return EnergyUtils.getRedstoneSignalFromEnergyStorage((IEnergyStorage)this.energyStorage);
    }

    protected void litBlock() {
        if (this.f_58857_.m_8055_(this.m_58899_()).m_61138_((Property)BlockStateProperties.f_61443_) && !((Boolean)this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    protected void unlitBlock() {
        if (this.f_58857_.m_8055_(this.m_58899_()).m_61138_((Property)BlockStateProperties.f_61443_) && ((Boolean)this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, AbstractStoveBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (blockEntity.timeoutOffState > 0) {
            --blockEntity.timeoutOffState;
            if (blockEntity.timeoutOffState == 0) {
                blockEntity.unlitBlock();
                AbstractStoveBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
            }
        }
        if (!blockEntity.redstoneMode.isActive(((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue())) {
            blockEntity.unlitBlock();
            return;
        }
        if (blockEntity.hasSkilletOrCookingPot()) {
            int energyConsumptionPerTick = Math.max(1, (int)Math.ceil((double)blockEntity.baseEnergyConsumptionPerTick * blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
            if (energyConsumptionPerTick <= ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()) {
                blockEntity.hasEnoughEnergy = true;
                blockEntity.timeoutOffState = 0;
                blockEntity.litBlock();
                ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() - energyConsumptionPerTick);
                AbstractStoveBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
            } else {
                blockEntity.hasEnoughEnergy = false;
                if (blockEntity.timeoutOffState == 0) {
                    blockEntity.timeoutOffState = (Integer)ModConfigs.COMMON_OFF_STATE_TIMEOUT.getValue();
                }
                AbstractStoveBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
            }
        } else {
            if (blockEntity.timeoutOffState == 0) {
                blockEntity.timeoutOffState = (Integer)ModConfigs.COMMON_OFF_STATE_TIMEOUT.getValue();
            }
            AbstractStoveBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private boolean hasSkilletOrCookingPot() {
        BlockPos testPos = this.f_58858_.m_7494_();
        BlockState testState = this.f_58857_.m_8055_(testPos);
        if (testState.m_204336_(ModTags.HEAT_CONDUCTORS)) {
            testPos = testPos.m_7494_();
            testState = this.f_58857_.m_8055_(testPos);
        }
        return testState.m_60713_((Block)ModBlocks.SKILLET.get()) || testState.m_60713_((Block)ModBlocks.COOKING_POT.get());
    }
}

